#!/bin/sh

useDropbear=${useDropbear:-"true"}

vlasovsoft_usbnet=/mnt/onboard/.kobo/vlasovsoft/usbnet

mode="up"
if [ -f /var/run/dropbear.pid ]; then
  kill `cat /var/run/dropbear.pid`
  mode="down"
fi

if ifconfig | grep -q usb0; then
  ifconfig usb0 down
  rmmod g_ether
  rmmod arcotg_udc
  mode="down"
fi

[ "$mode" == "down" ] && exit

driver_root=/drivers/$PLATFORM/usb/gadget
insmod $driver_root/arcotg_udc.ko
insmod $driver_root/g_ether.ko host_addr=46:0d:9e:67:69:eb dev_addr=46:0d:9e:67:69:ec
ifconfig usb0 192.168.2.101
if [ "$?" -ne "0" ] ; then
  exit 1
fi

if [ "$useDropbear" == "true" ] && [ -d "$vlasovsoft_usbnet" ]; then
  [ ! -e /usr/libexec/sftp-server ] && (mkdir -p /usr/libexec; ln -sf $vlasovsoft_usbnet/sftp-server /usr/libexec/sftp-server)
  $vlasovsoft_usbnet/dropbear -E -r $vlasovsoft_usbnet/host.key.rsa -d $vlasovsoft_usbnet/host.key.dss > $vlasovsoft_usbnet/dropbear.log 2>&1
fi

