#!/bin/sh
ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}
theimage=$ksmroot/images/test01.png
imgprg=$ksmroot/kbmessage
################################
# set toggle and info values
toggleoptiontext="add/substract"
togglevalues="toggle-add toggle-substract"
infolines=2
infotext=""
################################
# read arguments
if [[ $# -lt 1 ]]; then
  thevalue="500"
  denominations="1000 500 200 100 50 20 10 5 2 1"
elif [[ $# -eq 1 ]]; then
  if [ "$1" -eq "$1" ] 2> /dev/null; then
    thevalue=$1
  else
    thevalue=500
  fi
  denominations="1000 500 200 100 50 20 10 5 2 1"
else
  if [ "$1" -eq "$1" ] 2> /dev/null; then
    thevalue=$1
  else
    thevalue=500
  fi
  shift
  denominations=$@
  correct="true"
  for var in $denominations
  do
    if ! [ "$var" -eq "$var" ] 2> /dev/null; then
      correct="false"
    fi
  done
  if [ "$correct"=="false" ]; then
    denominations="1000 500 200 100 50 20 10 5 2 1"
  fi
fi
################################
# load some variables for kobomenu
. $ksmroot/onstart/exp_block
################################
getnexttoggleoption() {
  cnt=0;
  i=-1;
  OLDIFS="$IFS"
  IFS=" "
  for toption in $2
  do
    if [ "$toption" == "$1" ]; then
      let i=cnt
    fi
# ((++cnt))
    let ++cnt
  done
  let lastel=cnt-1
  if [ $i -eq -1 ] || [ $i -eq $lastel ]; then
    i=0
  else
    let ++i
  fi
  cnt=0
  for toption in $2
  do
    if [ $cnt -eq $i ]; then
      tresult=$toption
      break
    fi
#    ((++cnt))
    let ++cnt
  done
  IFS="$OLDIFS"
  echo $tresult
}
################################
setoptions() {
#optionlist=""
  optionlist="-infotext=$infotext<br>$thevalue"
  optionlist="$optionlist -infolines=$infolines"
  if [ "$toggleoptiontext" != "" ]; then
    optionlist="$optionlist $toggleoptiontext:toggle.png"
  fi
  optionlist="$optionlist show_image clear $denominations"
}
################################
################################
# preselect first toggle option
toggleoption=$(getnexttoggleoption "x12y45" "$togglevalues")
infotext="current_mode:_$toggleoption"
################################
# do the loop
selectedoption=""
while [ "$selectedoption" != "EXIT" ]; do
  setoptions
  selectedoption=$($ksmroot/kobomenu $optionlist return:arrowup.png -qws)
  case "$selectedoption" in
    cancle )
      echo "failed"
      selectedoption="EXIT";;
    clear )
      thevalue=0;;
    show_image)
      $imgprg "<img src=\"$theimage\" width='$thevalue' />" -qws
      ;;
    $toggleoptiontext)
      toggleoption=$(getnexttoggleoption "$toggleoption" "$togglevalues")
      infotext="current_mode:_$toggleoption"
      ;;
    return)
      selectedoption="EXIT";;
    *)
      if [ "$toggleoption" == "toggle-add" ]; then
        thevalue=`expr $thevalue + $selectedoption`
      else
        thevalue=`expr $thevalue - $selectedoption`
      fi
      ;;
  esac
done




