#!/bin/sh

ksmroot=${ksmroot:-"/mnt/onboard/.kobo/kbmenu"}

frontlightprg=$ksmroot/tools/frontlight
installUpdate="TRUE"
preserveRcS="FALSE"
isFirstRun="TRUE"
KSMdebugmode=false


# switch off leds begin
echo "ch 4" > /sys/devices/platform/pmic_light.1/lit
echo "cur 0" > /sys/devices/platform/pmic_light.1/lit
echo "dc 0" > /sys/devices/platform/pmic_light.1/lit
#switch off leds end

if [ "$PRODUCT" == "phoenix" ]; then
  ksmGeometryValuesN=748x1014+1+3
  ksmGeometryValuesS=748x1014+1+3
  ksmGeometryValuesE=1014x748+1+3
  ksmGeometryValuesW=1014x748+1+3
else
  ksmGeometryValuesN=
  ksmGeometryValuesS=
  ksmGeometryValuesE=
  ksmGeometryValuesW=
fi

case $PRODUCT in
  kraken)
    ksmImageWidthPortrait=724
    ksmImageWidthLandscape=800
    ;;
  phoenix)
    ksmImageWidthPortrait=714
    ksmImageWidthLandscape=790
    ;;
  dragon)
    ksmImageWidthPortrait=1040
    ksmImageWidthLandscape=1384
    ;;
  dahlia)
    ksmImageWidthPortrait=1040
    ksmImageWidthLandscape=1384
    ;;
  *)
    ksmImageWidthPortrait=566
    ksmImageWidthLandscape=750
    ;;
esac

case $PRODUCT in
  kraken)
    kobomenuFontsize=40
    kobomenuMenuBarFontsize=35
    ;;
  phoenix)
    kobomenuFontsize=40
    kobomenuMenuBarFontsize=35
    ;;
  dragon)
    kobomenuFontsize=50
    kobomenuMenuBarFontsize=40
    ;;
  dahlia)
    kobomenuFontsize=40
    kobomenuMenuBarFontsize=35
    ;;
  *)
    kobomenuFontsize=35
    kobomenuMenuBarFontsize=25
    ;;
esac



modelnr=$(sh $ksmroot/onstart/getmodelnr.sh)
case $modelnr in
  310 ) PRODUCT_ID=0x4163;;
  320 ) PRODUCT_ID=0x4163;;
  330 ) PRODUCT_ID=0x4173;;
  340 ) PRODUCT_ID=0x4183;;
  350 ) PRODUCT_ID=0x4193;;
  360 ) PRODUCT_ID=0x4203;;
  370 ) PRODUCT_ID=0x4213;;
  * ) PRODUCT_ID=unknown;;
esac
export PRODUCT_ID



frontlightOnLevel=4
insertCRportrait=true
insertCRlandscape=true
combineCoolreaderAdditions=true
insertNickelKoreaderSwitch=true
insertKoreaderNickelSwitch=true
selectKoreaderVersion=true
combineKoreaderAdditions=true
enablerotation=false
preventfreeze=true
ksmAutoselectafter=-1
ksmAutoselectoption=
useDropbear=true
useMultiplefonts=true


if [ -e $ksmroot/usersettings.txt ]; then
  checkscript=$(sh -n $ksmroot/usersettings.txt 2>&1)
  if [ "$checkscript" == "" ]; then
    . $ksmroot/usersettings.txt
  fi
elif [ -e $ksmroot/usersettings_template ]; then
  cp "$ksmroot/usersettings_template" "$ksmroot/usersettings.txt"
fi

if [ "$insertCRportrait" != "true" ] && [ "$insertCRlandscape" != "true" ]; then
  combineCoolreaderAdditions=false
fi

if [ "$KSMdebugmode" == "true" ]; then
  debug_logfile=/mnt/onboard/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
  echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
  echo "script path: $0" >> $debug_logfile
  echo "ksmroot: $ksmroot" >> $debug_logfile
  echo "PRODUCT: $PRODUCT" >> $debug_logfile
  echo "PRODUCT_ID: $PRODUCT_ID" >> $debug_logfile
  echo "ksmGeometryValuesN: $ksmGeometryValuesN"  >> $debug_logfile
  echo "ksmGeometryValuesE: $ksmGeometryValuesE"  >> $debug_logfile
  echo "ksmGeometryValuesS: $ksmGeometryValuesS"  >> $debug_logfile
  echo "ksmGeometryValuesW: $ksmGeometryValuesW"  >> $debug_logfile
  sync
fi


export kobomenuFontsize
export kobomenuMenuBarFontsize
export ksmImageWidthPortrait
export ksmImageWidthLandscape
export ksmGeometryValuesN
export ksmGeometryValuesS
export ksmGeometryValuesE
export ksmGeometryValuesW
export KSMdebugmode

[ "$useMultiplefonts" == "true" ] && export QWS_NO_SHARE_FONTS=1

if [ "$PRODUCT" == "dragon" ] || [ "$PRODUCT" == "dahlia" ]; then
  sh $ksmroot/kobomenu.sh -autoselectafter=0
fi

fbrotatevalue=$(cat /sys/class/graphics/fb0/rotate)
export fbrotatevalue

if [ "$preventfreeze" == "true" ]; then
  sh $ksmroot/onstart/preventfreeze.sh &
fi

setoptions() {
  moptions=""
  if [ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ]; then
    moptions="$moptions front_light_on:execute.png front_light_off:execute.png"
  fi

  moptions="$moptions info:help"
  if [ "$enablerotation" == "true" ]; then
    moptions="$moptions toggle_rotation:toggle.png"
  fi
  mupdateoptions=""
  if [ -e /mnt/onboard/.kobo/Kobo.tgz ] || [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
    installUpdate="FALSE"
    moptions="$moptions handle_update:gear.png "
    if [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
      mupdateoptions="$mupdateoptions install_partial_update:execute.png"
    fi
    mupdateoptions="$mupdateoptions install_update:execute.png"
    mupdateoptions="$mupdateoptions delete_update:execute.png"
    mupdateoptions="$mupdateoptions return"
  fi

  moptions="$moptions start_nickel:book.png"

  if [ -e /mnt/onboard/.kobo/koreader/reader.lua ]; then
    moptions="$moptions start_koreader:book.png"
    if  [ "$combineKoreaderAdditions" == "true" ]; then
      KoreaderAdditionsmoptions=
      [ "$insertNickelKoreaderSwitch" == "true" ] && KoreaderAdditionsmoptions="$mKoreaderAdditionsmoptions start_nickel_koreader_switch:book.png"
      [ "$insertKoreaderNickelSwitch" == "true" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions start_koreader_nickel_switch:book.png"
      [ "$selectKoreaderVersion" == "true" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions select_koreader_version:menu.png"
      [ -d "$ksmroot/koreaderfindsh" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions find_and_open:menu.png"
      KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions return:arrowup.png"
      moptions="$moptions koreader_additions:menu.png"
    else
      [ "$insertNickelKoreaderSwitch" == "true" ] && moptions="$moptions start_nickel_koreader_switch:book.png"
      [ "$insertKoreaderNickelSwitch" == "true" ] && moptions="$moptions start_koreader_nickel_switch:book.png"
      [ "$selectKoreaderVersion" == "true" ] && moptions="$moptions select_koreader_version:menu.png"
      [ -d "$ksmroot/koreaderfindsh" ] && moptions="$moptions find_and_open:menu.png"
    fi
  fi
  if [ -e /mnt/onboard/.kobo/KoboLauncher/launcher ]; then
    moptions="$moptions start_kobolauncher:rocket.png"
  fi

  if [ -e /mnt/onboard/.kobo/vlasovsoft/launcher ]; then
    moptions="$moptions start_vlasovsoftlauncher:rocket.png"
    if  [ "$combineCoolreaderAdditions" == "true" ]; then
      CoolreaderAdditionsmoptions=
      [ "$insertCRportrait" == "true" ] && CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions start_coolreader:book.png"
      [ "$insertCRlandscape" == "true" ] && CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions start_coolreader_ls:book.png"
      CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions return:arrowup.png"
      moptions="$moptions coolreader:menu.png"
    else
      [ "$insertCRportrait" == "true" ] && moptions="$moptions start_coolreader:book.png"
      [ "$insertCRlandscape" == "true" ] && moptions="$moptions start_coolreader_ls:book.png"
    fi
  fi

  moptions="$moptions usb:usb.png wifi:wifi.png tools:menu.png scripts:menu.png sleep:moon reboot:restart.png power_off:poweroff.png"
}

mrotation="90"
export mrotation
udevadm trigger
#---- do the menu loop
selection=""
while [ "$selection" != "EXIT" ]; do
  setoptions
  if [ "$isFirstRun" == "TRUE" ] && [ "$ksmAutoselectoption" != "" ] && [ "$ksmAutoselectoption" != "reboot" ] && [ "$ksmAutoselectoption" != "power_off" ]; then
    moptions="-autoselectafter=$ksmAutoselectafter -autoselectoption=$ksmAutoselectoption $moptions"
    isFirstRun="FALSE"
  fi
  selection=$(sh $ksmroot/kobomenu.sh $moptions)
  case $selection in
    info )
      sh $ksmroot/kbmessage.sh "-f $ksmroot/txt/start_info.html"
      ;;
    handle_update )
      binfo="capacity: `cat /sys/devices/platform/pmic_battery.1/power_supply/mc13892_bat/capacity`"
      binfo=${binfo// /_}
      updateselection=$(sh $ksmroot/kobomenu.sh -infolines=1 "-infotext=$binfo" $mupdateoptions)
      case $updateselection in
        install_update )
          installUpdate="TRUE"
          preserveRcS="FALSE"
          selection="EXIT"
          ;;
        install_partial_update )
          installUpdate="TRUE"
          preserveRcS="TRUE"
          selection="EXIT"
          ;;
        delete_update )
          rm -f /mnt/onboard/.kobo/KoboRoot.tgz
          rm -f /mnt/onboard/.kobo/Kobo.tgz
          rm -rf /mnt/onboard/.kobo/upgrade
          rm -f /mnt/onboard/manifest.md5sum
          ;;
        return )
          updateselection=""
          ;;
      esac
      ;;
    toggle_rotation )
      if [ "$mrotation" == "0" ]; then
        mrotation="90"
      elif [ "$mrotation" == "90" ]; then
        mrotation="180"
      elif [ "$mrotation" == "180" ]; then
        mrotation="270"
      elif [ "$mrotation" == "270" ]; then
        mrotation="0"
      fi
      export mrotation
      ;;
    start_nickel )
      sh $ksmroot/onstart/startreader.sh
      ;;
    power_off )
      sh $ksmroot/onstart/poweroff.sh
      ;;
    sleep )
      sh $ksmroot/onstart/suspend.sh
      ;;
    reboot )
      reboot
      ;;
    usb )
      sh $ksmroot/onstart/scriptmenuusb.sh $ksmroot/scripts_intern/usb
      ;;
    wifi )
      sh $ksmroot/onstart/scriptmenuwifi.sh $ksmroot/scripts_intern/wifi
      ;;
    tools )
      sh $ksmroot/helpers/list_shscripts.msh $ksmroot/scripts_intern/tools
      ;;
    scripts )
      sh $ksmroot/helpers/list_shscripts.msh $ksmroot/scripts
      ;;
    start_koreader )
      sh $ksmroot/onstart/koreader_kobo.sh
      ;;
    start_nickel_koreader_switch )
      sh $ksmroot/onstart/nickelkoreaderloop.sh
      ;;
    start_koreader_nickel_switch )
      sh $ksmroot/onstart/koreadernickelloop.sh
      ;;
    koreader_additions )
      koreaderadditionsselection=$(sh $ksmroot/kobomenu.sh $KoreaderAdditionsmoptions $mupdateoptions)
      case $koreaderadditionsselection in
        start_nickel_koreader_switch )
          sh $ksmroot/onstart/nickelkoreaderloop.sh
          ;;
        start_koreader_nickel_switch )
          sh $ksmroot/onstart/koreadernickelloop.sh
          ;;
        find_and_open )
          sh $ksmroot/helpers/list_shscripts.msh "$ksmroot/koreaderfindsh"
          ;;
        select_koreader_version )
          sh $ksmroot/helpers/list_koreaderdirs.msh /mnt/onboard/.kobo/
          ;;
      esac
      ;;
    start_kobolauncher )
      sh $ksmroot/onstart/start_KoboLauncherA.sh
      ;;
    start_vlasovsoftlauncher )
      sh $ksmroot/onstart/start_vlasovlauncher.sh
      ;;
    start_coolreader )
      sh $ksmroot/onstart/cr3.sh
      ;;
    start_coolreader_ls )
      sh $ksmroot/onstart/cr3_180.sh
      ;;
    coolreader )
      coolreaderselection=$(sh $ksmroot/kobomenu.sh $CoolreaderAdditionsmoptions $mupdateoptions)
      case $coolreaderselection in
        start_coolreader )
          sh $ksmroot/onstart/cr3.sh
          ;;
        start_coolreader_ls )
          sh $ksmroot/onstart/cr3_180.sh
          ;;
      esac
      ;;

    front_light_on )
      $frontlightprg "$frontlightOnLevel"
      ;;
    front_light_off )
      $frontlightprg "0"
      ;;
  esac
done

if [ "$installUpdate" == "TRUE" ]; then

  if [ "$newpickelversion" == "TRUE" ]; then
    /usr/local/Kobo/pickel can-upgrade
    CAN_UPGRADE=$?
  else
    CAN_UPGRADE=1
  fi

  if [ $CAN_UPGRADE == 1 ] && [ -e /mnt/onboard/.kobo/Kobo.tgz ]; then
    zcat /mnt/onboard/.kobo/Kobo.tgz > /dev/null && tar zxf /mnt/onboard/.kobo/Kobo.tgz -C /usr/local/Kobo/ && ( cat /usr/local/Kobo/revinfo >> /usr/local/Kobo/install.log )
    rm /mnt/onboard/.kobo/Kobo.tgz
    echo "Done upgrading..."
  fi
                               
  if [ $CAN_UPGRADE == 1 ] && [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
    zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
    /etc/init.d/update-animator.sh &
    udevfiles="usb ac sd plug"
    udevdir="/usr/local/Kobo/udev"
    preservedir="$ksmroot/preserve"
    [ "$KSMdebugmode" == "true" ] && echo "udevfiles: $udevfiles" >> $debug_logfile
    [ "$KSMdebugmode" == "true" ] && echo "udevdir: $udevdir" >> $debug_logfile
    [ "$KSMdebugmode" == "true" ] && echo "preserveRcS: $preserveRcS" >> $debug_logfile

    if [ "$preserveRcS" == "TRUE"  ]; then
      [ ! -e $preservedir ] && mkdir -p $preservedir
      [ -f /etc/init.d/rcS ] && cp "/etc/init.d/rcS" "preservedir"
      for udevfile in $udevfiles; do
        [ -f "$udevdir/$udevfile" ] && cp "$udevdir/$udevfile" "$preservedir"
      done
    fi

    zcat /mnt/onboard/.kobo/KoboRoot.tgz > /dev/null && tar zxf /mnt/onboard/.kobo/KoboRoot.tgz -C / && ( cat /usr/local/Kobo/revinfo >> /usr/local/Kobo/install.log )

    if [ -e /mnt/onboard/.kobo/upgrade ]; then
      /etc/init.d/upgrade-wifi.sh
      rm -rf /mnt/onboard/.kobo/upgrade
    fi
    rm /mnt/onboard/.kobo/KoboRoot.tgz
    killall update-animator.sh
    echo "Done upgrading..."

    if [ "$preserveRcS" == "TRUE"  ]; then
      [ -f $preservedir/rcS ] && cp "$preservedir/rcS" "/etc/init.d"
      for udevfile in $udevfiles; do
        [ -f "$preservedir/$udevfile" ] && cp "$preservedir/$udevfile" "$udevdir"
      done
    fi

    zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
    zcat /etc/images/$PREFIX\reboot.raw.gz | /usr/local/Kobo/pickel showpic
    sync
    reboot
  fi

fi

# Emergency exit
reboot

