#!/bin/sh

if [ "$KSMdebugmode" == "true" ]; then
debug_logfile=/mnt/onboard/ksmdebug_$(date +%Y%m%d_%H%M%S)_$(basename $0).log
echo "started: $(date +%Y%m%d_%H%M%S)" > $debug_logfile
echo "script path: $0" >> $debug_logfile
echo "ksmroot: $ksmroot" >> $debug_logfile
echo "product: $PRODUCT" >> $debug_logfile
fi

KOREADER_DIR="$1"

if [ "$KSMdebugmode" == "true" ]; then
echo "KOREADER_DIR: $KOREADER_DIR" >> $debug_logfile
sync
fi

export LC_ALL="en_US.UTF-8"

if [ -e "$KOREADER_DIR/koreader.sh" ] && [ $(grep -c 'from_nickel' "$KOREADER_DIR/koreader.sh") -gt 0 ]; then

# update to new version from OTA directory
  NEWUPDATE=${KOREADER_DIR}/ota/koreader.updated.tar
  if [ -f $NEWUPDATE ]; then
# TODO: any graphic indication for the updating progress?
    cd /mnt/onboard/.kobo && tar xf $NEWUPDATE && rm $NEWUPDATE
  fi
fi
# we're always starting from our working directory
cd $KOREADER_DIR

# export trained OCR data directory
export TESSDATA_PREFIX="data"

args="/mnt/onboard"

# export dict directory
export STARDICT_DATA_DIR="data/dict"
./reader.lua $args 2> crash.log


 
