package klock;

import com.amazon.kindle.kindlet.AbstractKindlet;
import com.amazon.kindle.kindlet.KindletContext;
import com.amazon.kindle.kindlet.ui.KLabel;
import com.amazon.kindle.kindlet.ui.KRepaintManager;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import com.amazon.kindle.kindlet.ui.KindletUIResources.KFontFamilyName;
import java.util.Calendar;
import java.util.GregorianCalendar;
/**
 *
 * @author Andrew
 */
public class Main extends AbstractKindlet {

    public KindletContext ctx;
    public KLabel l_hour;
    public KLabel l_minute;
    public KLabel l_second;
    public KLabel l_date;
    public SimpleDateFormat timeFormat;
    
    private WorkerThread thread;
    
    public void create(KindletContext context) {
        this.ctx = context;
        
        timeFormat = new SimpleDateFormat("HH");
        timeFormat.setTimeZone(TimeZone.getTimeZone("PST"));
        
        try {
            ctx.getRootContainer().setLayout(null);
            
            l_hour = new KLabel("00");
            l_minute = new KLabel("00");
            l_second = new KLabel("00");
            l_date = new KLabel("Non, Nil 0 0000");
            
            // Alignment 0: Center
            // Alignment 1: ? (Right?)
            // Alignment 2: Nothing?
            String serif = KFontFamilyName.SERIF.getDisplayName();
            l_hour.setFont(new java.awt.Font(serif, 0, 410));
            l_minute.setFont(new java.awt.Font(serif, 0, 250));
            l_second.setFont(new java.awt.Font(serif, 0, 135));
            l_date.setFont(new java.awt.Font(serif, 0, 85));
            
            l_hour.setBounds(15, 10, 480, 480);
            l_minute.setBounds(480, 25, 300, 300);
            l_second.setBounds(500, 255, 170, 170);
            l_date.setBounds(30, 380, 800, 210);
            
            ctx.getRootContainer().add(l_date);
            ctx.getRootContainer().add(l_second);
            ctx.getRootContainer().add(l_minute);
            ctx.getRootContainer().add(l_hour);
            
            // Orientation 1: Upside down
            // Orientation 2: Sideways
            ctx.getOrientationController().lockOrientation(2);
            
            thread = new WorkerThread(this);
            thread.start();
            
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void start() {
        thread.shouldRun = true;
    }

    public void stop() {
        thread.shouldRun = false;
    }
    
    public void destroy() {
        
        thread.shouldExit = true;
        thread.interrupt();
    }
    
} 


class WorkerThread extends Thread {
    private Main main;
    public volatile boolean shouldRun = true;
    public volatile boolean shouldExit = false;
    private int _lastHour = 0;
    public WorkerThread(Main main) {
        this.main = main;
    }

    public void run() {
        for (;;) {
            if (shouldExit) { return; }
            if (shouldRun) {
                try {
                    updateScreen();
                    Thread.sleep(1000);
                } catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
            }
            else {
                try {
                    Thread.sleep(100);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return; 
                }
            }
        }
    }
    
    private void updateScreen() {
        if (main.l_hour != null && main.l_minute != null && main.l_second != null && main.l_date != null) {
            Date now = new Date();
            main.timeFormat.applyPattern("HH");
            main.l_hour.setText(main.timeFormat.format(now));
            main.timeFormat.applyPattern("mm");
            main.l_minute.setText(main.timeFormat.format(now));
            main.timeFormat.applyPattern("ss");
            main.l_second.setText(main.timeFormat.format(now));
            main.timeFormat.applyPattern("EEE, MMM dd yyyy");
            main.l_date.setText(main.timeFormat.format(now));
        }
        
        //Fully repaint once an hour to avoid ghosting too badly
        int hour = new GregorianCalendar().get(Calendar.HOUR_OF_DAY);
        if (hour != _lastHour) {
            try {
                KRepaintManager.paintImmediately(main.ctx.getRootContainer(), true);
                _lastHour = hour;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        
        main.ctx.getRootContainer().repaint(100);
    }
    
}