/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.kindle.kindlet.ui.KTextComponent;
import com.amazon.kindle.kindlet.ui.KTextLayout;
import com.amazon.kindle.kindlet.ui.KindletUIResources;
import com.amazon.kindle.kindlet.ui.g;
import com.amazon.kindle.kindlet.ui.r;
import com.amazon.kindle.kindlet.ui.x;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class KLabel
extends KTextComponent {
    public static final String PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
    private static final int DEFAULT_HALIGN = 2;
    private static final int DEFAULT_VALIGN = 0;
    private volatile int m_alignment;
    private volatile int m_verticalAlignment;
    private final x m_layout;
    private volatile String m_text;
    private volatile Dimension m_lastInputSize;
    private volatile Dimension m_preferredSizeCache;
    private final KTextLayout.LineList m_textLines;
    private volatile boolean m_isSetBackground;

    public KLabel() {
        this("");
    }

    public KLabel(String text) {
        this(text, 2, 0, null);
    }

    public KLabel(String text, int horizontalAlignment) {
        this(text, horizontalAlignment, 0, null);
    }

    KLabel(String a2, int a3, int a4, x a5) {
        KLabel a6;
        a6.checkHorizontalKey(a3, "Invalid horizontalAlignment passed into constructor.");
        a6.checkVerticalKey(a4, "Invalid verticalAlignment passed into constructor.");
        a6.m_isSetBackground = false;
        a6.m_lastInputSize = null;
        a6.m_preferredSizeCache = null;
        a6.m_textLines = new KTextLayout.LineList();
        a6.m_layout = null == a5 ? new x() : a5;
        a6.m_verticalAlignment = a4;
        a6.m_alignment = a3;
        a6.setFocusable(false);
        a6.setVisible(true);
        a6.setFont(KindletUIResources.getInstance().getBodyFont(KindletUIResources.KFontFamilyName.SERIF));
        a6.setText(a2);
    }

    public int getBaseline(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width or height argument is < 0.");
        }
        return this.m_layout.vpA(this, this.m_textLines, height);
    }

    public void setVerticalAlignment(int alignment) {
        int a2 = this.m_verticalAlignment;
        if (a2 != alignment) {
            this.m_verticalAlignment = this.checkVerticalKey(alignment, "Invalid vertical alignment value passed into method.");
            this.invalidate();
            this.firePropertyChange(PROPERTY_VERTICAL_ALIGNMENT, new Integer(a2), new Integer(alignment));
        }
    }

    public int getVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        int a2 = this.m_alignment;
        if (a2 != alignment) {
            this.m_alignment = this.checkHorizontalKey(alignment, "Invalid horizontal alignment value passed into method.");
            this.invalidate();
            this.firePropertyChange(PROPERTY_HORIZONTAL_ALIGNMENT, new Integer(a2), new Integer(alignment));
        }
    }

    public int getHorizontalAlignment() {
        return this.m_alignment;
    }

    protected int checkHorizontalKey(int key, String message) {
        if (key == 0 || key == 2 || key == 1) {
            return key;
        }
        throw new IllegalArgumentException(message);
    }

    protected int checkVerticalKey(int key, String message) {
        if (key == 0 || key == 4 || key == 3) {
            return key;
        }
        throw new IllegalArgumentException(message);
    }

    public void paint(Graphics g2) {
        this.validate();
        Rectangle a2 = g2.getClipBounds();
        if (a2 == null) {
            a2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        Color a3 = g2.getColor();
        Color a4 = this.m_isSetBackground ? this.getBackground() : this.getParent().getBackground();
        g2.setColor(a4);
        g2.fillRect(a2.x, a2.y, a2.width, a2.height);
        g2.setColor(a3);
        if (this.m_textLines.textBounds.intersects(a2)) {
            this.m_layout.ORA(this, this.m_textLines, g2);
        }
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension a2 = this.getAncestorMaxInteriorSize();
        if (null == this.m_preferredSizeCache || null == this.m_lastInputSize || a2.width != this.m_lastInputSize.width || a2.height != this.m_lastInputSize.height) {
            Dimension a3 = this.RpA(this.m_text, a2);
            this.m_preferredSizeCache = new Dimension(Math.min(a2.width, a3.width), a3.height);
            this.m_lastInputSize = a2;
        }
        return (Dimension)this.m_preferredSizeCache.clone();
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return super.getAlignmentY();
    }

    public void validateTree() {
        if (!this.isValid()) {
            this.dsA(this.m_textLines);
        }
        super.validateTree();
    }

    public void setBackground(Color background) {
        if (this.isChange(this.getBackground(), background)) {
            super.setBackground(background);
            this.m_isSetBackground = null != background;
            this.invalidate();
        }
    }

    public void setForeground(Color foreground) {
        if (this.isChange(this.getForeground(), foreground)) {
            super.setForeground(foreground);
            this.invalidate();
        }
    }

    public void setFont(Font font) {
        if (this.isChange(this.getFont(), font)) {
            this.invalidate();
            super.setFont(font);
        }
    }

    public void invalidate() {
        this.m_preferredSizeCache = null;
        this.m_lastInputSize = null;
        super.invalidate();
    }

    public void setText(String text) {
        if (null == text) {
            text = "";
        }
        if (null == this.m_text || !text.equals(this.m_text)) {
            this.m_text = text;
            this.invalidate();
        }
    }

    public String getText() {
        return this.m_text;
    }

    public boolean isEditable() {
        return false;
    }

    public void setEditable(boolean b2) {
    }

    x ARA() {
        KLabel a2;
        return a2.m_layout;
    }

    private Dimension dsA(KTextLayout.LineList a2) {
        KLabel a3;
        Dimension a4 = a3.getSize();
        a3.m_layout.kRA(g.PqA(a3), a2, a3.m_text, a4.width, a4.height, a3.m_alignment, a3.m_verticalAlignment, r.f, a3.isUsingMaxAscent(), a3.isUsingMaxDescent());
        return a4;
    }

    private Dimension RpA(String a2, Dimension a3) {
        KLabel a4;
        KTextLayout.LineList a5 = new KTextLayout.LineList();
        a4.m_layout.kRA(g.PqA(a4), a5, a2, a3.width, a3.height, 0, 4, r.K, a4.isUsingMaxAscent(), a4.isUsingMaxDescent());
        return a5.textBounds.getSize();
    }
}

