/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.kindle.kindlet.ui.KComponent;
import com.amazon.kindle.kindlet.ui.cb;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.ImageObserver;

public class KImage
extends KComponent
implements ImageObserver {
    public static final int STRETCH_TO_FIT = -3;
    public static final int SCALE_TO_FIT = -2;
    public static final int SHRINK_TO_FIT = -1;
    public static final int FROM_IMAGE = 0;
    private static final int SMALLEST_SCALE_CONSTANT = -3;
    public static final Alignment ALIGN_LEFT = new Alignment("left", null);
    public static final Alignment ALIGN_TOP = new Alignment("top", null);
    public static final Alignment ALIGN_CENTER = new Alignment("center", null);
    public static final Alignment ALIGN_RIGHT = new Alignment("right", null);
    public static final Alignment ALIGN_BOTTOM = new Alignment("bottom", null);
    private Alignment m_horizontalAlignment;
    private Alignment m_verticalAlignment;
    private int m_desiredWidth;
    private int m_desiredHeight;
    private Image m_image;
    private volatile int m_width;
    private volatile int m_height;
    private volatile Image m_scaledImage;
    private int m_scaledWidth;
    private int m_scaledHeight;

    public KImage(Image image, int width, int height, Alignment horizontalAlignment, Alignment verticalAlignment) {
        this.setFocusable(false);
        this.setDesiredSize(width, height);
        this.setHorizontalAlignment(horizontalAlignment);
        this.setVerticalAlignment(verticalAlignment);
        this.setImage(image);
    }

    public KImage(Image image) {
        this(image, 0, 0, ALIGN_CENTER, ALIGN_CENTER);
    }

    public KImage(Image image, int width, int height) {
        this(image, width, height, ALIGN_CENTER, ALIGN_CENTER);
    }

    public KImage(Image image, Alignment horizontalAlignment, Alignment verticalAlignment) {
        this(image, 0, 0, horizontalAlignment, verticalAlignment);
    }

    public void setImage(Image image) {
        this.setImage(image, false);
    }

    public void setImage(Image image, boolean waitForScale) {
        this.AqA();
        this.m_image = image;
        if (this.m_image != null) {
            MediaTracker a2 = new MediaTracker(this);
            a2.addImage(this.m_image, 0);
            try {
                a2.waitForID(0, 0L);
            }
            catch (InterruptedException a3) {
                this.m_width = 0;
                this.m_height = 0;
                Thread.currentThread().interrupt();
                return;
            }
            this.m_width = this.m_image.getWidth(this);
            this.m_height = this.m_image.getHeight(this);
        } else {
            this.m_width = 0;
            this.m_height = 0;
        }
        this.krA(this.getWidth(), this.getHeight(), waitForScale);
        this.invalidate();
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setDesiredSize(int width, int height) {
        if (width < -3) {
            throw new IllegalArgumentException("width must be greater than 0 or one of the documented constants");
        }
        if (height < -3) {
            throw new IllegalArgumentException("height must be greater than 0 or one of the documented constants");
        }
        this.m_desiredWidth = width;
        this.m_desiredHeight = height;
        this.AqA();
        this.eQA(this.getWidth(), this.getHeight());
    }

    public int getDesiredWidth() {
        return this.m_desiredWidth;
    }

    public int getDesiredHeight() {
        return this.m_desiredHeight;
    }

    public void setHorizontalAlignment(Alignment horizontalAlignment) {
        if (horizontalAlignment != ALIGN_LEFT && horizontalAlignment != ALIGN_CENTER && horizontalAlignment != ALIGN_RIGHT) {
            throw new IllegalArgumentException("horizontalAlignment must be one of ALIGN_LEFT, CENTER or ALIGN_RIGHT");
        }
        this.m_horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(Alignment verticalAlignment) {
        if (verticalAlignment != ALIGN_TOP && verticalAlignment != ALIGN_CENTER && verticalAlignment != ALIGN_BOTTOM) {
            throw new IllegalArgumentException("verticalAlignment must be one of ALIGN_TOP, ALIGN_CENTER, or ALIGN_BOTTOM");
        }
        this.m_verticalAlignment = verticalAlignment;
    }

    public Alignment getHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    public Alignment getVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int a2 = 0;
        int a3 = 0;
        a2 = this.m_desiredWidth > 0 ? this.m_desiredWidth : this.m_width;
        a3 = this.m_desiredHeight > 0 ? this.m_desiredHeight : this.m_height;
        return new Dimension(a2, a3);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        int a2 = 0;
        int a3 = 0;
        if (this.m_desiredWidth == 0) {
            a2 = this.m_width;
        } else if (this.m_desiredWidth > 0) {
            a2 = this.m_desiredWidth;
        }
        if (this.m_desiredHeight == 0) {
            a3 = this.m_height;
        } else if (this.m_desiredHeight > 0) {
            a3 = this.m_desiredHeight;
        }
        return new Dimension(a2, a3);
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        int a2 = Short.MAX_VALUE;
        int a3 = Short.MAX_VALUE;
        if (this.m_desiredWidth == 0 || this.m_desiredWidth == -1) {
            a2 = this.m_width;
        } else if (this.m_desiredWidth > 0) {
            a2 = this.m_desiredWidth;
        }
        if (this.m_desiredHeight == 0 || this.m_desiredHeight == -1) {
            a3 = this.m_height;
        } else if (this.m_desiredHeight > 0) {
            a3 = this.m_desiredHeight;
        }
        return new Dimension(a2, a3);
    }

    public void paint(Graphics g2) {
        if (this.m_scaledImage != null) {
            Point a2 = this.CRA();
            g2.drawImage(this.m_scaledImage, a2.x, a2.y, this);
        }
    }

    public void setBounds(int x2, int y2, int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            this.AqA();
            this.eQA(width, height);
        }
        super.setBounds(x2, y2, width, height);
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean imageUpdate(Image image, int flags, int x2, int y2, int width, int height) {
        if (image == this.m_scaledImage && (flags & 0x20) != 0) {
            this.onImageReady();
            return false;
        }
        return (flags & 0x80) == 0;
    }

    protected void onImageReady() {
        this.repaint();
    }

    void eQA(int a2, int a3) {
        KImage a4;
        a4.krA(a2, a3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void krA(int a2, int a3, boolean a4) {
        KImage a5;
        block26: {
            block25: {
                a5.AqA();
                if (a5.m_image == null) {
                    return;
                }
                if (a5.m_width < 0) return;
                if (a5.m_height < 0) {
                    return;
                }
                switch (a5.m_desiredWidth) {
                    case -2: {
                        a5.m_scaledWidth = -1;
                        break;
                    }
                    case -3: {
                        a5.m_scaledWidth = a2;
                        break;
                    }
                    case -1: {
                        if (a2 < a5.m_width) {
                            a5.m_scaledWidth = a2;
                            break;
                        }
                        a5.m_scaledWidth = a5.m_width;
                        break;
                    }
                    case 0: {
                        a5.m_scaledWidth = a5.m_width;
                        break;
                    }
                    default: {
                        a5.m_scaledWidth = a5.m_desiredWidth;
                    }
                }
                switch (a5.m_desiredHeight) {
                    case -2: {
                        a5.m_scaledHeight = -1;
                        break;
                    }
                    case -3: {
                        a5.m_scaledHeight = a3;
                        break;
                    }
                    case -1: {
                        if (a3 < a5.m_height) {
                            a5.m_scaledHeight = a3;
                            break;
                        }
                        a5.m_scaledHeight = a5.m_height;
                        break;
                    }
                    case 0: {
                        a5.m_scaledHeight = a5.m_height;
                        break;
                    }
                    default: {
                        a5.m_scaledHeight = a5.m_desiredHeight;
                    }
                }
                if (a5.m_scaledWidth >= 0) break block25;
                if (a5.m_scaledHeight < 0) {
                    a5.m_scaledWidth = a2;
                    a5.m_scaledHeight = Math.round((float)a5.m_height / (float)a5.m_width * (float)a5.m_scaledWidth);
                    if (a5.m_scaledHeight > a3) {
                        a5.m_scaledHeight = a3;
                        a5.m_scaledWidth = Math.round((float)a5.m_width / (float)a5.m_height * (float)a5.m_scaledHeight);
                    }
                    break block26;
                } else {
                    a5.m_scaledWidth = Math.round((float)a5.m_width * ((float)a5.m_scaledHeight / (float)a5.m_height));
                }
                break block26;
            }
            if (a5.m_scaledHeight < 0) {
                a5.m_scaledHeight = Math.round((float)a5.m_height * ((float)a5.m_scaledWidth / (float)a5.m_width));
            }
        }
        if (a5.m_scaledWidth == 0 || a5.m_scaledHeight == 0) {
            a5.m_scaledImage = null;
            return;
        }
        if (!a4) {
            a5.m_scaledImage = a5.m_image.getScaledInstance(a5.m_scaledWidth, a5.m_scaledHeight, 1);
            return;
        }
        if (a5.m_scaledWidth > 0 && a5.m_scaledHeight > 0 && a5.m_scaledWidth == a5.m_width && a5.m_scaledHeight == a5.m_height) {
            a5.m_scaledImage = a5.m_image;
            return;
        }
        a5.m_scaledImage = a5.m_image.getScaledInstance(a5.m_scaledWidth, a5.m_scaledHeight, 1);
        MediaTracker a6 = new MediaTracker(a5);
        a6.addImage(a5.m_scaledImage, 0);
        try {
            a6.waitForID(0, 0L);
            return;
        }
        catch (InterruptedException a7) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void AqA() {
        KImage a2;
        if (a2.m_scaledImage != null && a2.m_scaledImage != a2.m_image) {
            a2.m_scaledImage.flush();
        }
        a2.m_scaledImage = null;
    }

    Point CRA() {
        KImage a2;
        Point a3 = new Point(0, 0);
        if (a2.getHorizontalAlignment() == ALIGN_CENTER) {
            a3.x = (a2.getWidth() - a2.m_scaledWidth) / 2;
        }
        if (a2.getHorizontalAlignment() == ALIGN_RIGHT) {
            a3.x = a2.getWidth() - a2.m_scaledWidth;
        }
        if (a2.getVerticalAlignment() == ALIGN_CENTER) {
            a3.y = (a2.getHeight() - a2.m_scaledHeight) / 2;
        }
        if (a2.getVerticalAlignment() == ALIGN_BOTTOM) {
            a3.y = a2.getHeight() - a2.m_scaledHeight;
        }
        return a3;
    }

    public static class Alignment {
        private final String f;

        private Alignment(String a2) {
            Alignment a3;
            a3.f = a2;
        }

        public String toString() {
            return this.f;
        }

        /* synthetic */ Alignment(String a2, cb a3) {
            a4(a2);
            Alignment a4;
        }
    }
}

