/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.media;

import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class MediaSource {
    public static final int AUDIO_DATA_MP3 = 0;
    public static final int AUDIO_DATA_WAV = 1;
    public static final int AUDIO_DATA_UNKNOWN = 2;
    private final InputStream I;
    private final URL L;
    private final int l;
    static final Set K = new HashSet(){
        {
            1 a2;
            a2.add("file");
            a2.add("jar");
        }
    };

    public MediaSource(InputStream inputStream) {
        this(inputStream, 2);
    }

    public MediaSource(InputStream inputStream, int encoding) {
        this.uRA(encoding);
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream can not be null");
        }
        this.I = inputStream;
        this.L = null;
        this.l = encoding;
    }

    public MediaSource(URL url) {
        this(url, 2);
    }

    public MediaSource(URL url, int encoding) {
        this.uRA(encoding);
        this.pqA(url);
        this.I = null;
        this.L = url;
        this.l = encoding;
    }

    public InputStream getInputStream() {
        return this.I;
    }

    public URL getURL() {
        return this.L;
    }

    public int getEncodingType() {
        return this.l;
    }

    private void uRA(int a2) {
        switch (a2) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported media encoding: " + a2);
    }

    private void pqA(URL a2) {
        if (a2 == null) {
            throw new IllegalArgumentException("URL can not be null");
        }
        String a3 = a2.getProtocol();
        if (a3 == null || !K.contains(a3.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException("URL is not supported for media source.");
        }
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that.getClass() != MediaSource.class) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (this.getEncodingType() != ((MediaSource)that).getEncodingType()) {
            return false;
        }
        if (this.getURL() != null) {
            return this.getURL().equals(((MediaSource)that).getURL());
        }
        return this.getInputStream().equals(((MediaSource)that).getInputStream());
    }

    public int hashCode() {
        int a2 = 1 + this.getEncodingType();
        a2 = a2 * 31 + (this.getInputStream() == null ? 0 : this.getInputStream().hashCode());
        a2 = a2 * 31 + (this.getURL() == null ? 0 : this.getURL().hashCode());
        return a2;
    }
}

