/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.input.keyboard;

import java.awt.Rectangle;
import java.text.MessageFormat;

public class OnscreenKeyboardEvent {
    private static final String L = "{0} ({1, number, integer},{2, number, integer} {3, number, integer}x{4, number, integer})";
    public static final String KEYBOARD_MOVED = "KEYBOARD_MOVED";
    public static final String KEYBOARD_RESIZED = "KEYBOARD_RESIZED";
    public static final String KEYBOARD_SHOWN = "KEYBOARD_SHOWN";
    public static final String KEYBOARD_HIDDEN = "KEYBOARD_HIDDEN";
    private final Rectangle l;
    private final String K;
    private final long f;

    public OnscreenKeyboardEvent(Rectangle bounds, String type, long when) {
        if (bounds == null) {
            throw new IllegalArgumentException("Bounds provided to a onscreen keyboard event cannot be null");
        }
        if (type == null || !type.equals(KEYBOARD_MOVED) && !type.equals(KEYBOARD_RESIZED) && !type.equals(KEYBOARD_SHOWN) && !type.equals(KEYBOARD_HIDDEN)) {
            throw new IllegalArgumentException("Given type must be one of the types provided by this class");
        }
        this.l = bounds;
        this.K = type;
        this.f = when;
    }

    public Rectangle getBounds() {
        return this.l;
    }

    public String getType() {
        return this.K;
    }

    public long getWhen() {
        return this.f;
    }

    public String toString() {
        return MessageFormat.format(L, this.K, new Integer(this.l.x), new Integer(this.l.y), new Integer(this.l.width), new Integer(this.l.height));
    }
}

