/*
 * Decompiled with CFR 0.152.
 */
package com.lab126.util.framebuffer;

import com.lab126.util.framebuffer.FrameBufferJNI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class FrameBufferJNITest
extends Component {
    private static final long serialVersionUID = 1L;
    protected static final String image_path_name = "/opt/eink/images/rectangle.gif";
    protected static final Color darkGray = new Color(85, 85, 85);
    protected static final int RECT_HEIGHT = 40;
    protected static final int RECT_WIDTH = 64;
    private static boolean erase = false;
    public MediaTracker image_tracker;
    public Dimension screen;
    public Toolkit toolkit;
    public Frame frame;
    public Image image;

    public FrameBufferJNITest() {
        FrameBufferJNITest a2;
    }

    public static void main(String[] a2) {
        FrameBufferJNITest a3 = new FrameBufferJNITest();
        new FrameBufferJNITest().toolkit = Toolkit.getDefaultToolkit();
        a3.screen = a3.toolkit.getScreenSize();
        a3.frame = new Frame();
        a3.frame.setSize(a3.screen.width, a3.screen.height);
        a3.frame.setResizable(true);
        a3.frame.add(a3);
        a3.image_tracker = new MediaTracker(a3);
        a3.image = a3.toolkit.createImage(image_path_name);
        a3.image_tracker.addImage(a3.image, 0);
        try {
            a3.image_tracker.waitForID(0);
        }
        catch (Exception a4) {
            System.out.println("main: exception occurred:");
            a4.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("DPI is " + FrameBufferJNI.getDisplayDPI());
            System.out.println("Rotating to portrait...");
            FrameBufferJNI.rotateDisplay(0);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            a3.screen = a3.toolkit.getScreenSize();
            System.out.println("screen is " + a3.screen);
            a3.setSize(a3.screen.width, a3.screen.height);
            a3.frame.setSize(a3.screen.width, a3.screen.height);
            System.out.println("test   is " + a3.getBounds());
            System.out.println("frame  is " + a3.frame.getBounds());
            a3.repaint();
            a3.frame.setVisible(true);
            System.out.println("Flashing, area update...");
            Rectangle a5 = new Rectangle(0, 0, 64, 40);
            Rectangle[] a6 = new Rectangle[]{a5};
            FrameBufferJNI.sendAreaUpdate(3, a6);
            Thread.sleep(2000L);
            System.out.println("Rotating to portrait upside down...");
            FrameBufferJNI.rotateDisplay(1);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            Thread.sleep(2000L);
            System.out.println("Rotating to landscape...");
            FrameBufferJNI.rotateDisplay(2);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            a3.screen = a3.toolkit.getScreenSize();
            System.out.println("screen is " + a3.screen);
            a3.setSize(a3.screen.width, a3.screen.height);
            a3.frame.setSize(a3.screen.width, a3.screen.height);
            System.out.println("test   is " + a3.getBounds());
            System.out.println("frame  is " + a3.frame.getBounds());
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(0);
            System.out.println("Rotating to landscape upside down...");
            FrameBufferJNI.rotateDisplay(3);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            Thread.sleep(2000L);
            System.out.println("Rotating back to portrait...");
            FrameBufferJNI.rotateDisplay(0);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            a3.screen = a3.toolkit.getScreenSize();
            System.out.println("screen is " + a3.screen);
            a3.setSize(a3.screen.width, a3.screen.height);
            a3.frame.setSize(a3.screen.width, a3.screen.height);
            System.out.println("test   is " + a3.getBounds());
            System.out.println("frame  is " + a3.frame.getBounds());
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(0);
            System.out.println("Rotating to portrait upside down without auto-repainting...");
            FrameBufferJNI.rotateDisplayAndRestoreDisplayOnFlip(1, false);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            Thread.sleep(2000L);
            System.out.println("Erasing screen...");
            erase = true;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(0);
            System.out.println("Repainting screen...");
            erase = false;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(0);
            System.out.println("Rotating back to portrait...");
            FrameBufferJNI.rotateDisplayAndRestoreDisplayOnFlip(0, true);
            System.out.println("orientation is " + FrameBufferJNI.getDisplayOrientation());
            Thread.sleep(2000L);
            System.out.println("Fast update followed by slow...");
            System.out.println("Erasing screen...");
            erase = true;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(0);
            System.out.println("Repainting screen...");
            erase = false;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(2);
            FrameBufferJNI.sendFullScreenUpdate(3);
            System.out.println("Bufferd update followed by displaying it...");
            System.out.println("Erasing screen...");
            erase = true;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(0);
            System.out.println("Repainting screen...");
            erase = false;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.sendFullScreenUpdate(99);
            FrameBufferJNI.sendFullScreenUpdate(100);
            System.out.println("Erasing screen...");
            erase = true;
            a3.repaint();
            Thread.sleep(2000L);
            FrameBufferJNI.clearScreen();
        }
        catch (Exception a7) {
            System.out.println("main: exception occurred:");
            a7.printStackTrace();
            System.exit(1);
        }
        System.out.println("Exiting FrameBufferJNITest");
        System.exit(0);
    }

    public void paint(Graphics a2) {
        FrameBufferJNITest a3;
        a2.setClip(0, 0, a3.screen.width, a3.screen.height);
        System.out.println("clip   is " + a2.getClip());
        a2.setColor(Color.white);
        a2.fillRect(0, 0, a3.screen.width, a3.screen.height);
        if (!erase) {
            Rectangle a4 = new Rectangle(0, 0, 64, 40);
            a2.setColor(darkGray);
            a2.fillRect(a4.x, a4.y, a4.width, a4.height);
            a2.setColor(Color.black);
            a2.fillRect(a3.screen.width - a4.width, a3.screen.height - a4.height, a4.width, a4.height);
            a2.drawImage(a3.image, (a3.screen.width - a4.width) / 2, (a3.screen.height - a4.height) / 2, null);
        }
    }
}

