/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MessageFormat
extends UFormat {
    static final long serialVersionUID = 7136212545847378651L;
    private Locale locale;
    private ULocale ulocale;
    private String pattern = "";
    private static final int INITIAL_FORMATS = 10;
    private Format[] formats = new Format[10];
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private String[] argumentNames = new String[10];
    private boolean argumentNamesAreNumeric = true;
    private int maxOffset = -1;
    private static final String[] typeList = new String[]{"", "number", "date", "time", "choice", "spellout", "ordinal", "duration", "plural"};
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_DATE = 2;
    private static final int TYPE_TIME = 3;
    private static final int TYPE_CHOICE = 4;
    private static final int TYPE_SPELLOUT = 5;
    private static final int TYPE_ORDINAL = 6;
    private static final int TYPE_DURATION = 7;
    private static final int TYPE_PLURAL = 8;
    private static final String[] modifierList = new String[]{"", "currency", "percent", "integer"};
    private static final int MODIFIER_EMPTY = 0;
    private static final int MODIFIER_CURRENCY = 1;
    private static final int MODIFIER_PERCENT = 2;
    private static final int MODIFIER_INTEGER = 3;
    private static final String[] dateModifierList = new String[]{"", "short", "medium", "long", "full"};
    private static final int DATE_MODIFIER_EMPTY = 0;
    private static final int DATE_MODIFIER_SHORT = 1;
    private static final int DATE_MODIFIER_MEDIUM = 2;
    private static final int DATE_MODIFIER_LONG = 3;
    private static final int DATE_MODIFIER_FULL = 4;
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_IN_QUOTE = 2;
    private static final int STATE_MSG_ELEMENT = 3;
    private static UnicodeSet IDStartChars = new UnicodeSet("[:ID_Start:]");
    private static UnicodeSet IDContChars = new UnicodeSet("[:ID_Continue:]");

    public MessageFormat(String pattern) {
        this.ulocale = ULocale.getDefault();
        this.applyPattern(pattern);
    }

    public MessageFormat(String pattern, Locale locale) {
        this(pattern, ULocale.forLocale(locale));
    }

    public MessageFormat(String pattern, ULocale locale) {
        this.ulocale = locale;
        this.applyPattern(pattern);
    }

    public void setLocale(Locale locale) {
        this.setLocale(ULocale.forLocale(locale));
    }

    public void setLocale(ULocale locale) {
        String existingPattern = this.toPattern();
        this.ulocale = locale;
        this.applyPattern(existingPattern);
    }

    public Locale getLocale() {
        return this.ulocale.toLocale();
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public void applyPattern(String pttrn) {
        StringBuffer[] segments = new StringBuffer[4];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = new StringBuffer();
        }
        int part = 0;
        int formatNumber = 0;
        boolean inQuote = false;
        int braceStack = 0;
        this.maxOffset = -1;
        block7: for (int i = 0; i < pttrn.length(); ++i) {
            char ch = pttrn.charAt(i);
            if (part == 0) {
                if (ch == '\'') {
                    if (i + 1 < pttrn.length() && pttrn.charAt(i + 1) == '\'') {
                        segments[part].append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = !inQuote;
                    continue;
                }
                if (ch == '{' && !inQuote) {
                    part = 1;
                    continue;
                }
                segments[part].append(ch);
                continue;
            }
            if (inQuote) {
                segments[part].append(ch);
                if (ch != '\'') continue;
                inQuote = false;
                continue;
            }
            switch (ch) {
                case ',': {
                    if (part < 3) {
                        ++part;
                        continue block7;
                    }
                    segments[part].append(ch);
                    continue block7;
                }
                case '{': {
                    ++braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '}': {
                    if (braceStack == 0) {
                        part = 0;
                        this.makeFormat(i, formatNumber, segments);
                        ++formatNumber;
                        continue block7;
                    }
                    --braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '\'': {
                    inQuote = true;
                }
                default: {
                    segments[part].append(ch);
                }
            }
        }
        if (braceStack == 0 && part != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        this.pattern = segments[0].toString();
    }

    public String toPattern() {
        int lastOffset = 0;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i <= this.maxOffset; ++i) {
            MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.offsets[i], result);
            lastOffset = this.offsets[i];
            result.append('{');
            result.append(this.argumentNames[i]);
            if (this.formats[i] != null) {
                if (this.formats[i] instanceof DecimalFormat) {
                    if (this.formats[i].equals(NumberFormat.getInstance(this.ulocale))) {
                        result.append(",number");
                    } else if (this.formats[i].equals(NumberFormat.getCurrencyInstance(this.ulocale))) {
                        result.append(",number,currency");
                    } else if (this.formats[i].equals(NumberFormat.getPercentInstance(this.ulocale))) {
                        result.append(",number,percent");
                    } else if (this.formats[i].equals(NumberFormat.getIntegerInstance(this.ulocale))) {
                        result.append(",number,integer");
                    } else {
                        result.append(",number," + ((DecimalFormat)this.formats[i]).toPattern());
                    }
                } else if (this.formats[i] instanceof SimpleDateFormat) {
                    if (this.formats[i].equals(DateFormat.getDateInstance(2, this.ulocale))) {
                        result.append(",date");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(3, this.ulocale))) {
                        result.append(",date,short");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(1, this.ulocale))) {
                        result.append(",date,long");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(0, this.ulocale))) {
                        result.append(",date,full");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(2, this.ulocale))) {
                        result.append(",time");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(3, this.ulocale))) {
                        result.append(",time,short");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(1, this.ulocale))) {
                        result.append(",time,long");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(0, this.ulocale))) {
                        result.append(",time,full");
                    } else {
                        result.append(",date," + ((SimpleDateFormat)this.formats[i]).toPattern());
                    }
                } else if (this.formats[i] instanceof ChoiceFormat) {
                    result.append(",choice," + ((ChoiceFormat)this.formats[i]).toPattern());
                } else if (this.formats[i] instanceof PluralFormat) {
                    result.append(", plural, support for converting PluralFormat to pattern not yet available.");
                }
            }
            result.append('}');
        }
        MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.pattern.length(), result);
        return result.toString();
    }

    public void setFormatsByArgumentIndex(Format[] newFormats) {
        if (!this.argumentNamesAreNumeric) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        for (int i = 0; i <= this.maxOffset; ++i) {
            int j = Integer.parseInt(this.argumentNames[i]);
            if (j >= newFormats.length) continue;
            this.formats[i] = newFormats[j];
        }
    }

    public void setFormatsByArgumentName(Map newFormats) {
        for (int i = 0; i <= this.maxOffset; ++i) {
            Format f;
            if (!newFormats.containsKey(this.argumentNames[i])) continue;
            this.formats[i] = f = (Format)newFormats.get(this.argumentNames[i]);
        }
    }

    public void setFormats(Format[] newFormats) {
        int runsToCopy = newFormats.length;
        if (runsToCopy > this.maxOffset + 1) {
            runsToCopy = this.maxOffset + 1;
        }
        for (int i = 0; i < runsToCopy; ++i) {
            this.formats[i] = newFormats[i];
        }
    }

    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        if (!this.argumentNamesAreNumeric) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        for (int j = 0; j <= this.maxOffset; ++j) {
            if (Integer.parseInt(this.argumentNames[j]) != argumentIndex) continue;
            this.formats[j] = newFormat;
        }
    }

    public void setFormatByArgumentName(String argumentName, Format newFormat) {
        for (int i = 0; i < this.maxOffset; ++i) {
            if (!argumentName.equals(this.argumentNames[i])) continue;
            this.formats[i] = newFormat;
        }
    }

    public void setFormat(int formatElementIndex, Format newFormat) {
        this.formats[formatElementIndex] = newFormat;
    }

    public Format[] getFormatsByArgumentIndex() {
        if (!this.argumentNamesAreNumeric) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        int maximumArgumentNumber = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            int argumentNumber = Integer.parseInt(this.argumentNames[i]);
            if (argumentNumber <= maximumArgumentNumber) continue;
            maximumArgumentNumber = argumentNumber;
        }
        Format[] resultArray = new Format[maximumArgumentNumber + 1];
        for (int i = 0; i <= this.maxOffset; ++i) {
            resultArray[Integer.parseInt((String)this.argumentNames[i])] = this.formats[i];
        }
        return resultArray;
    }

    public Format[] getFormats() {
        Format[] resultArray = new Format[this.maxOffset + 1];
        System.arraycopy(this.formats, 0, resultArray, 0, this.maxOffset + 1);
        return resultArray;
    }

    public final StringBuffer format(Object[] arguments, StringBuffer result, FieldPosition pos) {
        if (!this.argumentNamesAreNumeric) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        return this.subformat(arguments, result, pos, null);
    }

    public final StringBuffer format(Map arguments, StringBuffer result, FieldPosition pos) {
        return this.subformat(arguments, result, pos, null);
    }

    public static String format(String pattern, Object[] arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    public static String format(String pattern, Map arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    public boolean usesNamedArguments() {
        return !this.argumentNamesAreNumeric;
    }

    public final StringBuffer format(Object arguments, StringBuffer result, FieldPosition pos) {
        if (arguments == null || arguments instanceof Map) {
            return this.subformat((Map)arguments, result, pos, null);
        }
        if (!this.argumentNamesAreNumeric) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        return this.subformat((Object[])arguments, result, pos, null);
    }

    public Object[] parse(String source, ParsePosition pos) {
        if (!this.argumentNamesAreNumeric) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use named argument.");
        }
        Map objectMap = this.parseToMap(source, pos);
        int maximumArgumentNumber = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            int argumentNumber = Integer.parseInt(this.argumentNames[i]);
            if (argumentNumber <= maximumArgumentNumber) continue;
            maximumArgumentNumber = argumentNumber;
        }
        if (objectMap == null) {
            return null;
        }
        Object[] resultArray = new Object[maximumArgumentNumber + 1];
        Iterator keyIter = objectMap.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            resultArray[Integer.parseInt((String)key)] = objectMap.get(key);
        }
        return resultArray;
    }

    public Map parseToMap(String source, ParsePosition pos) {
        if (source == null) {
            HashMap empty = new HashMap();
            return empty;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int patternOffset = 0;
        int sourceOffset = pos.getIndex();
        ParsePosition tempStatus = new ParsePosition(0);
        for (int i = 0; i <= this.maxOffset; ++i) {
            int len = this.offsets[i] - patternOffset;
            if (len == 0 || this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
                sourceOffset += len;
                patternOffset += len;
            } else {
                pos.setErrorIndex(sourceOffset);
                return null;
            }
            if (this.formats[i] == null) {
                int tempLength = i != this.maxOffset ? this.offsets[i + 1] : this.pattern.length();
                int next = patternOffset >= tempLength ? source.length() : source.indexOf(this.pattern.substring(patternOffset, tempLength), sourceOffset);
                if (next < 0) {
                    pos.setErrorIndex(sourceOffset);
                    return null;
                }
                String strValue = source.substring(sourceOffset, next);
                if (!strValue.equals("{" + this.argumentNames[i] + "}")) {
                    resultMap.put(this.argumentNames[i], source.substring(sourceOffset, next));
                }
                sourceOffset = next;
                continue;
            }
            tempStatus.setIndex(sourceOffset);
            resultMap.put(this.argumentNames[i], this.formats[i].parseObject(source, tempStatus));
            if (tempStatus.getIndex() == sourceOffset) {
                pos.setErrorIndex(sourceOffset);
                return null;
            }
            sourceOffset = tempStatus.getIndex();
        }
        int len = this.pattern.length() - patternOffset;
        if (len != 0 && !this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
            pos.setErrorIndex(sourceOffset);
            return null;
        }
        pos.setIndex(sourceOffset + len);
        return resultMap;
    }

    public Object[] parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object[] result = this.parse(source, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", pos.getErrorIndex());
        }
        return result;
    }

    public Map parseToMap(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Map result = this.parseToMap(source, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", pos.getErrorIndex());
        }
        return result;
    }

    public Object parseObject(String source, ParsePosition pos) {
        if (this.argumentNamesAreNumeric) {
            return this.parse(source, pos);
        }
        return this.parseToMap(source, pos);
    }

    public Object clone() {
        MessageFormat other = (MessageFormat)super.clone();
        other.formats = (Format[])this.formats.clone();
        for (int i = 0; i < this.formats.length; ++i) {
            if (this.formats[i] == null) continue;
            other.formats[i] = (Format)this.formats[i].clone();
        }
        other.offsets = (int[])this.offsets.clone();
        other.argumentNames = (String[])this.argumentNames.clone();
        other.argumentNamesAreNumeric = this.argumentNamesAreNumeric;
        return other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFormat other = (MessageFormat)obj;
        return this.maxOffset == other.maxOffset && this.pattern.equals(other.pattern) && Utility.objectEquals(this.ulocale, other.ulocale) && Utility.arrayEquals(this.offsets, (Object)other.offsets) && Utility.arrayEquals(this.argumentNames, (Object)other.argumentNames) && Utility.arrayEquals(this.formats, (Object)other.formats) && this.argumentNamesAreNumeric == other.argumentNamesAreNumeric;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private StringBuffer subformat(Object[] arguments, StringBuffer result, FieldPosition fp, List characterIterators) {
        return this.subformat(this.arrayToMap(arguments), result, fp, characterIterators);
    }

    private StringBuffer subformat(Map arguments, StringBuffer result, FieldPosition fp, List characterIterators) {
        int lastOffset = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            result.append(this.pattern.substring(lastOffset, this.offsets[i]));
            lastOffset = this.offsets[i];
            String argumentName = this.argumentNames[i];
            if (arguments == null || !arguments.containsKey(argumentName)) {
                result.append("{" + argumentName + "}");
                continue;
            }
            Object obj = arguments.get(argumentName);
            String arg = null;
            Format subFormatter = null;
            if (obj == null) {
                arg = "null";
            } else if (this.formats[i] != null) {
                subFormatter = this.formats[i];
                if ((subFormatter instanceof ChoiceFormat || subFormatter instanceof PluralFormat) && (arg = this.formats[i].format(obj)).indexOf(123) >= 0) {
                    subFormatter = new MessageFormat(arg, this.ulocale);
                    obj = arguments;
                    arg = null;
                }
            } else if (obj instanceof Number) {
                subFormatter = NumberFormat.getInstance(this.ulocale);
            } else if (obj instanceof Date) {
                subFormatter = DateFormat.getDateTimeInstance(3, 3, this.ulocale);
            } else if (obj instanceof String) {
                arg = (String)obj;
            } else {
                arg = obj.toString();
                if (arg == null) {
                    arg = "null";
                }
            }
            if (subFormatter != null) {
                arg = subFormatter.format(obj);
            }
            result.append(arg);
        }
        result.append(this.pattern.substring(lastOffset, this.pattern.length()));
        return result;
    }

    private void makeFormat(int position, int offsetNumber, StringBuffer[] segments) {
        int argumentNumber;
        if (offsetNumber >= this.formats.length) {
            int newLength = this.formats.length * 2;
            Format[] newFormats = new Format[newLength];
            int[] newOffsets = new int[newLength];
            String[] newArgumentNames = new String[newLength];
            System.arraycopy(this.formats, 0, newFormats, 0, this.maxOffset + 1);
            System.arraycopy(this.offsets, 0, newOffsets, 0, this.maxOffset + 1);
            System.arraycopy(this.argumentNames, 0, newArgumentNames, 0, this.maxOffset + 1);
            this.formats = newFormats;
            this.offsets = newOffsets;
            this.argumentNames = newArgumentNames;
        }
        int oldMaxOffset = this.maxOffset;
        this.maxOffset = offsetNumber;
        this.offsets[offsetNumber] = segments[0].length();
        this.argumentNames[offsetNumber] = segments[1].toString();
        try {
            argumentNumber = Integer.parseInt(segments[1].toString());
        }
        catch (NumberFormatException e) {
            argumentNumber = -1;
        }
        if (offsetNumber == 0) {
            boolean bl = this.argumentNamesAreNumeric = argumentNumber >= 0;
        }
        if (this.argumentNamesAreNumeric && argumentNumber < 0 || !this.argumentNamesAreNumeric && !this.isAlphaIdentifier(this.argumentNames[offsetNumber])) {
            throw new IllegalArgumentException("All argument identifiers have to be either non-negative numbers or strings following the pattern ([:ID_Start:] [:ID_Continue:]*).\nFor more details on these unicode sets, visit http://demo.icu-project.org/icu-bin/ubrowse");
        }
        Format newFormat = null;
        block5 : switch (MessageFormat.findKeyword(segments[2].toString(), typeList)) {
            case 0: {
                break;
            }
            case 1: {
                switch (MessageFormat.findKeyword(segments[3].toString(), modifierList)) {
                    case 0: {
                        newFormat = NumberFormat.getInstance(this.ulocale);
                        break block5;
                    }
                    case 1: {
                        newFormat = NumberFormat.getCurrencyInstance(this.ulocale);
                        break block5;
                    }
                    case 2: {
                        newFormat = NumberFormat.getPercentInstance(this.ulocale);
                        break block5;
                    }
                    case 3: {
                        newFormat = NumberFormat.getIntegerInstance(this.ulocale);
                        break block5;
                    }
                }
                newFormat = new DecimalFormat(segments[3].toString(), new DecimalFormatSymbols(this.ulocale));
                break;
            }
            case 2: {
                switch (MessageFormat.findKeyword(segments[3].toString(), dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getDateInstance(2, this.ulocale);
                        break block5;
                    }
                    case 1: {
                        newFormat = DateFormat.getDateInstance(3, this.ulocale);
                        break block5;
                    }
                    case 2: {
                        newFormat = DateFormat.getDateInstance(2, this.ulocale);
                        break block5;
                    }
                    case 3: {
                        newFormat = DateFormat.getDateInstance(1, this.ulocale);
                        break block5;
                    }
                    case 4: {
                        newFormat = DateFormat.getDateInstance(0, this.ulocale);
                        break block5;
                    }
                }
                newFormat = new SimpleDateFormat(segments[3].toString(), this.ulocale);
                break;
            }
            case 3: {
                switch (MessageFormat.findKeyword(segments[3].toString(), dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getTimeInstance(2, this.ulocale);
                        break block5;
                    }
                    case 1: {
                        newFormat = DateFormat.getTimeInstance(3, this.ulocale);
                        break block5;
                    }
                    case 2: {
                        newFormat = DateFormat.getTimeInstance(2, this.ulocale);
                        break block5;
                    }
                    case 3: {
                        newFormat = DateFormat.getTimeInstance(1, this.ulocale);
                        break block5;
                    }
                    case 4: {
                        newFormat = DateFormat.getTimeInstance(0, this.ulocale);
                        break block5;
                    }
                }
                newFormat = new SimpleDateFormat(segments[3].toString(), this.ulocale);
                break;
            }
            case 4: {
                try {
                    newFormat = new ChoiceFormat(segments[3].toString());
                    break;
                }
                catch (Exception e) {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("Choice Pattern incorrect");
                }
            }
            case 5: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 1);
                String ruleset = segments[3].toString().trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 6: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 2);
                String ruleset = segments[3].toString().trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 7: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 3);
                String ruleset = segments[3].toString().trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 8: {
                StringBuffer unquotedPattern = new StringBuffer();
                String quotedPattern = segments[3].toString();
                boolean inQuote = false;
                for (int i = 0; i < quotedPattern.length(); ++i) {
                    char ch = quotedPattern.charAt(i);
                    if (ch == '\'') {
                        if (i + 1 < quotedPattern.length() && quotedPattern.charAt(i + 1) == '\'') {
                            unquotedPattern.append(ch);
                            ++i;
                            continue;
                        }
                        inQuote = !inQuote;
                        continue;
                    }
                    unquotedPattern.append(ch);
                }
                PluralFormat pls = new PluralFormat(this.ulocale, unquotedPattern.toString());
                newFormat = pls;
                break;
            }
            default: {
                this.maxOffset = oldMaxOffset;
                throw new IllegalArgumentException("unknown format type at ");
            }
        }
        this.formats[offsetNumber] = newFormat;
        segments[1].setLength(0);
        segments[2].setLength(0);
        segments[3].setLength(0);
    }

    private static final int findKeyword(String s, String[] list) {
        s = s.trim().toLowerCase();
        for (int i = 0; i < list.length; ++i) {
            if (!s.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    private static final void copyAndFixQuotes(String source, int start, int end, StringBuffer target) {
        boolean gotLB = false;
        for (int i = start; i < end; ++i) {
            char ch = source.charAt(i);
            if (ch == '{') {
                target.append("'{'");
                gotLB = true;
                continue;
            }
            if (ch == '}') {
                if (gotLB) {
                    target.append(ch);
                    gotLB = false;
                    continue;
                }
                target.append("'}'");
                continue;
            }
            if (ch == '\'') {
                target.append("''");
                continue;
            }
            target.append(ch);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isValid;
        in.defaultReadObject();
        if (this.argumentNames == null) {
            this.argumentNamesAreNumeric = true;
            this.argumentNames = new String[this.argumentNumbers.length];
            for (int i = 0; i < this.argumentNumbers.length; ++i) {
                this.argumentNames[i] = String.valueOf(this.argumentNumbers[i]);
            }
        }
        boolean bl = isValid = this.maxOffset >= -1 && this.formats.length > this.maxOffset && this.offsets.length > this.maxOffset && this.argumentNames.length > this.maxOffset;
        if (isValid) {
            int lastOffset = this.pattern.length() + 1;
            for (int i = this.maxOffset; i >= 0; --i) {
                if (this.offsets[i] < 0 || this.offsets[i] > lastOffset) {
                    isValid = false;
                    break;
                }
                lastOffset = this.offsets[i];
            }
        }
        if (!isValid) {
            throw new InvalidObjectException("Could not reconstruct MessageFormat from corrupt stream.");
        }
        if (this.ulocale == null) {
            this.ulocale = ULocale.forLocale(this.locale);
        }
    }

    private Map arrayToMap(Object[] array) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                map.put(Integer.toString(i), array[i]);
            }
        }
        return map;
    }

    private boolean isAlphaIdentifier(String argument) {
        if (argument.length() == 0) {
            return false;
        }
        for (int i = 0; i < argument.length(); ++i) {
            if ((i != 0 || IDStartChars.contains(argument.charAt(i))) && (i <= 0 || IDContChars.contains(argument.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static String autoQuoteApostrophe(String pattern) {
        StringBuffer buf = new StringBuffer(pattern.length() * 2);
        int state = 0;
        int braceCount = 0;
        int j = pattern.length();
        for (int i = 0; i < j; ++i) {
            char c = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 1;
                            break;
                        }
                        case '{': {
                            state = 3;
                            ++braceCount;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            state = 2;
                            break block0;
                        }
                    }
                    buf.append('\'');
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '{': {
                            ++braceCount;
                            break;
                        }
                        case '}': {
                            if (--braceCount != 0) break;
                            state = 0;
                        }
                    }
                    break;
                }
            }
            buf.append(c);
        }
        if (state == 1 || state == 2) {
            buf.append('\'');
        }
        return new String(buf);
    }
}

