/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -3463448656717690166L;
    final ReadLock readerLock_;
    final WriteLock writerLock_;
    final Sync sync;

    public ReentrantReadWriteLock() {
        ReentrantReadWriteLock a;
        a.readerLock_ = new ReadLock(a);
        a.writerLock_ = new WriteLock(a);
        a.sync = new NonfairSync();
    }

    public Lock writeLock() {
        ReentrantReadWriteLock a;
        return a.writerLock_;
    }

    public Lock readLock() {
        ReentrantReadWriteLock a;
        return a.readerLock_;
    }

    public final boolean isFair() {
        return false;
    }

    protected Thread getOwner() {
        ReentrantReadWriteLock a;
        return a.sync.getOwner();
    }

    public int getReadLockCount() {
        ReentrantReadWriteLock a;
        return a.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        ReentrantReadWriteLock a;
        return a.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        ReentrantReadWriteLock a;
        return a.sync.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        ReentrantReadWriteLock a;
        return a.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        ReentrantReadWriteLock a;
        return a.sync.getReadHoldCount();
    }

    public final boolean hasQueuedThreads() {
        ReentrantReadWriteLock a;
        return a.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        ReentrantReadWriteLock a;
        return a.sync.getQueueLength();
    }

    public String toString() {
        ReentrantReadWriteLock a;
        return super.toString() + "[Write locks = " + a.getWriteHoldCount() + ", Read locks = " + a.getReadLockCount() + "]";
    }

    public static class WriteLock
    implements Lock,
    CondVar.ExclusiveLock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        final ReentrantReadWriteLock lock;

        protected WriteLock(ReentrantReadWriteLock a) {
            WriteLock a2;
            if (a == null) {
                throw new NullPointerException();
            }
            a2.lock = a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            WriteLock a;
            WriteLock writeLock = a;
            synchronized (writeLock) {
                if (a.lock.sync.Pv()) {
                    return;
                }
                boolean a2 = Thread.interrupted();
                try {
                    do {
                        try {
                            a.wait();
                        }
                        catch (InterruptedException a3) {
                            a2 = true;
                        }
                    } while (!a.lock.sync.Xw());
                    return;
                }
                finally {
                    if (a2) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            WriteLock a;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException a2 = null;
            WriteLock writeLock = a;
            synchronized (writeLock) {
                if (!a.lock.sync.Pv()) {
                    try {
                        do {
                            a.wait();
                        } while (!a.lock.sync.Xw());
                        return;
                    }
                    catch (InterruptedException a3) {
                        a.lock.sync.Gw();
                        a.notify();
                        a2 = a3;
                    }
                }
            }
            if (a2 != null) {
                a.lock.readerLock_.CX();
                throw a2;
            }
        }

        public boolean tryLock() {
            WriteLock a;
            return a.lock.sync.DV();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long a, TimeUnit a2) throws InterruptedException {
            WriteLock a3;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException a4 = null;
            long a5 = a2.toNanos(a);
            WriteLock writeLock = a3;
            synchronized (writeLock) {
                block10: {
                    if (a5 <= 0L) {
                        return a3.lock.sync.DV();
                    }
                    if (a3.lock.sync.Pv()) {
                        return true;
                    }
                    long a6 = Utils.nanoTime() + a5;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(a3, a5);
                        }
                        catch (InterruptedException a7) {
                            a3.lock.sync.Gw();
                            a3.notify();
                            a4 = a7;
                            break block10;
                        }
                        if (!a3.lock.sync.Xw()) continue;
                        return true;
                    } while ((a5 = a6 - Utils.nanoTime()) > 0L);
                    a3.lock.sync.Gw();
                    a3.notify();
                }
            }
            a3.lock.readerLock_.CX();
            if (a4 != null) {
                throw a4;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void unlock() {
            WriteLock a;
            switch (a.lock.sync.Ox()) {
                case 0: {
                    return;
                }
                case 1: {
                    a.lock.readerLock_.CX();
                    return;
                }
                case 2: {
                    a.lock.writerLock_.CX();
                    return;
                }
            }
        }

        public Condition newCondition() {
            WriteLock a;
            return new CondVar(a);
        }

        synchronized void CX() {
            WriteLock a;
            a.notify();
        }

        public String toString() {
            WriteLock a;
            Thread a2 = a.lock.getOwner();
            return super.toString() + (a2 == null ? "[Unlocked]" : "[Locked by thread " + a2.getName() + "]");
        }

        public boolean isHeldByCurrentThread() {
            WriteLock a;
            return a.lock.sync.isWriteLockedByCurrentThread();
        }

        public int getHoldCount() {
            WriteLock a;
            return a.lock.sync.getWriteHoldCount();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        final ReentrantReadWriteLock lock;

        protected ReadLock(ReentrantReadWriteLock a) {
            ReadLock a2;
            if (a == null) {
                throw new NullPointerException();
            }
            a2.lock = a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            ReadLock a;
            ReadLock readLock = a;
            synchronized (readLock) {
                if (a.lock.sync.gV()) {
                    return;
                }
                boolean a2 = Thread.interrupted();
                try {
                    do {
                        try {
                            a.wait();
                        }
                        catch (InterruptedException a3) {
                            a2 = true;
                        }
                    } while (!a.lock.sync.UV());
                    return;
                }
                finally {
                    if (a2) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            ReadLock a;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException a2 = null;
            ReadLock readLock = a;
            synchronized (readLock) {
                if (!a.lock.sync.gV()) {
                    try {
                        do {
                            a.wait();
                        } while (!a.lock.sync.UV());
                        return;
                    }
                    catch (InterruptedException a3) {
                        a.lock.sync.ZW();
                        a2 = a3;
                    }
                }
            }
            if (a2 != null) {
                a.lock.writerLock_.CX();
                throw a2;
            }
        }

        public boolean tryLock() {
            ReadLock a;
            return a.lock.sync.mX();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long a, TimeUnit a2) throws InterruptedException {
            ReadLock a3;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException a4 = null;
            long a5 = a2.toNanos(a);
            ReadLock readLock = a3;
            synchronized (readLock) {
                block10: {
                    if (a5 <= 0L) {
                        return a3.lock.sync.mX();
                    }
                    if (a3.lock.sync.gV()) {
                        return true;
                    }
                    long a6 = Utils.nanoTime() + a5;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(a3, a5);
                        }
                        catch (InterruptedException a7) {
                            a3.lock.sync.ZW();
                            a4 = a7;
                            break block10;
                        }
                        if (!a3.lock.sync.UV()) continue;
                        return true;
                    } while ((a5 = a6 - Utils.nanoTime()) > 0L);
                    a3.lock.sync.ZW();
                }
            }
            a3.lock.writerLock_.CX();
            if (a4 != null) {
                throw a4;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void unlock() {
            ReadLock a;
            switch (a.lock.sync.QX()) {
                case 0: {
                    return;
                }
                case 1: {
                    a.lock.readerLock_.CX();
                    return;
                }
                case 2: {
                    a.lock.writerLock_.CX();
                    return;
                }
            }
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        synchronized void CX() {
            ReadLock a;
            a.notifyAll();
        }

        public String toString() {
            ReadLock a;
            int a2 = a.lock.getReadLockCount();
            return super.toString() + "[Read locks = " + a2 + "]";
        }
    }

    private static class NonfairSync
    extends Sync {
        NonfairSync() {
            NonfairSync a;
        }
    }

    private static abstract class Sync
    implements Serializable {
        private static final int NONE = 0;
        private static final int READER = 1;
        private static final int WRITER = 2;
        transient int activeReaders_ = 0;
        transient Thread activeWriter_ = null;
        transient int waitingReaders_ = 0;
        transient int waitingWriters_ = 0;
        transient int writeHolds_ = 0;
        transient HashMap readers_ = new HashMap();
        static final Integer IONE = new Integer(1);

        Sync() {
            Sync a;
        }

        synchronized boolean gV() {
            Sync a;
            boolean a2 = a.mX();
            if (!a2) {
                ++a.waitingReaders_;
            }
            return a2;
        }

        synchronized boolean Pv() {
            Sync a;
            boolean a2 = a.DV();
            if (!a2) {
                ++a.waitingWriters_;
            }
            return a2;
        }

        synchronized boolean UV() {
            Sync a;
            boolean a2 = a.mX();
            if (a2) {
                --a.waitingReaders_;
            }
            return a2;
        }

        synchronized boolean Xw() {
            Sync a;
            boolean a2 = a.DV();
            if (a2) {
                --a.waitingWriters_;
            }
            return a2;
        }

        synchronized void ZW() {
            Sync a;
            --a.waitingReaders_;
        }

        synchronized void Gw() {
            Sync a;
            --a.waitingWriters_;
        }

        boolean hx() {
            Sync a;
            return a.activeWriter_ == null && a.waitingWriters_ == 0 || a.activeWriter_ == Thread.currentThread();
        }

        synchronized boolean mX() {
            Sync a;
            Thread a2 = Thread.currentThread();
            Object a3 = a.readers_.get(a2);
            if (a3 != null) {
                a.readers_.put(a2, new Integer((Integer)a3 + 1));
                ++a.activeReaders_;
                return true;
            }
            if (a.hx()) {
                a.readers_.put(a2, IONE);
                ++a.activeReaders_;
                return true;
            }
            return false;
        }

        synchronized boolean DV() {
            Sync a;
            if (a.activeWriter_ == Thread.currentThread()) {
                ++a.writeHolds_;
                return true;
            }
            if (a.writeHolds_ == 0) {
                if (a.activeReaders_ == 0 || a.readers_.size() == 1 && a.readers_.get(Thread.currentThread()) != null) {
                    a.activeWriter_ = Thread.currentThread();
                    a.writeHolds_ = 1;
                    return true;
                }
                return false;
            }
            return false;
        }

        synchronized int QX() {
            Sync a;
            Thread a2 = Thread.currentThread();
            Object a3 = a.readers_.get(a2);
            if (a3 == null) {
                throw new IllegalMonitorStateException();
            }
            --a.activeReaders_;
            if (a3 != IONE) {
                int a4 = (Integer)a3 - 1;
                Integer a5 = a4 == 1 ? IONE : new Integer(a4);
                a.readers_.put(a2, a5);
                return 0;
            }
            a.readers_.remove(a2);
            if (a.writeHolds_ > 0) {
                return 0;
            }
            if (a.activeReaders_ == 0 && a.waitingWriters_ > 0) {
                return 2;
            }
            return 0;
        }

        synchronized int Ox() {
            Sync a;
            if (a.activeWriter_ != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            --a.writeHolds_;
            if (a.writeHolds_ > 0) {
                return 0;
            }
            a.activeWriter_ = null;
            if (a.waitingReaders_ > 0 && a.hx()) {
                return 1;
            }
            if (a.waitingWriters_ > 0) {
                return 2;
            }
            return 0;
        }

        synchronized Thread getOwner() {
            Sync a;
            return a.activeWriter_;
        }

        synchronized int getReadLockCount() {
            Sync a;
            return a.activeReaders_;
        }

        synchronized boolean isWriteLocked() {
            Sync a;
            return a.activeWriter_ != null;
        }

        synchronized boolean isWriteLockedByCurrentThread() {
            Sync a;
            return a.activeWriter_ == Thread.currentThread();
        }

        synchronized int getWriteHoldCount() {
            Sync a;
            return a.isWriteLockedByCurrentThread() ? a.writeHolds_ : 0;
        }

        synchronized int getReadHoldCount() {
            Sync a;
            if (a.activeReaders_ == 0) {
                return 0;
            }
            Thread a2 = Thread.currentThread();
            Integer a3 = (Integer)a.readers_.get(a2);
            return a3 == null ? 0 : a3;
        }

        final synchronized boolean hasQueuedThreads() {
            Sync a;
            return a.waitingWriters_ > 0 || a.waitingReaders_ > 0;
        }

        final synchronized int getQueueLength() {
            Sync a;
            return a.waitingWriters_ + a.waitingReaders_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream a) throws IOException, ClassNotFoundException {
            Sync a2;
            a.defaultReadObject();
            Sync sync = a2;
            synchronized (sync) {
                a2.readers_ = new HashMap();
            }
        }
    }
}

