/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.FIFOCondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class ReentrantLock
implements Lock,
Serializable,
CondVar.ExclusiveLock {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public ReentrantLock() {
        ReentrantLock a;
        a.sync = new NonfairSync();
    }

    public ReentrantLock(boolean a) {
        ReentrantLock a2;
        a2.sync = a ? new FairSync() : new NonfairSync();
    }

    public void lock() {
        ReentrantLock a;
        a.sync.lock();
    }

    public void lockInterruptibly() throws InterruptedException {
        ReentrantLock a;
        a.sync.lockInterruptibly();
    }

    public boolean tryLock() {
        ReentrantLock a;
        return a.sync.tryLock();
    }

    public boolean tryLock(long a, TimeUnit a2) throws InterruptedException {
        ReentrantLock a3;
        return a3.sync.tryLock(a2.toNanos(a));
    }

    public void unlock() {
        ReentrantLock a;
        a.sync.unlock();
    }

    public Condition newCondition() {
        ReentrantLock a;
        return a.isFair() ? new FIFOCondVar(a) : new CondVar(a);
    }

    public int getHoldCount() {
        ReentrantLock a;
        return a.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        ReentrantLock a;
        return a.sync.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        ReentrantLock a;
        return a.sync.isLocked();
    }

    public final boolean isFair() {
        ReentrantLock a;
        return a.sync.isFair();
    }

    protected Thread getOwner() {
        ReentrantLock a;
        return a.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        ReentrantLock a;
        return a.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread a) {
        ReentrantLock a2;
        return a2.sync.isQueued(a);
    }

    public final int getQueueLength() {
        ReentrantLock a;
        return a.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        ReentrantLock a;
        return a.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition a) {
        ReentrantLock a2;
        return a2.Cw(a).hasWaiters();
    }

    public int getWaitQueueLength(Condition a) {
        ReentrantLock a2;
        return a2.Cw(a).getWaitQueueLength();
    }

    protected Collection getWaitingThreads(Condition a) {
        ReentrantLock a2;
        return a2.Cw(a).getWaitingThreads();
    }

    public String toString() {
        ReentrantLock a;
        Thread a2 = a.getOwner();
        return super.toString() + (a2 == null ? "[Unlocked]" : "[Locked by thread " + a2.getName() + "]");
    }

    private CondVar Cw(Condition a) {
        ReentrantLock a2;
        if (a == null) {
            throw new NullPointerException();
        }
        if (!(a instanceof CondVar)) {
            throw new IllegalArgumentException("not owner");
        }
        CondVar a3 = (CondVar)a;
        if (a3.lock != a2) {
            throw new IllegalArgumentException("not owner");
        }
        return a3;
    }

    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = -3000897897090466540L;
        private transient WaitQueue wq_ = new FIFOWaitQueue();

        FairSync() {
            FairSync a;
        }

        public synchronized boolean recheck(WaitQueue.WaitNode a) {
            FairSync a2;
            Thread a3 = Thread.currentThread();
            if (a2.owner_ == null) {
                a2.owner_ = a3;
                a2.holds_ = 1;
                return true;
            }
            if (a3 == a2.owner_) {
                a2.Px();
                return true;
            }
            a2.wq_.insert(a);
            return false;
        }

        public synchronized void takeOver(WaitQueue.WaitNode a) {
            a.owner_ = a.getOwner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            FairSync a;
            Thread a2 = Thread.currentThread();
            FairSync fairSync = a;
            synchronized (fairSync) {
                if (a.owner_ == null) {
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return;
                }
                if (a2 == a.owner_) {
                    a.Px();
                    return;
                }
            }
            WaitQueue.WaitNode a3 = new WaitQueue.WaitNode();
            a3.doWaitUninterruptibly(a);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            FairSync a;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread a2 = Thread.currentThread();
            FairSync fairSync = a;
            synchronized (fairSync) {
                if (a.owner_ == null) {
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return;
                }
                if (a2 == a.owner_) {
                    a.Px();
                    return;
                }
            }
            WaitQueue.WaitNode a3 = new WaitQueue.WaitNode();
            a3.doWait(a);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long a) throws InterruptedException {
            FairSync a2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread a3 = Thread.currentThread();
            FairSync fairSync = a2;
            synchronized (fairSync) {
                if (a2.owner_ == null) {
                    a2.owner_ = a3;
                    a2.holds_ = 1;
                    return true;
                }
                if (a3 == a2.owner_) {
                    a2.Px();
                    return true;
                }
            }
            WaitQueue.WaitNode a4 = new WaitQueue.WaitNode();
            return a4.doTimedWait(a2, a);
        }

        protected synchronized WaitQueue.WaitNode getSignallee(Thread a) {
            FairSync a2;
            if (a != a2.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (a2.holds_ >= 2) {
                --a2.holds_;
                return null;
            }
            WaitQueue.WaitNode a3 = a2.wq_.extract();
            if (a3 == null) {
                a2.owner_ = null;
                a2.holds_ = 0;
            }
            return a3;
        }

        public void unlock() {
            FairSync a;
            WaitQueue.WaitNode a2;
            Thread a3 = Thread.currentThread();
            do {
                if ((a2 = a.getSignallee(a3)) != null) continue;
                return;
            } while (!a2.signal(a));
        }

        public final boolean isFair() {
            return true;
        }

        public synchronized boolean hasQueuedThreads() {
            FairSync a;
            return a.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            FairSync a;
            return a.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            FairSync a;
            return a.wq_.getWaitingThreads();
        }

        public synchronized boolean isQueued(Thread a) {
            FairSync a2;
            return a2.wq_.isWaiting(a);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream a) throws IOException, ClassNotFoundException {
            FairSync a2;
            a.defaultReadObject();
            FairSync fairSync = a2;
            synchronized (fairSync) {
                a2.wq_ = new FIFOWaitQueue();
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = 7316153563782823691L;

        NonfairSync() {
            NonfairSync a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            NonfairSync a;
            Thread a2 = Thread.currentThread();
            NonfairSync nonfairSync = a;
            synchronized (nonfairSync) {
                if (a.owner_ == null) {
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return;
                }
                if (a2 == a.owner_) {
                    a.Px();
                    return;
                }
                boolean a3 = Thread.interrupted();
                try {
                    do {
                        try {
                            a.wait();
                        }
                        catch (InterruptedException a4) {
                            a3 = true;
                        }
                    } while (a.owner_ != null);
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return;
                }
                finally {
                    if (a3) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            NonfairSync a;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread a2 = Thread.currentThread();
            NonfairSync nonfairSync = a;
            synchronized (nonfairSync) {
                if (a.owner_ == null) {
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return;
                }
                if (a2 == a.owner_) {
                    a.Px();
                    return;
                }
                try {
                    do {
                        a.wait();
                    } while (a.owner_ != null);
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return;
                }
                catch (InterruptedException a3) {
                    if (a.owner_ == null) {
                        a.notify();
                    }
                    throw a3;
                }
            }
        }

        public boolean tryLock(long a) throws InterruptedException {
            NonfairSync a2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread a3 = Thread.currentThread();
            NonfairSync nonfairSync = a2;
            synchronized (nonfairSync) {
                if (a2.owner_ == null) {
                    a2.owner_ = a3;
                    a2.holds_ = 1;
                    return true;
                }
                if (a3 == a2.owner_) {
                    a2.Px();
                    return true;
                }
                if (a <= 0L) {
                    return false;
                }
                long a4 = Utils.nanoTime() + a;
                try {
                    do {
                        TimeUnit.NANOSECONDS.timedWait(a2, a);
                        if (a3 == a2.owner_) {
                            a2.Px();
                            return true;
                        }
                        if (a2.owner_ != null) continue;
                        a2.owner_ = a3;
                        a2.holds_ = 1;
                        return true;
                    } while ((a = a4 - Utils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException a5) {
                    if (a2.owner_ == null) {
                        a2.notify();
                    }
                    throw a5;
                }
            }
        }

        public synchronized void unlock() {
            NonfairSync a;
            if (Thread.currentThread() != a.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--a.holds_ == 0) {
                a.owner_ = null;
                a.notify();
            }
        }

        public final boolean isFair() {
            return false;
        }
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = -5179523762034025860L;
        protected transient Thread owner_ = null;
        protected transient int holds_ = 0;

        protected Sync() {
            Sync a;
        }

        public abstract void lock();

        public abstract void lockInterruptibly() throws InterruptedException;

        final void Px() {
            Sync a;
            int a2 = ++a.holds_;
            if (a.holds_ < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            a.holds_ = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock() {
            Sync a;
            Thread a2 = Thread.currentThread();
            Sync sync = a;
            synchronized (sync) {
                if (a.owner_ == null) {
                    a.owner_ = a2;
                    a.holds_ = 1;
                    return true;
                }
                if (a2 == a.owner_) {
                    a.Px();
                    return true;
                }
            }
            return false;
        }

        public abstract boolean tryLock(long var1) throws InterruptedException;

        public abstract void unlock();

        public synchronized int getHoldCount() {
            Sync a;
            return a.isHeldByCurrentThread() ? a.holds_ : 0;
        }

        public synchronized boolean isHeldByCurrentThread() {
            Sync a;
            return a.holds_ > 0 && Thread.currentThread() == a.owner_;
        }

        public synchronized boolean isLocked() {
            Sync a;
            return a.owner_ != null;
        }

        public abstract boolean isFair();

        protected synchronized Thread getOwner() {
            Sync a;
            return a.owner_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public boolean isQueued(Thread a) {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }
}

