/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import [Ljava.lang.Object;;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import sun.misc.Perf;

public final class Utils {
    private static final NanoTimer l;
    private static final String K = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private Utils() {
        Utils a;
    }

    public static long nanoTime() {
        return l.nanoTime();
    }

    public static long awaitNanos(Condition a, long a2) throws InterruptedException {
        if (a2 <= 0L) {
            return a2;
        }
        long a3 = Utils.nanoTime();
        a.await(a2, TimeUnit.NANOSECONDS);
        return a2 - (Utils.nanoTime() - a3);
    }

    private static long NX(long a, long a2) {
        long l = a2;
        while (l > 0L) {
            long a3 = a % a2;
            a = a2;
            l = a3;
        }
        return a;
    }

    public static Object[] collectionToArray(Collection a) {
        int a2 = a.size();
        Object[] a3 = new Object[a2];
        Iterator a4 = a.iterator();
        int a5 = 0;
        while (true) {
            int n = a5;
            int n2 = a2;
            while (n < n2 && a4.hasNext()) {
                a3[a5++] = a4.next();
                n = a5;
                n2 = a2;
            }
            if (!a4.hasNext()) {
                if (a5 == a2) {
                    return a3;
                }
                return Arrays.copyOf(a3, a5, Object;.class);
            }
            int a6 = (a3.length / 2 + 1) * 3;
            if (a6 < a3.length) {
                if (a3.length < Integer.MAX_VALUE) {
                    a6 = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            a3 = Arrays.copyOf(a3, a6, f == null ? Utils.class$("[Ljava.lang.Object;") : f);
            a2 = a6;
        }
    }

    public static Object[] collectionToArray(Collection a, Object[] a2) {
        Class<?> a3 = a2.getClass();
        int a4 = a.size();
        Object[] a5 = a2.length >= a4 ? a2 : (Object[])Array.newInstance(a3.getComponentType(), a4);
        Iterator a6 = a.iterator();
        int a7 = 0;
        while (true) {
            int n = a7;
            int n2 = a4;
            while (n < n2 && a6.hasNext()) {
                a5[a7++] = a6.next();
                n = a7;
                n2 = a4;
            }
            if (!a6.hasNext()) {
                if (a7 == a4) {
                    return a5;
                }
                if (a5 == a2) {
                    a2[a7] = null;
                    return a2;
                }
                return Arrays.copyOf(a5, a7, a3);
            }
            int a8 = (a5.length / 2 + 1) * 3;
            if (a8 < a5.length) {
                if (a5.length < Integer.MAX_VALUE) {
                    a8 = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            a5 = Arrays.copyOf(a5, a8, a3);
            a4 = a8;
        }
    }

    static {
        NanoTimer a = null;
        try {
            String a2 = (String)AccessController.doPrivileged(new PrivilegedAction(){
                {
                    1 a;
                }

                public Object run() {
                    return System.getProperty(Utils.K);
                }
            });
            if (a2 != null) {
                a = (NanoTimer)Class.forName(a2).newInstance();
            }
        }
        catch (Exception a3) {
            System.err.println("WARNING: unable to load the system-property-defined nanotime provider; switching to the default");
            a3.printStackTrace();
        }
        if (a == null) {
            try {
                a = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (a == null) {
            a = new MillisProvider();
        }
        l = a;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
            MillisProvider a;
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf l;
        final long K;
        final long f;

        SunPerfProvider() {
            SunPerfProvider a;
            a.l = (Perf)AccessController.doPrivileged(new PrivilegedAction(){
                {
                    1 a;
                }

                public Object run() {
                    return Perf.getPerf();
                }
            });
            long a2 = 1000000000L;
            long a3 = a.l.highResFrequency();
            long a4 = Utils.NX(a2, a3);
            a.K = a2 / a4;
            a.f = a3 / a4;
        }

        public long nanoTime() {
            SunPerfProvider a;
            long a2 = a.l.highResCounter();
            return a2 / a.f * a.K + a2 % a.f * a.K / a.f;
        }
    }
}

