/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class TimeUnit
implements Serializable {
    public static final TimeUnit NANOSECONDS = new TimeUnit(0, "NANOSECONDS"){
        private static final long serialVersionUID = 535148490883208361L;
        {
            1 a3;
        }

        public long toNanos(long a) {
            return a;
        }

        public long toMicros(long a) {
            return a / 1000L;
        }

        public long toMillis(long a) {
            return a / 1000000L;
        }

        public long toSeconds(long a) {
            return a / 1000000000L;
        }

        public long toMinutes(long a) {
            return a / 60000000000L;
        }

        public long toHours(long a) {
            return a / 3600000000000L;
        }

        public long toDays(long a) {
            return a / 86400000000000L;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toNanos(a);
        }

        int wV(long a, long a2) {
            return (int)(a - a2 * 1000000L);
        }
    };
    public static final TimeUnit MICROSECONDS = new TimeUnit(1, "MICROSECONDS"){
        private static final long serialVersionUID = 2185906575929579108L;
        {
            2 a3;
        }

        public long toNanos(long a) {
            return 2.cV(a, 1000L, 9223372036854775L);
        }

        public long toMicros(long a) {
            return a;
        }

        public long toMillis(long a) {
            return a / 1000L;
        }

        public long toSeconds(long a) {
            return a / 1000000L;
        }

        public long toMinutes(long a) {
            return a / 60000000L;
        }

        public long toHours(long a) {
            return a / 3600000000L;
        }

        public long toDays(long a) {
            return a / 86400000000L;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toMicros(a);
        }

        int wV(long a, long a2) {
            return (int)(a * 1000L - a2 * 1000000L);
        }
    };
    public static final TimeUnit MILLISECONDS = new TimeUnit(2, "MILLISECONDS"){
        private static final long serialVersionUID = 9032047794123325184L;
        {
            3 a3;
        }

        public long toNanos(long a) {
            return 3.cV(a, 1000000L, 9223372036854L);
        }

        public long toMicros(long a) {
            return 3.cV(a, 1000L, 9223372036854775L);
        }

        public long toMillis(long a) {
            return a;
        }

        public long toSeconds(long a) {
            return a / 1000L;
        }

        public long toMinutes(long a) {
            return a / 60000L;
        }

        public long toHours(long a) {
            return a / 3600000L;
        }

        public long toDays(long a) {
            return a / 86400000L;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toMillis(a);
        }

        int wV(long a, long a2) {
            return 0;
        }
    };
    public static final TimeUnit SECONDS = new TimeUnit(3, "SECONDS"){
        private static final long serialVersionUID = 227755028449378390L;
        {
            4 a3;
        }

        public long toNanos(long a) {
            return 4.cV(a, 1000000000L, 9223372036L);
        }

        public long toMicros(long a) {
            return 4.cV(a, 1000000L, 9223372036854L);
        }

        public long toMillis(long a) {
            return 4.cV(a, 1000L, 9223372036854775L);
        }

        public long toSeconds(long a) {
            return a;
        }

        public long toMinutes(long a) {
            return a / 60L;
        }

        public long toHours(long a) {
            return a / 3600L;
        }

        public long toDays(long a) {
            return a / 86400L;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toSeconds(a);
        }

        int wV(long a, long a2) {
            return 0;
        }
    };
    public static final TimeUnit MINUTES = new TimeUnit(4, "MINUTES"){
        private static final long serialVersionUID = 1827351566402609187L;
        {
            5 a3;
        }

        public long toNanos(long a) {
            return 5.cV(a, 60000000000L, 153722867L);
        }

        public long toMicros(long a) {
            return 5.cV(a, 60000000L, 153722867280L);
        }

        public long toMillis(long a) {
            return 5.cV(a, 60000L, 153722867280912L);
        }

        public long toSeconds(long a) {
            return 5.cV(a, 60L, 0x222222222222222L);
        }

        public long toMinutes(long a) {
            return a;
        }

        public long toHours(long a) {
            return a / 60L;
        }

        public long toDays(long a) {
            return a / 1440L;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toMinutes(a);
        }

        int wV(long a, long a2) {
            return 0;
        }
    };
    public static final TimeUnit HOURS = new TimeUnit(5, "HOURS"){
        private static final long serialVersionUID = -6438436134732089810L;
        {
            6 a3;
        }

        public long toNanos(long a) {
            return 6.cV(a, 3600000000000L, 2562047L);
        }

        public long toMicros(long a) {
            return 6.cV(a, 3600000000L, 2562047788L);
        }

        public long toMillis(long a) {
            return 6.cV(a, 3600000L, 2562047788015L);
        }

        public long toSeconds(long a) {
            return 6.cV(a, 3600L, 2562047788015215L);
        }

        public long toMinutes(long a) {
            return 6.cV(a, 60L, 0x222222222222222L);
        }

        public long toHours(long a) {
            return a;
        }

        public long toDays(long a) {
            return a / 24L;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toHours(a);
        }

        int wV(long a, long a2) {
            return 0;
        }
    };
    public static final TimeUnit DAYS = new TimeUnit(6, "DAYS"){
        private static final long serialVersionUID = 567463171959674600L;
        {
            7 a3;
        }

        public long toNanos(long a) {
            return 7.cV(a, 86400000000000L, 106751L);
        }

        public long toMicros(long a) {
            return 7.cV(a, 86400000000L, 106751991L);
        }

        public long toMillis(long a) {
            return 7.cV(a, 86400000L, 106751991167L);
        }

        public long toSeconds(long a) {
            return 7.cV(a, 86400L, 106751991167300L);
        }

        public long toMinutes(long a) {
            return 7.cV(a, 1440L, 0x16C16C16C16C16L);
        }

        public long toHours(long a) {
            return 7.cV(a, 24L, 0x555555555555555L);
        }

        public long toDays(long a) {
            return a;
        }

        public long convert(long a, TimeUnit a2) {
            return a2.toDays(a);
        }

        int wV(long a, long a2) {
            return 0;
        }
    };
    private static final TimeUnit[] values = new TimeUnit[]{NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS};
    private final int index;
    private final String name;
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;
    static final long MAX = Long.MAX_VALUE;

    public static TimeUnit[] values() {
        return (TimeUnit[])values.clone();
    }

    public static TimeUnit valueOf(String a) {
        int a2;
        int n = a2 = 0;
        while (n < values.length) {
            if (TimeUnit.values[a2].name.equals(a)) {
                return values[a2];
            }
            n = ++a2;
        }
        throw new IllegalArgumentException("No enum const TimeUnit." + a);
    }

    TimeUnit(int a, String a2) {
        TimeUnit a3;
        a3.index = a;
        a3.name = a2;
    }

    static long cV(long a, long a2, long a3) {
        if (a > a3) {
            return Long.MAX_VALUE;
        }
        if (a < -a3) {
            return Long.MIN_VALUE;
        }
        return a * a2;
    }

    public abstract long convert(long var1, TimeUnit var3);

    public abstract long toNanos(long var1);

    public abstract long toMicros(long var1);

    public abstract long toMillis(long var1);

    public abstract long toSeconds(long var1);

    public abstract long toMinutes(long var1);

    public abstract long toHours(long var1);

    public abstract long toDays(long var1);

    abstract int wV(long var1, long var3);

    public String name() {
        TimeUnit a;
        return a.name;
    }

    public int ordinal() {
        TimeUnit a;
        return a.index;
    }

    protected Object readResolve() throws ObjectStreamException {
        TimeUnit a;
        try {
            return TimeUnit.valueOf(a.name);
        }
        catch (IllegalArgumentException a2) {
            throw new InvalidObjectException(a.name + " is not a valid enum for TimeUnit");
        }
    }

    public void timedWait(Object a, long a2) throws InterruptedException {
        if (a2 > 0L) {
            TimeUnit a3;
            long a4 = a3.toMillis(a2);
            int a5 = a3.wV(a2, a4);
            a.wait(a4, a5);
        }
    }

    public void timedJoin(Thread a, long a2) throws InterruptedException {
        if (a2 > 0L) {
            TimeUnit a3;
            long a4 = a3.toMillis(a2);
            int a5 = a3.wV(a2, a4);
            a.join(a4, a5);
        }
    }

    public void sleep(long a) throws InterruptedException {
        if (a > 0L) {
            TimeUnit a2;
            long a3 = a2.toMillis(a);
            int a4 = a2.wV(a, a3);
            Thread.sleep(a3, a4);
        }
    }

    public String toString() {
        TimeUnit a;
        return a.name;
    }
}

