/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public Semaphore(int a) {
        Semaphore a2;
        a2.sync = new NonfairSync(a);
    }

    public Semaphore(int a, boolean a2) {
        Semaphore a3;
        a3.sync = a2 ? new FairSync(a) : new NonfairSync(a);
    }

    public void acquire() throws InterruptedException {
        Semaphore a;
        a.sync.acquire(1);
    }

    public void acquireUninterruptibly() {
        Semaphore a;
        a.sync.acquireUninterruptibly(1);
    }

    public boolean tryAcquire() {
        Semaphore a;
        return a.sync.attempt(1);
    }

    public boolean tryAcquire(long a, TimeUnit a2) throws InterruptedException {
        Semaphore a3;
        return a3.sync.attempt(1, a2.toNanos(a));
    }

    public void release() {
        Semaphore a;
        a.sync.release(1);
    }

    public void acquire(int a) throws InterruptedException {
        Semaphore a2;
        if (a < 0) {
            throw new IllegalArgumentException();
        }
        a2.sync.acquire(a);
    }

    public void acquireUninterruptibly(int a) {
        Semaphore a2;
        a2.sync.acquireUninterruptibly(a);
    }

    public boolean tryAcquire(int a) {
        Semaphore a2;
        if (a < 0) {
            throw new IllegalArgumentException();
        }
        return a2.sync.attempt(a);
    }

    public boolean tryAcquire(int a, long a2, TimeUnit a3) throws InterruptedException {
        Semaphore a4;
        if (a < 0) {
            throw new IllegalArgumentException();
        }
        return a4.sync.attempt(a, a3.toNanos(a2));
    }

    public void release(int a) {
        Semaphore a2;
        if (a < 0) {
            throw new IllegalArgumentException();
        }
        a2.sync.release(a);
    }

    public int availablePermits() {
        Semaphore a;
        return a.sync.getPermits();
    }

    public int drainPermits() {
        Semaphore a;
        return a.sync.drain();
    }

    protected void reducePermits(int a) {
        Semaphore a2;
        if (a < 0) {
            throw new IllegalArgumentException();
        }
        a2.sync.reduce(a);
    }

    public boolean isFair() {
        Semaphore a;
        return a.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        Semaphore a;
        return a.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        Semaphore a;
        return a.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        Semaphore a;
        return a.sync.getQueuedThreads();
    }

    public String toString() {
        Semaphore a;
        return super.toString() + "[Permits = " + a.sync.getPermits() + "]";
    }

    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = 2014338818796000944L;
        private transient WaitQueue wq_ = new FIFOWaitQueue();

        FairSync(int a) {
            super(a);
            FairSync a2;
        }

        public void acquireUninterruptibly(int a) {
            FairSync a2;
            if (a2.precheck(a)) {
                return;
            }
            new Node(a).doWaitUninterruptibly(a2);
        }

        public void acquire(int a) throws InterruptedException {
            FairSync a2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (a2.precheck(a)) {
                return;
            }
            new Node(a).doWait(a2);
        }

        public boolean attempt(int a, long a2) throws InterruptedException {
            FairSync a3;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (a3.precheck(a)) {
                return true;
            }
            if (a2 <= 0L) {
                return false;
            }
            return new Node(a).doTimedWait(a3, a2);
        }

        protected synchronized boolean precheck(int a) {
            FairSync a2;
            boolean a3;
            boolean bl = a3 = a2.permits_ >= a;
            if (a3) {
                a2.permits_ -= a;
            }
            return a3;
        }

        public synchronized boolean recheck(WaitQueue.WaitNode a) {
            FairSync a2;
            boolean a3;
            Node a4 = (Node)a;
            boolean bl = a3 = a2.permits_ >= a4.f;
            if (a3) {
                a2.permits_ -= a4.f;
            } else {
                a2.wq_.insert(a);
            }
            return a3;
        }

        public void takeOver(WaitQueue.WaitNode a) {
        }

        protected synchronized Node getSignallee(int a) {
            FairSync a2;
            Node a3 = (Node)a2.wq_.extract();
            a2.permits_ += a;
            if (a3 == null) {
                return null;
            }
            if (a3.f > a2.permits_) {
                a2.wq_.putBack(a3);
                return null;
            }
            a2.permits_ -= a3.f;
            return a3;
        }

        public void release(int a) {
            if (a < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            FairSync a2;
            Node a3;
            while ((a3 = a2.getSignallee(a)) != null) {
                if (a3.signal(a2)) {
                    return;
                }
                a = a3.f;
            }
            return;
        }

        public synchronized boolean hasQueuedThreads() {
            FairSync a;
            return a.wq_.hasNodes();
        }

        public synchronized int getQueueLength() {
            FairSync a;
            return a.wq_.getLength();
        }

        public synchronized Collection getQueuedThreads() {
            FairSync a;
            return a.wq_.getWaitingThreads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream a) throws IOException, ClassNotFoundException {
            FairSync a2;
            a.defaultReadObject();
            FairSync fairSync = a2;
            synchronized (fairSync) {
                a2.wq_ = new FIFOWaitQueue();
            }
        }

        static final class Node
        extends WaitQueue.WaitNode {
            final int f;

            Node(int a) {
                Node a2;
                a2.f = a;
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        protected NonfairSync(int a) {
            super(a);
            NonfairSync a2;
        }

        private static void EX(int a) {
            if (a != 1) {
                throw new UnsupportedOperationException("Atomic multi-acquire supported only in FAIR semaphores");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquireUninterruptibly(int a) {
            NonfairSync a2;
            if (a == 0) {
                return;
            }
            NonfairSync.EX(a);
            NonfairSync nonfairSync = a2;
            synchronized (nonfairSync) {
                if (a2.permits_ > 0) {
                    --a2.permits_;
                    return;
                }
                boolean a3 = Thread.interrupted();
                try {
                    do {
                        try {
                            a2.wait();
                        }
                        catch (InterruptedException a4) {
                            a3 = true;
                        }
                    } while (a2.permits_ <= 0);
                    --a2.permits_;
                    return;
                }
                finally {
                    if (a3) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire(int a) throws InterruptedException {
            NonfairSync a2;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (a == 0) {
                return;
            }
            NonfairSync.EX(a);
            NonfairSync nonfairSync = a2;
            synchronized (nonfairSync) {
                while (a2.permits_ <= 0) {
                    try {
                        a2.wait();
                    }
                    catch (InterruptedException a3) {
                        a2.notify();
                        throw a3;
                    }
                }
                --a2.permits_;
            }
        }

        public boolean attempt(int a, long a2) throws InterruptedException {
            NonfairSync a3;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (a == 0) {
                return true;
            }
            NonfairSync.EX(a);
            NonfairSync nonfairSync = a3;
            synchronized (nonfairSync) {
                if (a3.permits_ > 0) {
                    --a3.permits_;
                    return true;
                }
                if (a2 <= 0L) {
                    return false;
                }
                try {
                    long a4 = Utils.nanoTime() + a2;
                    do {
                        TimeUnit.NANOSECONDS.timedWait(a3, a2);
                        if (a3.permits_ <= 0) continue;
                        --a3.permits_;
                        return true;
                    } while ((a2 = a4 - Utils.nanoTime()) > 0L);
                    return false;
                }
                catch (InterruptedException a5) {
                    a3.notify();
                    throw a5;
                }
            }
        }

        public synchronized void release(int a) {
            int a2;
            if (a < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            a3.permits_ += a;
            int n = a2 = 0;
            while (n < a) {
                NonfairSync a3;
                a3.notify();
                n = ++a2;
            }
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = 1192457210091910933L;
        int permits_;

        protected Sync(int a) {
            Sync a2;
            a2.permits_ = a;
        }

        abstract void acquireUninterruptibly(int var1);

        abstract void acquire(int var1) throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(int a) {
            Sync a2;
            Sync sync = a2;
            synchronized (sync) {
                if (a2.permits_ >= a) {
                    a2.permits_ -= a;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(int var1, long var2) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            Sync a;
            return a.permits_;
        }

        public synchronized int drain() {
            Sync a;
            int a2 = a.permits_;
            a.permits_ = 0;
            return a2;
        }

        public synchronized void reduce(int a) {
            a.permits_ -= a;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();
    }
}

