/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;

public class Executors {
    public static ExecutorService newFixedThreadPool(int a) {
        return new ThreadPoolExecutor(a, a, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static ExecutorService newFixedThreadPool(int a, ThreadFactory a2) {
        return new ThreadPoolExecutor(a, a, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), a2);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory a) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), a));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory a) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), a);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory a) {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1, a));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int a) {
        return new ScheduledThreadPoolExecutor(a);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int a, ThreadFactory a2) {
        return new ScheduledThreadPoolExecutor(a, a2);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new DelegatedExecutorService(a);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new DelegatedScheduledExecutorService(a);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static Callable callable(Runnable a, Object a2) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(a, a2);
    }

    public static Callable callable(Runnable a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(a, null);
    }

    public static Callable callable(final PrivilegedAction a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new Callable(){
            {
                1 a2;
            }

            public Object call() {
                1 a2;
                return a2.a.run();
            }
        };
    }

    public static Callable callable(final PrivilegedExceptionAction a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new Callable(){
            {
                2 a2;
            }

            public Object call() throws Exception {
                2 a2;
                return a2.a.run();
            }
        };
    }

    public static Callable privilegedCallable(Callable a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallable(a);
    }

    public static Callable privilegedCallableUsingCurrentClassLoader(Callable a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallableUsingCurrentClassLoader(a);
    }

    private Executors() {
        Executors a;
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService f;

        DelegatedScheduledExecutorService(ScheduledExecutorService a) {
            super(a);
            DelegatedScheduledExecutorService a2;
            a2.f = a;
        }

        public ScheduledFuture schedule(Runnable a, long a2, TimeUnit a3) {
            DelegatedScheduledExecutorService a4;
            return a4.f.schedule(a, a2, a3);
        }

        public ScheduledFuture schedule(Callable a, long a2, TimeUnit a3) {
            DelegatedScheduledExecutorService a4;
            return a4.f.schedule(a, a2, a3);
        }

        public ScheduledFuture scheduleAtFixedRate(Runnable a, long a2, long a3, TimeUnit a4) {
            DelegatedScheduledExecutorService a5;
            return a5.f.scheduleAtFixedRate(a, a2, a3, a4);
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable a, long a2, long a3, TimeUnit a4) {
            DelegatedScheduledExecutorService a5;
            return a5.f.scheduleWithFixedDelay(a, a2, a3, a4);
        }
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService a) {
            super(a);
            FinalizableDelegatedExecutorService a2;
        }

        protected void finalize() {
            FinalizableDelegatedExecutorService a;
            super.shutdown();
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService f;

        DelegatedExecutorService(ExecutorService a) {
            DelegatedExecutorService a2;
            a2.f = a;
        }

        public void execute(Runnable a) {
            DelegatedExecutorService a2;
            a2.f.execute(a);
        }

        public void shutdown() {
            DelegatedExecutorService a;
            a.f.shutdown();
        }

        public List shutdownNow() {
            DelegatedExecutorService a;
            return a.f.shutdownNow();
        }

        public boolean isShutdown() {
            DelegatedExecutorService a;
            return a.f.isShutdown();
        }

        public boolean isTerminated() {
            DelegatedExecutorService a;
            return a.f.isTerminated();
        }

        public boolean awaitTermination(long a, TimeUnit a2) throws InterruptedException {
            DelegatedExecutorService a3;
            return a3.f.awaitTermination(a, a2);
        }

        public Future submit(Runnable a) {
            DelegatedExecutorService a2;
            return a2.f.submit(a);
        }

        public Future submit(Callable a) {
            DelegatedExecutorService a2;
            return a2.f.submit(a);
        }

        public Future submit(Runnable a, Object a2) {
            DelegatedExecutorService a3;
            return a3.f.submit(a, a2);
        }

        public List invokeAll(Collection a) throws InterruptedException {
            DelegatedExecutorService a2;
            return a2.f.invokeAll(a);
        }

        public List invokeAll(Collection a, long a2, TimeUnit a3) throws InterruptedException {
            DelegatedExecutorService a4;
            return a4.f.invokeAll(a, a2, a3);
        }

        public Object invokeAny(Collection a) throws InterruptedException, ExecutionException {
            DelegatedExecutorService a2;
            return a2.f.invokeAny(a);
        }

        public Object invokeAny(Collection a, long a2, TimeUnit a3) throws InterruptedException, ExecutionException, TimeoutException {
            DelegatedExecutorService a4;
            return a4.f.invokeAny(a, a2, a3);
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final ClassLoader K = Thread.currentThread().getContextClassLoader();
        private final AccessControlContext f = AccessController.getContext();

        PrivilegedThreadFactory() {
            PrivilegedThreadFactory a;
            a.f.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Thread newThread(final Runnable a) {
            PrivilegedThreadFactory a2;
            return super.newThread(new Runnable(){
                {
                    1 a2;
                }

                public void run() {
                    1 a2;
                    AccessController.doPrivileged(new PrivilegedAction(){
                        {
                            PrivilegedThreadFactory.1 a;
                        }

                        public Object run() {
                            PrivilegedThreadFactory.1 a;
                            Thread.currentThread().setContextClassLoader(PrivilegedThreadFactory.this.K);
                            a.run();
                            return null;
                        }
                    }, a2.PrivilegedThreadFactory.this.f);
                }
            });
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger L = new AtomicInteger(1);
        final ThreadGroup l;
        final AtomicInteger K = new AtomicInteger(1);
        final String f;

        DefaultThreadFactory() {
            DefaultThreadFactory a;
            SecurityManager a2 = System.getSecurityManager();
            a.l = a2 != null ? a2.getThreadGroup() : Thread.currentThread().getThreadGroup();
            a.f = "pool-" + L.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable a) {
            DefaultThreadFactory a2;
            Thread a3 = new Thread(a2.l, a, a2.f + a2.K.getAndIncrement(), 0L);
            if (a3.isDaemon()) {
                a3.setDaemon(false);
            }
            if (a3.getPriority() != 5) {
                a3.setPriority(5);
            }
            return a3;
        }
    }

    static final class PrivilegedCallableUsingCurrentClassLoader
    implements Callable {
        private final ClassLoader I;
        private final AccessControlContext L;
        private final Callable l;
        private Object K;
        private Exception f;

        PrivilegedCallableUsingCurrentClassLoader(Callable a) {
            PrivilegedCallableUsingCurrentClassLoader a2;
            a2.l = a;
            a2.I = Thread.currentThread().getContextClassLoader();
            a2.L = AccessController.getContext();
            a2.L.checkPermission(new RuntimePermission("getContextClassLoader"));
            a2.L.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Object call() throws Exception {
            PrivilegedCallableUsingCurrentClassLoader a;
            AccessController.doPrivileged(new PrivilegedAction(){
                {
                    1 a;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    1 a;
                    ClassLoader a2 = null;
                    Thread a3 = Thread.currentThread();
                    try {
                        ClassLoader a4 = a3.getContextClassLoader();
                        if (a.PrivilegedCallableUsingCurrentClassLoader.this.I != a4) {
                            a3.setContextClassLoader(a.PrivilegedCallableUsingCurrentClassLoader.this.I);
                            a2 = a4;
                        }
                        a.PrivilegedCallableUsingCurrentClassLoader.this.K = a.PrivilegedCallableUsingCurrentClassLoader.this.l.call();
                        if (a2 != null) {
                            a3.setContextClassLoader(a2);
                        }
                    }
                    catch (Exception a5) {
                        a.PrivilegedCallableUsingCurrentClassLoader.this.f = a5;
                    }
                    finally {
                        if (a2 != null) {
                            a3.setContextClassLoader(a2);
                        }
                    }
                    return null;
                }
            }, a.L);
            if (a.f != null) {
                throw a.f;
            }
            return a.K;
        }
    }

    static final class PrivilegedCallable
    implements Callable {
        private final AccessControlContext L;
        private final Callable l;
        private Object K;
        private Exception f;

        PrivilegedCallable(Callable a) {
            PrivilegedCallable a2;
            a2.l = a;
            a2.L = AccessController.getContext();
        }

        public Object call() throws Exception {
            PrivilegedCallable a;
            AccessController.doPrivileged(new PrivilegedAction(){
                {
                    1 a;
                }

                public Object run() {
                    1 a;
                    try {
                        a.PrivilegedCallable.this.K = a.PrivilegedCallable.this.l.call();
                    }
                    catch (Exception a2) {
                        a.PrivilegedCallable.this.f = a2;
                    }
                    return null;
                }
            }, a.L);
            if (a.f != null) {
                throw a.f;
            }
            return a.K;
        }
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable K;
        final Object f;

        RunnableAdapter(Runnable a, Object a2) {
            RunnableAdapter a3;
            a3.K = a;
            a3.f = a2;
        }

        public Object call() {
            RunnableAdapter a;
            a.K.run();
            return a.f;
        }
    }
}

