/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.AbstractCollection;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Deque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayDeque
extends AbstractCollection
implements Deque,
Cloneable,
Serializable {
    private transient Object[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void DaA(int a) {
        int a2 = 8;
        if (a >= a2) {
            a2 = a;
            a2 |= a2 >>> 1;
            a2 |= a2 >>> 2;
            a2 |= a2 >>> 4;
            a2 |= a2 >>> 8;
            a2 |= a2 >>> 16;
            if (++a2 < 0) {
                a2 >>>= 1;
            }
        }
        a.elements = new Object[a2];
    }

    private void Hy() {
        ArrayDeque a;
        if (!$assertionsDisabled && a.head != a.tail) {
            throw new AssertionError();
        }
        int a2 = a.head;
        int a3 = a.elements.length;
        int a4 = a3 - a2;
        int a5 = a3 << 1;
        if (a5 < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a6 = new Object[a5];
        System.arraycopy(a.elements, a2, a6, 0, a4);
        System.arraycopy(a.elements, 0, a6, a4, a2);
        a.elements = a6;
        a.head = 0;
        a.tail = a3;
    }

    private Object[] ry(Object[] a) {
        ArrayDeque a2;
        if (a2.head < a2.tail) {
            System.arraycopy(a2.elements, a2.head, a, 0, a2.size());
        } else if (a2.head > a2.tail) {
            int a3 = a2.elements.length - a2.head;
            System.arraycopy(a2.elements, a2.head, a, 0, a3);
            System.arraycopy(a2.elements, 0, a, a3, a2.tail);
        }
        return a;
    }

    public ArrayDeque() {
        ArrayDeque a;
        a.elements = new Object[16];
    }

    public ArrayDeque(int a) {
        ArrayDeque a2;
        a2.DaA(a);
    }

    public ArrayDeque(Collection a) {
        ArrayDeque a2;
        a2.DaA(a.size());
        a2.addAll(a);
    }

    public void addFirst(Object a) {
        ArrayDeque a2;
        if (a == null) {
            throw new NullPointerException();
        }
        a2.head = a2.head - 1 & a2.elements.length - 1;
        a2.elements[a2.head] = a;
        if (a2.head == a2.tail) {
            a2.Hy();
        }
    }

    public void addLast(Object a) {
        ArrayDeque a2;
        if (a == null) {
            throw new NullPointerException();
        }
        a2.elements[a2.tail] = a;
        a2.tail = a2.tail + 1 & a2.elements.length - 1;
        if (a2.tail == a2.head) {
            a2.Hy();
        }
    }

    public boolean offerFirst(Object a) {
        ArrayDeque a2;
        a2.addFirst(a);
        return true;
    }

    public boolean offerLast(Object a) {
        ArrayDeque a2;
        a2.addLast(a);
        return true;
    }

    public Object removeFirst() {
        ArrayDeque a;
        Object a2 = a.pollFirst();
        if (a2 == null) {
            throw new NoSuchElementException();
        }
        return a2;
    }

    public Object removeLast() {
        ArrayDeque a;
        Object a2 = a.pollLast();
        if (a2 == null) {
            throw new NoSuchElementException();
        }
        return a2;
    }

    public Object pollFirst() {
        ArrayDeque a;
        int a2 = a.head;
        Object a3 = a.elements[a2];
        if (a3 == null) {
            return null;
        }
        a.elements[a2] = null;
        a.head = a2 + 1 & a.elements.length - 1;
        return a3;
    }

    public Object pollLast() {
        ArrayDeque a;
        int a2 = a.tail - 1 & a.elements.length - 1;
        Object a3 = a.elements[a2];
        if (a3 == null) {
            return null;
        }
        a.elements[a2] = null;
        a.tail = a2;
        return a3;
    }

    public Object getFirst() {
        ArrayDeque a;
        Object a2 = a.elements[a.head];
        if (a2 == null) {
            throw new NoSuchElementException();
        }
        return a2;
    }

    public Object getLast() {
        ArrayDeque a;
        Object a2 = a.elements[a.tail - 1 & a.elements.length - 1];
        if (a2 == null) {
            throw new NoSuchElementException();
        }
        return a2;
    }

    public Object peekFirst() {
        ArrayDeque a;
        return a.elements[a.head];
    }

    public Object peekLast() {
        ArrayDeque a;
        return a.elements[a.tail - 1 & a.elements.length - 1];
    }

    public boolean removeFirstOccurrence(Object a) {
        Object a2;
        ArrayDeque a3;
        if (a == null) {
            return false;
        }
        int a4 = a3.elements.length - 1;
        int a5 = a3.head;
        ArrayDeque arrayDeque = a3;
        while ((a2 = arrayDeque.elements[a5]) != null) {
            if (a.equals(a2)) {
                a3.delete(a5);
                return true;
            }
            a5 = a5 + 1 & a4;
            arrayDeque = a3;
        }
        return false;
    }

    public boolean removeLastOccurrence(Object a) {
        Object a2;
        ArrayDeque a3;
        if (a == null) {
            return false;
        }
        int a4 = a3.elements.length - 1;
        int a5 = a3.tail - 1 & a4;
        ArrayDeque arrayDeque = a3;
        while ((a2 = arrayDeque.elements[a5]) != null) {
            if (a.equals(a2)) {
                a3.delete(a5);
                return true;
            }
            a5 = a5 - 1 & a4;
            arrayDeque = a3;
        }
        return false;
    }

    public boolean add(Object a) {
        ArrayDeque a2;
        a2.addLast(a);
        return true;
    }

    public boolean offer(Object a) {
        ArrayDeque a2;
        return a2.offerLast(a);
    }

    public Object remove() {
        ArrayDeque a;
        return a.removeFirst();
    }

    public Object poll() {
        ArrayDeque a;
        return a.pollFirst();
    }

    public Object element() {
        ArrayDeque a;
        return a.getFirst();
    }

    public Object peek() {
        ArrayDeque a;
        return a.peekFirst();
    }

    public void push(Object a) {
        ArrayDeque a2;
        a2.addFirst(a);
    }

    public Object pop() {
        ArrayDeque a;
        return a.removeFirst();
    }

    private void wZ() {
        ArrayDeque a;
        if (!$assertionsDisabled && a.elements[a.tail] != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(a.head != a.tail ? a.elements[a.head] != null && a.elements[a.tail - 1 & a.elements.length - 1] != null : a.elements[a.head] == null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && a.elements[a.head - 1 & a.elements.length - 1] != null) {
            throw new AssertionError();
        }
    }

    private boolean delete(int a) {
        ArrayDeque a2;
        a2.wZ();
        Object[] a3 = a2.elements;
        int a4 = a2.elements.length - 1;
        int a5 = a2.head;
        int a6 = a2.tail;
        int a7 = a - a5 & a4;
        int a8 = a6 - a & a4;
        if (a7 >= (a6 - a5 & a4)) {
            throw new ConcurrentModificationException();
        }
        if (a7 < a8) {
            if (a5 <= a) {
                System.arraycopy(a3, a5, a3, a5 + 1, a7);
            } else {
                System.arraycopy(a3, 0, a3, 1, a);
                a3[0] = a3[a4];
                System.arraycopy(a3, a5, a3, a5 + 1, a4 - a5);
            }
            a3[a5] = null;
            a2.head = a5 + 1 & a4;
            return false;
        }
        if (a < a6) {
            System.arraycopy(a3, a + 1, a3, a, a8);
            a2.tail = a6 - 1;
        } else {
            System.arraycopy(a3, a + 1, a3, a, a4 - a);
            a3[a4] = a3[0];
            System.arraycopy(a3, 1, a3, 0, a6);
            a2.tail = a6 - 1 & a4;
        }
        return true;
    }

    public int size() {
        ArrayDeque a;
        return a.tail - a.head & a.elements.length - 1;
    }

    public boolean isEmpty() {
        ArrayDeque a;
        return a.head == a.tail;
    }

    public Iterator iterator() {
        ArrayDeque a;
        return a.new DeqIterator();
    }

    public Iterator descendingIterator() {
        ArrayDeque a;
        return a.new DescendingIterator();
    }

    public boolean contains(Object a) {
        Object a2;
        ArrayDeque a3;
        if (a == null) {
            return false;
        }
        int a4 = a3.elements.length - 1;
        int a5 = a3.head;
        ArrayDeque arrayDeque = a3;
        while ((a2 = arrayDeque.elements[a5]) != null) {
            if (a.equals(a2)) {
                return true;
            }
            a5 = a5 + 1 & a4;
            arrayDeque = a3;
        }
        return false;
    }

    public boolean remove(Object a) {
        ArrayDeque a2;
        return a2.removeFirstOccurrence(a);
    }

    public void clear() {
        ArrayDeque a;
        int a2 = a.head;
        int a3 = a.tail;
        if (a2 != a3) {
            a.tail = 0;
            a.head = 0;
            int a4 = a2;
            int a5 = a.elements.length - 1;
            do {
                a.elements[a4] = null;
            } while ((a4 = a4 + 1 & a5) != a3);
        }
    }

    public Object[] toArray() {
        ArrayDeque a;
        return a.ry(new Object[a.size()]);
    }

    public Object[] toArray(Object[] a) {
        ArrayDeque a2;
        int a3 = a2.size();
        if (a.length < a3) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), a3);
        }
        a2.ry(a);
        if (a.length > a3) {
            a[a3] = null;
        }
        return a;
    }

    public Object clone() {
        try {
            ArrayDeque a;
            ArrayDeque a2 = (ArrayDeque)super.clone();
            ((ArrayDeque)super.clone()).elements = Arrays.copyOf(a.elements, a.elements.length);
            return a2;
        }
        catch (CloneNotSupportedException a) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream a) throws IOException {
        int a2;
        ArrayDeque a3;
        a.defaultWriteObject();
        a.writeInt(a3.size());
        int a4 = a3.elements.length - 1;
        int n = a2 = a3.head;
        while (n != a3.tail) {
            a.writeObject(a3.elements[a2]);
            n = a2 + 1 & a4;
        }
    }

    private void readObject(ObjectInputStream a) throws IOException, ClassNotFoundException {
        int a2;
        ArrayDeque a3;
        a.defaultReadObject();
        int a4 = a.readInt();
        a3.DaA(a4);
        a3.head = 0;
        a3.tail = a4;
        int n = a2 = 0;
        while (n < a4) {
            a3.elements[a2] = a.readObject();
            n = ++a2;
        }
    }

    static {
        $assertionsDisabled = !ArrayDeque.class.desiredAssertionStatus();
    }

    private class DescendingIterator
    implements Iterator {
        private int L;
        private int l;
        private int K;

        private DescendingIterator() {
            DescendingIterator a;
            a.L = a.ArrayDeque.this.tail;
            a.l = a.ArrayDeque.this.head;
            a.K = -1;
        }

        public boolean hasNext() {
            DescendingIterator a;
            return a.L != a.l;
        }

        public Object next() {
            DescendingIterator a;
            if (a.L == a.l) {
                throw new NoSuchElementException();
            }
            a.L = a.L - 1 & a.ArrayDeque.this.elements.length - 1;
            Object a2 = a.ArrayDeque.this.elements[a.L];
            if (a.ArrayDeque.this.head != a.l || a2 == null) {
                throw new ConcurrentModificationException();
            }
            a.K = a.L;
            return a2;
        }

        public void remove() {
            DescendingIterator a;
            if (a.K < 0) {
                throw new IllegalStateException();
            }
            if (!a.ArrayDeque.this.delete(a.K)) {
                a.L = a.L + 1 & a.ArrayDeque.this.elements.length - 1;
                a.l = a.ArrayDeque.this.head;
            }
            a.K = -1;
        }
    }

    private class DeqIterator
    implements Iterator {
        private int L;
        private int l;
        private int K;

        private DeqIterator() {
            DeqIterator a;
            a.L = a.ArrayDeque.this.head;
            a.l = a.ArrayDeque.this.tail;
            a.K = -1;
        }

        public boolean hasNext() {
            DeqIterator a;
            return a.L != a.l;
        }

        public Object next() {
            DeqIterator a;
            if (a.L == a.l) {
                throw new NoSuchElementException();
            }
            Object a2 = a.ArrayDeque.this.elements[a.L];
            if (a.ArrayDeque.this.tail != a.l || a2 == null) {
                throw new ConcurrentModificationException();
            }
            a.K = a.L;
            a.L = a.L + 1 & a.ArrayDeque.this.elements.length - 1;
            return a2;
        }

        public void remove() {
            DeqIterator a;
            if (a.K < 0) {
                throw new IllegalStateException();
            }
            if (a.ArrayDeque.this.delete(a.K)) {
                a.L = a.L - 1 & a.ArrayDeque.this.elements.length - 1;
                a.l = a.ArrayDeque.this.tail;
            }
            a.K = -1;
        }
    }
}

