/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.pdfreader.impl;

import com.amazon.ebook.booklet.pdfreader.impl.lb;
import com.amazon.ebook.booklet.reader.sdk.Position;
import com.amazon.ebook.booklet.reader.sdk.q;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PDFPosition
extends Position {
    private static final String LOC_DISPLAY_RB_NAME = "com.amazon.ebook.booklet.reader.resources.LocationDisplayResources";
    private final String _pageName;
    private final String _pdfLocationString;
    private final float _hitOffset;
    private final double _xHitLocation;
    private final double _yHitLocation;
    private final int _scrollOffset;
    private static final int PDF_NORMALIZATION_FACTOR = 4000;
    private static final String PDF_PAGE_LOC_TAG = "#pdfloc(";
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFPosition(int a2, int a3, int a4, String a5) {
        PDFPosition a6;
        a6.position = a2;
        a6.lastPositionInBook = a4;
        a6.firstPositionInBook = a3;
        a6.lastPositionInFullBook = -1;
        a6.isFirstPositionInBookValid = true;
        a6._pageName = a5;
        a6._pdfLocationString = "";
        a6._hitOffset = 0.0f;
        a6._xHitLocation = -1.0;
        a6._yHitLocation = -1.0;
        a6._scrollOffset = 0;
    }

    public PDFPosition(int a2, String a3, String a4, float a5) {
        a6(a2, a2, a3, a4, a5);
        PDFPosition a6;
    }

    public PDFPosition(int a2, int a3, String a4, String a5, float a6) {
        a7(a2, a3, a4, a5, a6, 0);
        PDFPosition a7;
    }

    public PDFPosition(int a2, int a3, String a4, String a5, float a6, int a7) {
        PDFPosition a8;
        a8.position = a2;
        a8.lastPositionInBook = a3;
        a8.firstPositionInBook = a2;
        a8.lastPositionInFullBook = -1;
        a8.isFirstPositionInBookValid = true;
        a8._pageName = a4;
        a8._pdfLocationString = a5 == null ? "" : a5;
        a8._hitOffset = a6;
        a8._xHitLocation = -1.0;
        a8._yHitLocation = -1.0;
        a8._scrollOffset = a7;
    }

    public PDFPosition(int a2, String a3, String a4, float a5, int a6) {
        a7(a2, a2, a3, a4, a5, a6);
        PDFPosition a7;
    }

    public PDFPosition(int a2, String a3, String a4, double a5, double a6, float a7, int a8) {
        PDFPosition a9;
        a9.position = a2;
        a9.lastPositionInBook = a2;
        a9.firstPositionInBook = a2;
        a9.lastPositionInFullBook = -1;
        a9.isFirstPositionInBookValid = true;
        a9._pageName = a3;
        a9._pdfLocationString = a4 == null ? "" : a4;
        a9._hitOffset = a7;
        a9._xHitLocation = a5;
        a9._yHitLocation = a6;
        a9._scrollOffset = a8;
    }

    public static Position zZB(int a2, String a3, lb a4) {
        return new PDFPosition(a2, a2, a4.To(), a3);
    }

    public int qpB(q a2) {
        PDFPosition a3;
        if (a2 == q.m) {
            return a3.position + 1;
        }
        if (a2 == q.L) {
            return a3.lastPositionInBook * 4000;
        }
        return -1;
    }

    public String rpB(q a2) {
        PDFPosition a3;
        if (a2 == q.m) {
            if (a3._pageName != null && a3._pageName.length() > 0) {
                return lb.uaC(a3._pageName);
            }
            if (a3.position == 0) {
                return "";
            }
            return ((NumberFormat)ResourceBundle.getBundle(LOC_DISPLAY_RB_NAME).getObject("location.number.format")).format(a3.position + 1);
        }
        if (a2 == q.l) {
            if (a3._pageName != null && a3._pageName.length() > 0) {
                return lb.uaC(a3._pageName);
            }
            if (a3._pageName == null || a3._pageName.length() == 0) {
                return "";
            }
        } else if (a2 == q.L) {
            return ((NumberFormat)ResourceBundle.getBundle(LOC_DISPLAY_RB_NAME).getObject("location.number.format")).format(a3.qpB(a2));
        }
        return "";
    }

    private static int[] TZB(String a2, String a3) {
        int a4;
        StringTokenizer a5 = new StringTokenizer(a2, a3);
        int[] a6 = new int[a5.countTokens() - 1];
        a5.nextToken();
        int n2 = a4 = 0;
        while (n2 < a6.length) {
            a6[a4] = Integer.parseInt(a5.nextToken());
            n2 = ++a4;
        }
        if (!$assertionsDisabled && a5.hasMoreTokens()) {
            throw new AssertionError();
        }
        return a6;
    }

    public static String TzB(String a2) {
        int a3 = PDF_PAGE_LOC_TAG.length();
        if (!a2.substring(0, a3).equals(PDF_PAGE_LOC_TAG) || a2.charAt(a2.length() - 1) != ')') {
            throw new IllegalArgumentException();
        }
        int[] a4 = PDFPosition.TZB(a2.substring(a3, a2.length() - 1), ",");
        StringBuffer a5 = new StringBuffer(20);
        a5.append(a2.substring(0, a3 + 5));
        a5.append(a4[0]);
        a5.append(')');
        return a5.toString();
    }

    public static String JzB(String a2) {
        int a3 = PDF_PAGE_LOC_TAG.length();
        if (!a2.substring(0, a3).equals(PDF_PAGE_LOC_TAG) || a2.charAt(a2.length() - 1) != ')') {
            throw new IllegalArgumentException();
        }
        int[] a4 = PDFPosition.TZB(a2.substring(a3, a2.length() - 1), ",");
        StringBuffer a5 = new StringBuffer(20);
        a5.append(a2.substring(0, a3 + 5));
        a5.append(a4[0]);
        a5.append(',');
        a5.append(a4[1]);
        a5.append("0,0,0,0,0)");
        return a5.toString();
    }

    public static int YXB(String a2, String a3) {
        int a4;
        if (a2.length() == 0 || a3.length() == 0) {
            return 0;
        }
        int a5 = PDF_PAGE_LOC_TAG.length();
        if (!a2.substring(0, a5).equals(PDF_PAGE_LOC_TAG) || !a3.substring(0, a5).equals(PDF_PAGE_LOC_TAG) || a2.charAt(a2.length() - 1) != ')' || a3.charAt(a3.length() - 1) != ')') {
            throw new IllegalArgumentException();
        }
        int[] a6 = PDFPosition.TZB(a2.substring(a5, a2.length() - 1), ",");
        int[] a7 = PDFPosition.TZB(a3.substring(a5, a3.length() - 1), ",");
        int n2 = a4 = 0;
        int[] nArray = a6;
        while (n2 < nArray.length && a4 < a7.length) {
            if (a6[a4] != a7[a4]) {
                return a6[a4] - a7[a4];
            }
            n2 = ++a4;
            nArray = a6;
        }
        if (a6.length != a7.length) {
            return a6.length - a7.length;
        }
        return 0;
    }

    public static String jac(String a2) {
        int a3 = PDF_PAGE_LOC_TAG.length();
        int a4 = 7;
        int[] a5 = PDFPosition.TZB(a2.substring(a3, a2.length() - 1), ",");
        if (a5.length != 7) {
            return a2;
        }
        StringBuffer a6 = new StringBuffer(a2.length() + 1);
        a6.append(a2.substring(0, 13));
        a6.append(a5[0]);
        a6.append(',');
        a6.append(a5[1]);
        a6.append(',');
        a6.append(a5[2]);
        a6.append(',');
        a6.append(a5[3] + 1);
        a6.append(',');
        a6.append(a5[4]);
        a6.append(',');
        a6.append(a5[5]);
        a6.append(',');
        a6.append(a5[6]);
        a6.append(')');
        return a6.toString();
    }

    public static String jYB(String a2) {
        int a3 = PDF_PAGE_LOC_TAG.length();
        int a4 = 7;
        int[] a5 = PDFPosition.TZB(a2.substring(a3, a2.length() - 1), ",");
        if (a5.length != 7) {
            return a2;
        }
        StringBuffer a6 = new StringBuffer(a2.length() + 1);
        a6.append(a2.substring(0, 13));
        a6.append(a5[0]);
        a6.append(',');
        a6.append(a5[1]);
        a6.append(',');
        a6.append(a5[2]);
        a6.append(',');
        a6.append(a5[3] - 1);
        a6.append(',');
        a6.append(a5[4]);
        a6.append(',');
        a6.append(a5[5]);
        a6.append(',');
        a6.append(a5[6]);
        a6.append(')');
        return a6.toString();
    }

    public int compareTo(Object a2) {
        PDFPosition a3;
        if (!(a2 instanceof PDFPosition)) {
            throw new IllegalArgumentException();
        }
        PDFPosition a4 = (PDFPosition)((Object)a2);
        if (a3.position != a4.position) {
            return a3.position - a4.position;
        }
        if (a3._scrollOffset != a4._scrollOffset) {
            return a3._scrollOffset - a4._scrollOffset;
        }
        if (a3._pdfLocationString.length() == 0 || a4._pdfLocationString.length() == 0) {
            return 0;
        }
        return PDFPosition.YXB(a3.CyB(), a4.CyB());
    }

    public boolean equals(Object a2) {
        if (a2 != null && a2 instanceof PDFPosition) {
            PDFPosition a3;
            PDFPosition a4 = (PDFPosition)((Object)a2);
            if (a3.position == a4.position && a3.firstPositionInBook == a4.firstPositionInBook && a3.lastPositionInBook == a4.lastPositionInBook && a3.isFirstPositionInBookValid == a4.isFirstPositionInBookValid && a3._scrollOffset == a4._scrollOffset && a3._pdfLocationString.equals(a4._pdfLocationString)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        PDFPosition a2;
        return a2.position * 100 + a2._scrollOffset + a2._pdfLocationString == null ? 0 : a2._pdfLocationString.hashCode();
    }

    public int ZJA() {
        PDFPosition a2;
        return a2.position;
    }

    public String PQB() {
        PDFPosition a2;
        return MessageFormat.format(ResourceBundle.getBundle("com.amazon.ebook.booklet.pdfreader.impl.resources.PDFResources").getString("custom.end.location.label.pattern"), new Integer(a2.position + 1), new Integer(a2.lastPositionInBook));
    }

    public void azB(int a2) {
        a.position = a2;
        a.lastPositionInBook = a2;
        a.firstPositionInBook = 0;
    }

    public int xpB(Position a2) {
        return 0;
    }

    public void lzB(int a2) {
        a.position = a2;
    }

    public String CyB() {
        PDFPosition a2;
        return a2._pdfLocationString;
    }

    public double hZB() {
        PDFPosition a2;
        return a2._xHitLocation;
    }

    public double yZB() {
        PDFPosition a2;
        return a2._yHitLocation;
    }

    public String UyB() {
        PDFPosition a2;
        return a2._pageName;
    }

    public String toString() {
        PDFPosition a2;
        return MessageFormat.format(ResourceBundle.getBundle("com.amazon.ebook.booklet.pdfreader.impl.resources.PDFResources").getString("position.toString.pattern"), new Integer(a2.position), new Integer(a2._scrollOffset), new Integer(a2.firstPositionInBook), new Integer(a2.lastPositionInBook), a2._pdfLocationString, new Double(a2._xHitLocation), new Double(a2._yHitLocation), new Float(a2._hitOffset));
    }

    public float FZB() {
        PDFPosition a2;
        return a2._hitOffset;
    }

    public int qXB() {
        PDFPosition a2;
        return a2._scrollOffset;
    }

    public PDFPosition ezB() {
        PDFPosition a2;
        return new PDFPosition(a2.position, a2._pageName, a2._pdfLocationString, a2._xHitLocation, a2._yHitLocation, a2._hitOffset, 0);
    }

    public int vQB() {
        PDFPosition a2;
        double a3 = 0.0;
        if (a2.lastPositionInBook < 0) {
            return 0;
        }
        if (a2.lastPositionInBook == 0) {
            return 100;
        }
        a3 = (double)(a2.position + 1) / (double)a2.lastPositionInBook;
        int a4 = (int)(a3 * 100.0);
        if (a4 < 1) {
            a4 = 1;
        }
        return a4;
    }

    public String JpB() {
        PDFPosition a2;
        String a3 = a2.rpB(q.m);
        String a4 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources").getString("gui.reader_pdf_position");
        Object[] a5 = new Object[]{a3};
        return MessageFormat.format(a4, a5);
    }

    public String lPB(Position a2) {
        PDFPosition a3;
        String a4 = a3.rpB(q.m);
        String a5 = a2.rpB(q.m);
        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        if (a4.equals(a5)) {
            String a7 = a6.getString("gui.reader_pdf_position");
            Object[] a8 = new Object[]{a4};
            return MessageFormat.format(a7, a8);
        }
        String a9 = a6.getString("gui.reader_pdf_position_range");
        Object[] a10 = new Object[]{a4, a5};
        return MessageFormat.format(a9, a10);
    }

    static {
        $assertionsDisabled = !PDFPosition.class.desiredAssertionStatus();
    }
}

