/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONTokener;
import org.json.XML;

public class XMLTokener
extends JSONTokener {
    public static final HashMap entity = new HashMap(8);

    public XMLTokener(String a) {
        super(a);
        XMLTokener a2;
    }

    public String nextCDATA() throws JSONException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            XMLTokener a;
            char c;
            if ((c = a.next()) == '\u0000') {
                throw a.syntaxError("Unclosed CDATA.");
            }
            stringBuffer.append(c);
        } while ((n = stringBuffer.length() - 3) < 0 || stringBuffer.charAt(n) != ']' || stringBuffer.charAt(n + 1) != ']' || stringBuffer.charAt(n + 2) != '>');
        stringBuffer.setLength(n);
        return stringBuffer.toString();
    }

    public Object nextContent() throws JSONException {
        XMLTokener a;
        char c;
        while (Character.isWhitespace(c = a.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XML.LT;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (c == '<' || c == '\u0000') {
                a.back();
                return stringBuffer.toString().trim();
            }
            if (c == '&') {
                stringBuffer.append(a.nextEntity(c));
            } else {
                stringBuffer.append(c);
            }
            c = a.next();
        }
    }

    public Object nextEntity(char a) throws JSONException {
        XMLTokener a2;
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(c = a2.next()) || c == '#') {
            stringBuffer.append(Character.toLowerCase(c));
        }
        if (c != ';') {
            throw a2.syntaxError("Missing ';' in XML entity: &" + stringBuffer);
        }
        String string = stringBuffer.toString();
        Object v = entity.get(string);
        return v != null ? v : a + string + ";";
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object nextMeta() throws JSONException {
        XMLTokener a;
        char c;
        while (Character.isWhitespace(c = a.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw a.syntaxError("Misshaped meta tag.");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                do {
                    if ((c = a.next()) != '\u0000') continue;
                    throw a.syntaxError("Unterminated string.");
                } while (c != c2);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c = a.next())) {
            switch (c) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    a.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object nextToken() throws JSONException {
        XMLTokener a;
        char c;
        while (Character.isWhitespace(c = a.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw a.syntaxError("Misshaped element.");
            }
            case '<': {
                throw a.syntaxError("Misplaced '<'.");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    XMLTokener xMLTokener = a;
                    while (true) {
                        if ((c = xMLTokener.next()) == '\u0000') {
                            throw a.syntaxError("Unterminated string.");
                        }
                        if (c == c2) {
                            return stringBuffer.toString();
                        }
                        if (c != '&') break;
                        stringBuffer.append(a.nextEntity(c));
                        xMLTokener = a;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(c);
            c = a.next();
            if (Character.isWhitespace(c)) {
                return stringBuffer.toString();
            }
            switch (c) {
                case '\u0000': 
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    a.back();
                    return stringBuffer.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw a.syntaxError("Bad character in a name.");
                }
            }
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

