/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTokener {
    private int K = 0;
    private String f;

    public JSONTokener(String a) {
        JSONTokener a2;
        a2.f = a;
    }

    public void back() {
        JSONTokener a;
        if (a.K > 0) {
            --a.K;
        }
    }

    public static int dehexchar(char a) {
        if (a >= '0' && a <= '9') {
            return a - 48;
        }
        if (a >= 'A' && a <= 'F') {
            return a - 55;
        }
        if (a >= 'a' && a <= 'f') {
            return a - 87;
        }
        return -1;
    }

    public boolean more() {
        JSONTokener a;
        return a.K < a.f.length();
    }

    public char next() {
        JSONTokener a;
        if (a.more()) {
            char c = a.f.charAt(a.K);
            ++a.K;
            return c;
        }
        return '\u0000';
    }

    public char next(char a) throws JSONException {
        JSONTokener a2;
        char c = a2.next();
        if (c != a) {
            throw a2.syntaxError("Expected '" + a + "' and instead saw '" + c + "'.");
        }
        return c;
    }

    public String next(int a) throws JSONException {
        JSONTokener a2;
        int n = a2.K;
        int n2 = n + a;
        if (n2 >= a2.f.length()) {
            throw a2.syntaxError("Substring bounds error");
        }
        a2.K += a;
        return a2.f.substring(n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public char nextClean() throws JSONException {
        block4: while (true) {
            block11: {
                if ((var1_1 = a.next()) != '/') break block11;
                switch (a.next()) lbl-1000:
                // 2 sources

                {
                    case '/': {
                        do {
                            if (false) ** GOTO lbl-1000
                        } while ((var1_1 = a.next()) != '\n' && var1_1 != '\r' && var1_1 != '\u0000');
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((var1_1 = a.next()) == '\u0000') {
                                throw a.syntaxError("Unclosed comment.");
                            }
                            if (var1_1 != '*') continue;
                            if (a.next() == '/') continue block4;
                            a.back();
                        }
                    }
                    default: {
                        a.back();
                        return '/';
                    }
                }
            }
            if (var1_1 == '#') {
                while ((var1_1 = a.next()) != '\n' && var1_1 != '\r' && var1_1 != '\u0000') {
                }
                continue;
            }
            if (var1_1 == '\u0000' || var1_1 > ' ') break;
        }
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextString(char a) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            JSONTokener a2;
            char c = a2.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw a2.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = a2.next();
                    switch (c) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(a2.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(a2.next(2), 16));
                            continue block13;
                        }
                    }
                    stringBuffer.append(c);
                    continue block13;
                }
            }
            if (c == a) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c);
        }
    }

    public String nextTo(char a) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            JSONTokener a2;
            char c;
            if ((c = a2.next()) == a || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    a2.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c);
        }
    }

    public String nextTo(String a) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            JSONTokener a2;
            char c;
            if (a.indexOf(c = a2.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    a2.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nextValue() throws JSONException {
        JSONTokener a;
        int n = a.nextClean();
        switch (n) {
            case 34: 
            case 39: {
                return a.nextString((char)n);
            }
            case 123: {
                a.back();
                return new JSONObject(a);
            }
            case 91: {
                a.back();
                return new JSONArray(a);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        int n3 = n;
        int n4 = 32;
        while (n3 >= n4 && ",:]}/\\\"[{;=#".indexOf(n) < 0) {
            stringBuffer.append((char)n);
            n3 = a.next();
            n4 = 32;
        }
        a.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw a.syntaxError("Missing value.");
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return JSONObject.NULL;
        }
        if ((n2 < 48 || n2 > 57) && n2 != 46 && n2 != 45 && n2 != 43) {
            return string;
        }
        if (n2 == 48) {
            if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                try {
                    return new Integer(Integer.parseInt(string.substring(2), 16));
                }
                catch (Exception exception) {
                }
            } else {
                try {
                    return new Integer(Integer.parseInt(string, 8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            return new Integer(string);
        }
        catch (Exception exception) {
            try {
                return new Long(string);
            }
            catch (Exception exception2) {
                try {
                    return new Double(string);
                }
                catch (Exception exception3) {
                    return string;
                }
            }
        }
    }

    public char skipTo(char a) {
        char c;
        JSONTokener a2;
        int n = a2.K;
        do {
            if ((c = a2.next()) != '\u0000') continue;
            a2.K = n;
            return c;
        } while (c != a);
        a2.back();
        return c;
    }

    public void skipPast(String a) {
        JSONTokener a2;
        a2.K = a2.f.indexOf(a, a2.K);
        a2.K = a2.K < 0 ? a2.f.length() : (a2.K += a.length());
    }

    public JSONException syntaxError(String a) {
        JSONTokener a2;
        return new JSONException(a + a2.toString());
    }

    public String toString() {
        JSONTokener a;
        return " at character " + a.K + " of " + a.f;
    }
}

