/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

public class JSONObject {
    private HashMap f;
    public static final Object NULL = new Null();

    public JSONObject() {
        JSONObject a;
        a.f = new HashMap();
    }

    public JSONObject(JSONObject a, String[] a2) throws JSONException {
        a3();
        int n;
        JSONObject a3;
        int n2 = n = 0;
        while (n2 < a2.length) {
            a3.putOpt(a2[n], a.opt(a2[n]));
            n2 = ++n;
        }
    }

    public JSONObject(JSONTokener a) throws JSONException {
        a2();
        JSONObject a2;
        if (a.nextClean() != '{') {
            throw a.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = a.nextClean();
            switch (c) {
                case '\u0000': {
                    throw a.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            a.back();
            String string = a.nextValue().toString();
            c = a.nextClean();
            if (c == '=') {
                if (a.next() != '>') {
                    a.back();
                }
            } else if (c != ':') {
                throw a.syntaxError("Expected a ':' after a key");
            }
            a2.f.put(string, a.nextValue());
            switch (a.nextClean()) {
                case ',': 
                case ';': {
                    if (a.nextClean() == '}') {
                        return;
                    }
                    a.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw a.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map a) {
        JSONObject a2;
        a2.f = new HashMap(a);
    }

    public JSONObject(String a) throws JSONException {
        a2(new JSONTokener(a));
        JSONObject a2;
    }

    public JSONObject accumulate(String a, Object a2) throws JSONException {
        JSONObject a3;
        JSONObject.mU(a2);
        Object object = a3.opt(a);
        if (object == null) {
            a3.put(a, a2);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(a2);
        } else {
            a3.put(a, new JSONArray().put(object).put(a2));
        }
        return a3;
    }

    public Object get(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.opt(a);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(a) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.get(a);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(a) + "] is not a Boolean.");
    }

    public double getDouble(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.get(a);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("JSONObject[" + JSONObject.quote(a) + "] is not a number.");
        }
    }

    public int getInt(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.get(a);
        return object instanceof Number ? ((Number)object).intValue() : (int)a2.getDouble(a);
    }

    public JSONArray getJSONArray(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.get(a);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(a) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.get(a);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(a) + "] is not a JSONObject.");
    }

    public long getLong(String a) throws JSONException {
        JSONObject a2;
        Object object = a2.get(a);
        return object instanceof Number ? ((Number)object).longValue() : (long)a2.getDouble(a);
    }

    public String getString(String a) throws JSONException {
        JSONObject a2;
        return a2.get(a).toString();
    }

    public boolean has(String a) {
        JSONObject a2;
        return a2.f.containsKey(a);
    }

    public boolean isNull(String a) {
        JSONObject a2;
        return NULL.equals(a2.opt(a));
    }

    public Iterator keys() {
        JSONObject a;
        return a.f.keySet().iterator();
    }

    public int length() {
        JSONObject a;
        return a.f.size();
    }

    public JSONArray names() {
        JSONObject a;
        Iterator iterator;
        JSONArray jSONArray = new JSONArray();
        Iterator iterator2 = iterator = a.keys();
        while (iterator2.hasNext()) {
            jSONArray.put(iterator.next());
            iterator2 = iterator;
        }
        return jSONArray.length() == 0 ? null : jSONArray;
    }

    public static String numberToString(Number a) throws JSONException {
        if (a == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.mU(a);
        String string = a.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            String string2 = string;
            while (string2.endsWith("0")) {
                string2 = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String a) {
        JSONObject a2;
        return a == null ? null : a2.f.get(a);
    }

    public boolean optBoolean(String a) {
        JSONObject a2;
        return a2.optBoolean(a, false);
    }

    public boolean optBoolean(String a, boolean a2) {
        try {
            JSONObject a3;
            return a3.getBoolean(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public double optDouble(String a) {
        JSONObject a2;
        return a2.optDouble(a, Double.NaN);
    }

    public double optDouble(String a, double a2) {
        try {
            JSONObject a3;
            Object object = a3.opt(a);
            return object instanceof Number ? ((Number)object).doubleValue() : new Double((String)object).doubleValue();
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public int optInt(String a) {
        JSONObject a2;
        return a2.optInt(a, 0);
    }

    public int optInt(String a, int a2) {
        try {
            JSONObject a3;
            return a3.getInt(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public JSONArray optJSONArray(String a) {
        JSONObject a2;
        Object object = a2.opt(a);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(String a) {
        JSONObject a2;
        Object object = a2.opt(a);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(String a) {
        JSONObject a2;
        return a2.optLong(a, 0L);
    }

    public long optLong(String a, long a2) {
        try {
            JSONObject a3;
            return a3.getLong(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public String optString(String a) {
        JSONObject a2;
        return a2.optString(a, "");
    }

    public String optString(String a, String a2) {
        JSONObject a3;
        Object object = a3.opt(a);
        return object != null ? object.toString() : a2;
    }

    public JSONObject put(String a, boolean a2) throws JSONException {
        JSONObject a3;
        a3.put(a, a2 ? Boolean.TRUE : Boolean.FALSE);
        return a3;
    }

    public JSONObject put(String a, double a2) throws JSONException {
        JSONObject a3;
        a3.put(a, new Double(a2));
        return a3;
    }

    public JSONObject put(String a, int a2) throws JSONException {
        JSONObject a3;
        a3.put(a, new Integer(a2));
        return a3;
    }

    public JSONObject put(String a, long a2) throws JSONException {
        JSONObject a3;
        a3.put(a, new Long(a2));
        return a3;
    }

    public JSONObject put(String a, Object a2) throws JSONException {
        JSONObject a3;
        if (a == null) {
            throw new JSONException("Null key.");
        }
        if (a2 != null) {
            JSONObject.mU(a2);
            a3.f.put(a, a2);
        } else {
            a3.remove(a);
        }
        return a3;
    }

    public JSONObject putOpt(String a, Object a2) throws JSONException {
        JSONObject a3;
        if (a != null && a2 != null) {
            a3.put(a, a2);
        }
        return a3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String quote(String a) {
        int n;
        if (a == null || a.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n2 = a.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 4);
        stringBuffer.append('\"');
        int n3 = n = 0;
        while (true) {
            if (n3 >= n2) {
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            char c2 = c;
            c = a.charAt(n);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ') {
                        String string = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string.substring(string.length() - 4));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            n3 = ++n;
        }
    }

    public Object remove(String a) {
        JSONObject a2;
        return a2.f.remove(a);
    }

    static void mU(Object a) throws JSONException {
        if (a != null) {
            if (a instanceof Double) {
                if (((Double)a).isInfinite() || ((Double)a).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (a instanceof Float && (((Float)a).isInfinite() || ((Float)a).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public JSONArray toJSONArray(JSONArray a) throws JSONException {
        int n;
        if (a == null || a.length() == 0) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        int n2 = n = 0;
        while (n2 < a.length()) {
            JSONObject a2;
            jSONArray.put(a2.opt(a.getString(n)));
            n2 = ++n;
        }
        return jSONArray;
    }

    public String toString() {
        try {
            JSONObject a;
            Iterator iterator = a.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e = iterator.next();
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.TU(a.f.get(e)));
                iterator2 = iterator;
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int a) throws JSONException {
        JSONObject a2;
        return a2.YS(a, 0);
    }

    String YS(int a, int a2) throws JSONException {
        JSONObject a3;
        int n = a3.length();
        if (n == 0) {
            return "{}";
        }
        Iterator iterator = a3.keys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n2 = a2 + a;
        if (n == 1) {
            Object e = iterator.next();
            stringBuffer.append(JSONObject.quote(e.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.gS(a3.f.get(e), a, a2));
        } else {
            int n3;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                int n4 = n3 = 0;
                while (n4 < n2) {
                    stringBuffer.append(' ');
                    n4 = ++n3;
                }
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.gS(a3.f.get(e), a, n2));
                iterator2 = iterator;
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                int n5 = n3 = 0;
                while (n5 < a2) {
                    stringBuffer.append(' ');
                    n5 = ++n3;
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String TU(Object a) throws JSONException {
        if (a == null || a.equals(null)) {
            return "null";
        }
        if (a instanceof Number) {
            return JSONObject.numberToString((Number)a);
        }
        if (a instanceof Boolean || a instanceof JSONObject || a instanceof JSONArray) {
            return a.toString();
        }
        return JSONObject.quote(a.toString());
    }

    static String gS(Object a, int a2, int a3) throws JSONException {
        if (a == null || a.equals(null)) {
            return "null";
        }
        if (a instanceof Number) {
            return JSONObject.numberToString((Number)a);
        }
        if (a instanceof Boolean) {
            return a.toString();
        }
        if (a instanceof JSONObject) {
            return ((JSONObject)a).YS(a2, a3);
        }
        if (a instanceof JSONArray) {
            return ((JSONArray)a).YS(a2, a3);
        }
        return JSONObject.quote(a.toString());
    }

    public Writer write(Writer a) throws JSONException {
        try {
            JSONObject a2;
            boolean bl = false;
            Iterator iterator = a2.keys();
            a.write(123);
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                if (bl) {
                    a.write(44);
                }
                Object e = iterator.next();
                a.write(JSONObject.quote(e.toString()));
                a.write(58);
                Object v = a2.f.get(e);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(a);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(a);
                } else {
                    a.write(JSONObject.TU(v));
                }
                bl = true;
                iterator2 = iterator;
            }
            a.write(125);
            return a;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    private static final class Null {
        private Null() {
            Null a;
        }

        protected final Object clone() {
            Null a;
            return a;
        }

        public boolean equals(Object a) {
            Null a2;
            return a == null || a == a2;
        }

        public String toString() {
            return "null";
        }
    }
}

