/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONArray {
    private ArrayList f;

    public JSONArray() {
        JSONArray a;
        a.f = new ArrayList();
    }

    public JSONArray(JSONTokener a) throws JSONException {
        a2();
        JSONArray a2;
        if (a.nextClean() != '[') {
            throw a.syntaxError("A JSONArray text must start with '['");
        }
        if (a.nextClean() == ']') {
            return;
        }
        a.back();
        block4: while (true) {
            if (a.nextClean() == ',') {
                a.back();
                a2.f.add(null);
            } else {
                a.back();
                a2.f.add(a.nextValue());
            }
            switch (a.nextClean()) {
                case ',': 
                case ';': {
                    if (a.nextClean() == ']') {
                        return;
                    }
                    a.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw a.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String a) throws JSONException {
        a2(new JSONTokener(a));
        JSONArray a2;
    }

    public JSONArray(Collection a) {
        JSONArray a2;
        a2.f = new ArrayList(a);
    }

    public Object get(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.opt(a);
        if (object == null) {
            throw new JSONException("JSONArray[" + a + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.get(a);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + a + "] is not a Boolean.");
    }

    public double getDouble(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.get(a);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("JSONArray[" + a + "] is not a number.");
        }
    }

    public int getInt(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.get(a);
        return object instanceof Number ? ((Number)object).intValue() : (int)a2.getDouble(a);
    }

    public JSONArray getJSONArray(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.get(a);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + a + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.get(a);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONArray[" + a + "] is not a JSONObject.");
    }

    public long getLong(int a) throws JSONException {
        JSONArray a2;
        Object object = a2.get(a);
        return object instanceof Number ? ((Number)object).longValue() : (long)a2.getDouble(a);
    }

    public String getString(int a) throws JSONException {
        JSONArray a2;
        return a2.get(a).toString();
    }

    public boolean isNull(int a) {
        JSONArray a2;
        return JSONObject.NULL.equals(a2.opt(a));
    }

    public String join(String a) throws JSONException {
        int n;
        JSONArray a2;
        int n2 = a2.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n = 0;
        while (n3 < n2) {
            if (n > 0) {
                stringBuffer.append(a);
            }
            stringBuffer.append(JSONObject.TU(a2.f.get(n)));
            n3 = ++n;
        }
        return stringBuffer.toString();
    }

    public int length() {
        JSONArray a;
        return a.f.size();
    }

    public Object opt(int a) {
        JSONArray a2;
        return a < 0 || a >= a2.length() ? null : a2.f.get(a);
    }

    public boolean optBoolean(int a) {
        JSONArray a2;
        return a2.optBoolean(a, false);
    }

    public boolean optBoolean(int a, boolean a2) {
        try {
            JSONArray a3;
            return a3.getBoolean(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public double optDouble(int a) {
        JSONArray a2;
        return a2.optDouble(a, Double.NaN);
    }

    public double optDouble(int a, double a2) {
        try {
            JSONArray a3;
            return a3.getDouble(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public int optInt(int a) {
        JSONArray a2;
        return a2.optInt(a, 0);
    }

    public int optInt(int a, int a2) {
        try {
            JSONArray a3;
            return a3.getInt(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public JSONArray optJSONArray(int a) {
        JSONArray a2;
        Object object = a2.opt(a);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(int a) {
        JSONArray a2;
        Object object = a2.opt(a);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(int a) {
        JSONArray a2;
        return a2.optLong(a, 0L);
    }

    public long optLong(int a, long a2) {
        try {
            JSONArray a3;
            return a3.getLong(a);
        }
        catch (Exception exception) {
            return a2;
        }
    }

    public String optString(int a) {
        JSONArray a2;
        return a2.optString(a, "");
    }

    public String optString(int a, String a2) {
        JSONArray a3;
        Object object = a3.opt(a);
        return object != null ? object.toString() : a2;
    }

    public JSONArray put(boolean a) {
        JSONArray a2;
        a2.put(a ? Boolean.TRUE : Boolean.FALSE);
        return a2;
    }

    public JSONArray put(double a) throws JSONException {
        JSONArray a2;
        Double d = new Double(a);
        JSONObject.mU(d);
        a2.put(d);
        return a2;
    }

    public JSONArray put(int a) {
        JSONArray a2;
        a2.put(new Integer(a));
        return a2;
    }

    public JSONArray put(long a) {
        JSONArray a2;
        a2.put(new Long(a));
        return a2;
    }

    public JSONArray put(Object a) {
        JSONArray a2;
        a2.f.add(a);
        return a2;
    }

    public JSONArray put(int a, boolean a2) throws JSONException {
        JSONArray a3;
        a3.put(a, a2 ? Boolean.TRUE : Boolean.FALSE);
        return a3;
    }

    public JSONArray put(int a, double a2) throws JSONException {
        JSONArray a3;
        a3.put(a, new Double(a2));
        return a3;
    }

    public JSONArray put(int a, int a2) throws JSONException {
        JSONArray a3;
        a3.put(a, new Integer(a2));
        return a3;
    }

    public JSONArray put(int a, long a2) throws JSONException {
        JSONArray a3;
        a3.put(a, new Long(a2));
        return a3;
    }

    public JSONArray put(int a, Object a2) throws JSONException {
        JSONArray a3;
        JSONObject.mU(a2);
        if (a < 0) {
            throw new JSONException("JSONArray[" + a + "] not found.");
        }
        if (a < a3.length()) {
            a3.f.set(a, a2);
        } else {
            int n = a;
            while (n != a3.length()) {
                a3.put(null);
                n = a;
            }
            a3.put(a2);
        }
        return a3;
    }

    public JSONObject toJSONObject(JSONArray a) throws JSONException {
        int n;
        JSONArray a2;
        if (a == null || a.length() == 0 || a2.length() == 0) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        int n2 = n = 0;
        while (n2 < a.length()) {
            jSONObject.put(a.getString(n), a2.opt(n));
            n2 = ++n;
        }
        return jSONObject;
    }

    public String toString() {
        try {
            JSONArray a;
            return '[' + a.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int a) throws JSONException {
        JSONArray a2;
        return a2.YS(a, 0);
    }

    String YS(int a, int a2) throws JSONException {
        JSONArray a3;
        int n = a3.length();
        if (n == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        if (n == 1) {
            stringBuffer.append(JSONObject.gS(a3.f.get(0), a, a2));
        } else {
            int n2;
            int n3 = a2 + a;
            stringBuffer.append('\n');
            int n4 = n2 = 0;
            while (n4 < n) {
                int n5;
                if (n2 > 0) {
                    stringBuffer.append(",\n");
                }
                int n6 = n5 = 0;
                while (n6 < n3) {
                    stringBuffer.append(' ');
                    n6 = ++n5;
                }
                stringBuffer.append(JSONObject.gS(a3.f.get(n2), a, n3));
                n4 = ++n2;
            }
            stringBuffer.append('\n');
            int n7 = n2 = 0;
            while (n7 < a2) {
                stringBuffer.append(' ');
                n7 = ++n2;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Writer write(Writer a) throws JSONException {
        try {
            int n;
            JSONArray a2;
            boolean bl = false;
            int n2 = a2.length();
            a.write(91);
            int n3 = n = 0;
            while (n3 < n2) {
                Object e;
                if (bl) {
                    a.write(44);
                }
                if ((e = a2.f.get(n)) instanceof JSONObject) {
                    ((JSONObject)e).write(a);
                } else if (e instanceof JSONArray) {
                    ((JSONArray)e).write(a);
                } else {
                    a.write(JSONObject.TU(e));
                }
                bl = true;
                n3 = ++n;
            }
            a.write(93);
            return a;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

