/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Cookie {
    public Cookie() {
        Cookie a;
    }

    public static String escape(String a) {
        int n;
        String string = a.trim();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = n = 0;
        while (n3 < n2) {
            char c = string.charAt(n);
            if (c < ' ' || c == '+' || c == '%' || c == '=' || c == ';') {
                stringBuffer.append('%');
                stringBuffer.append(Character.forDigit((char)(c >>> 4 & 0xF), 16));
                stringBuffer.append(Character.forDigit((char)(c & 0xF), 16));
            } else {
                stringBuffer.append(c);
            }
            n3 = ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject toJSONObject(String a) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONTokener jSONTokener = new JSONTokener(a);
        jSONObject.put("name", jSONTokener.nextTo('='));
        jSONTokener.next('=');
        jSONObject.put("value", jSONTokener.nextTo(';'));
        jSONTokener.next();
        JSONTokener jSONTokener2 = jSONTokener;
        while (jSONTokener2.more()) {
            Object object;
            String string = Cookie.unescape(jSONTokener.nextTo("=;"));
            if (jSONTokener.next() != '=') {
                if (!string.equals("secure")) throw jSONTokener.syntaxError("Missing '=' in cookie parameter.");
                object = Boolean.TRUE;
            } else {
                object = Cookie.unescape(jSONTokener.nextTo(';'));
                jSONTokener.next();
            }
            jSONObject.put(string, object);
            jSONTokener2 = jSONTokener;
        }
        return jSONObject;
    }

    public static String toString(JSONObject a) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Cookie.escape(a.getString("name")));
        stringBuffer.append("=");
        stringBuffer.append(Cookie.escape(a.getString("value")));
        if (a.has("expires")) {
            stringBuffer.append(";expires=");
            stringBuffer.append(a.getString("expires"));
        }
        if (a.has("domain")) {
            stringBuffer.append(";domain=");
            stringBuffer.append(Cookie.escape(a.getString("domain")));
        }
        if (a.has("path")) {
            stringBuffer.append(";path=");
            stringBuffer.append(Cookie.escape(a.getString("path")));
        }
        if (a.optBoolean("secure")) {
            stringBuffer.append(";secure");
        }
        return stringBuffer.toString();
    }

    public static String unescape(String a) {
        int n;
        int n2 = a.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n = 0;
        while (n3 < n2) {
            char c = a.charAt(n);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && n + 2 < n2) {
                int n4 = JSONTokener.dehexchar(a.charAt(n + 1));
                int n5 = JSONTokener.dehexchar(a.charAt(n + 2));
                if (n4 >= 0 && n5 >= 0) {
                    c = (char)(n4 * 16 + n5);
                    n += 2;
                }
            }
            stringBuffer.append(c);
            n3 = ++n;
        }
        return stringBuffer.toString();
    }
}

