/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import jdbm.htree.HashNode;

final class HashBucket
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private ArrayList _keys;
    private ArrayList _values;

    public HashBucket() {
        HashBucket a2;
    }

    public HashBucket(int a2) {
        HashBucket a3;
        if (a2 > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + a2);
        }
        a3._depth = a2;
        a3._keys = new ArrayList(8);
        a3._values = new ArrayList(8);
    }

    public int yX() {
        HashBucket a2;
        return a2._keys.size();
    }

    public boolean KV() {
        HashBucket a2;
        return a2._depth > 3;
    }

    public boolean uv() {
        HashBucket a2;
        if (a2.KV()) {
            return true;
        }
        return a2._keys.size() < 8;
    }

    public Object yv(Object a2, Object a3) {
        HashBucket a4;
        int a5 = a4._keys.indexOf(a2);
        if (a5 != -1) {
            Object a6 = a4._values.get(a5);
            a4._values.set(a5, a3);
            return a6;
        }
        a4._keys.add(a2);
        a4._values.add(a3);
        return null;
    }

    public Object AX(Object a2) {
        HashBucket a3;
        int a4 = a3._keys.indexOf(a2);
        if (a4 != -1) {
            Object a5 = a3._values.get(a4);
            a3._keys.remove(a4);
            a3._values.remove(a4);
            return a5;
        }
        return null;
    }

    public Object tv(Object a2) {
        HashBucket a3;
        int a4 = a3._keys.indexOf(a2);
        if (a4 != -1) {
            return a3._values.get(a4);
        }
        return null;
    }

    ArrayList iw() {
        HashBucket a2;
        return a2._keys;
    }

    ArrayList Ax() {
        HashBucket a2;
        return a2._values;
    }

    public void writeExternal(ObjectOutput a2) throws IOException {
        int a3;
        HashBucket a4;
        a2.writeInt(a4._depth);
        int a5 = a4._keys.size();
        a2.writeInt(a5);
        int n2 = a3 = 0;
        while (n2 < a5) {
            a2.writeObject(a4._keys.get(a3));
            n2 = ++a3;
        }
        int n3 = a3 = 0;
        while (n3 < a5) {
            a2.writeObject(a4._values.get(a3));
            n3 = ++a3;
        }
    }

    public void readExternal(ObjectInput a2) throws IOException, ClassNotFoundException {
        HashBucket a3;
        int a4;
        a3._depth = a2.readInt();
        int a5 = a2.readInt();
        int a6 = Math.max(a5, 8);
        a3._keys = new ArrayList(a6);
        a3._values = new ArrayList(a6);
        int n2 = a4 = 0;
        while (n2 < a5) {
            a3._keys.add(a2.readObject());
            n2 = ++a4;
        }
        int n3 = a4 = 0;
        while (n3 < a5) {
            a3._values.add(a2.readObject());
            n3 = ++a4;
        }
    }

    public String toString() {
        HashBucket a2;
        StringBuffer a3 = new StringBuffer();
        a3.append("HashBucket {depth=");
        a3.append(a2._depth);
        a3.append(", keys=");
        a3.append(a2._keys);
        a3.append(", values=");
        a3.append(a2._values);
        a3.append("}");
        return a3.toString();
    }
}

