/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Comparator;
import jdbm.btree.BPage;
import jdbm.btree.d;
import jdbm.btree.h;
import jdbm.btree.v;
import jdbm.helper.Serializer;
import jdbm.helper.c;
import jdbm.helper.x;

public class BTree
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    protected transient jdbm.d _recman;
    private transient long _recid;
    protected Comparator _comparator;
    protected Serializer _keySerializer;
    protected Serializer _valueSerializer;
    private int _height;
    private transient long _root;
    protected int _pageSize;
    protected int _entries;
    private transient BPage _bpageSerializer;

    public BTree() {
        BTree a2;
    }

    public static BTree Dx(jdbm.d a2, Comparator a3) throws IOException {
        return BTree.BX(a2, a3, null, null, 16);
    }

    public static BTree NV(jdbm.d a2, Comparator a3, Serializer a4, Serializer a5) throws IOException {
        return BTree.BX(a2, a3, a4, a5, 16);
    }

    public static BTree BX(jdbm.d a2, Comparator a3, Serializer a4, Serializer a5, int a6) throws IOException {
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (a3 == null) {
            throw new IllegalArgumentException("Argument 'comparator' is null");
        }
        if (!(a3 instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'comparator' must be serializable");
        }
        if (a4 != null && !(a4 instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'keySerializer' must be serializable");
        }
        if (a5 != null && !(a5 instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'valueSerializer' must be serializable");
        }
        if ((a6 & 1) != 0) {
            throw new IllegalArgumentException("Argument 'pageSize' must be even");
        }
        BTree a7 = new BTree();
        new BTree()._recman = a2;
        a7._comparator = a3;
        a7._keySerializer = a4;
        a7._valueSerializer = a5;
        a7._pageSize = a6;
        a7._bpageSerializer = new BPage();
        a7._bpageSerializer._btree = a7;
        a7._recid = a2.HA(a7);
        return a7;
    }

    public static BTree xX(jdbm.d a2, long a3) throws IOException {
        BTree a4 = (BTree)a2.eA(a3);
        ((BTree)a2.eA(a3))._recid = a3;
        a4._recman = a2;
        a4._bpageSerializer = new BPage();
        a4._bpageSerializer._btree = a4;
        return a4;
    }

    public synchronized Object qX(Object a2, Object a3, boolean a4) throws IOException {
        BTree a5;
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        if (a3 == null) {
            throw new IllegalArgumentException("Argument 'value' is null");
        }
        BPage a6 = a5.QC();
        if (a6 == null) {
            a6 = new BPage(a5, a2, a3);
            a5._root = a6._recid;
            a5._height = 1;
            a5._entries = 1;
            a5._recman.dA(a5._recid, a5);
            return null;
        }
        v a7 = a6.iv(a5._height, a2, a3, a4);
        boolean a8 = false;
        if (a7.K != null) {
            a6 = new BPage(a5, a6, a7.K);
            a5._root = a6._recid;
            ++a5._height;
            a8 = true;
        }
        if (a7.f == null) {
            ++a5._entries;
            a8 = true;
        }
        if (a8) {
            a5._recman.dA(a5._recid, a5);
        }
        return a7.f;
    }

    public synchronized Object remove(Object a2) throws IOException {
        BTree a3;
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage a4 = a3.QC();
        if (a4 == null) {
            return null;
        }
        boolean a5 = false;
        d a6 = a4.Ov(a3._height, a2);
        if (a6.K && a4.isEmpty()) {
            --a3._height;
            a5 = true;
            a3._root = a3._height == 0 ? 0L : a4.Bx((int)(a3._pageSize - 1))._recid;
        }
        if (a6.f != null) {
            --a3._entries;
            a5 = true;
        }
        if (a5) {
            a3._recman.dA(a3._recid, a3);
        }
        return a6.f;
    }

    public synchronized Object Ix(Object a2) throws IOException {
        BTree a3;
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage a4 = a3.QC();
        if (a4 == null) {
            return null;
        }
        c a5 = new c(null, null);
        if (a4.LW(a3._height, a2).mv(a5)) {
            if (a3._comparator.compare(a2, a5.getKey()) != 0) {
                return null;
            }
            return a5.getValue();
        }
        return null;
    }

    public synchronized c AW(Object a2) throws IOException {
        BTree a3;
        if (a2 == null) {
            return null;
        }
        c a4 = new c(null, null);
        if (a3.sx(a2).mv(a4)) {
            return a4;
        }
        return null;
    }

    public synchronized x FW() throws IOException {
        BTree a2;
        BPage a3 = a2.QC();
        if (a3 == null) {
            return h.f;
        }
        return a3.wX();
    }

    public synchronized x sx(Object a2) throws IOException {
        BTree a3;
        BPage a4 = a3.QC();
        if (a4 == null) {
            return h.f;
        }
        return a4.LW(a3._height, a2);
    }

    public synchronized int size() {
        BTree a2;
        return a2._entries;
    }

    public long Rx() {
        BTree a2;
        return a2._recid;
    }

    private BPage QC() throws IOException {
        BTree a2;
        if (a2._root == 0L) {
            return null;
        }
        BPage a3 = (BPage)a2._recman.IA(a2._root, a2._bpageSerializer);
        ((BPage)a2._recman.IA(a2._root, a2._bpageSerializer))._recid = a2._root;
        a3._btree = a2;
        return a3;
    }

    public void readExternal(ObjectInput a2) throws IOException, ClassNotFoundException {
        a._comparator = (Comparator)a2.readObject();
        a._keySerializer = (Serializer)a2.readObject();
        a._valueSerializer = (Serializer)a2.readObject();
        a._height = a2.readInt();
        a._root = a2.readLong();
        a._pageSize = a2.readInt();
        a._entries = a2.readInt();
    }

    public void writeExternal(ObjectOutput a2) throws IOException {
        BTree a3;
        a2.writeObject(a3._comparator);
        a2.writeObject(a3._keySerializer);
        a2.writeObject(a3._valueSerializer);
        a2.writeInt(a3._height);
        a2.writeLong(a3._root);
        a2.writeInt(a3._pageSize);
        a2.writeInt(a3._entries);
    }
}

