/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal.security;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KindletSecretKey
implements SecretKey {
    private static final String ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;
    private final SecretKey peer;
    private static final long serialVersionUID = 4216134583803468013L;

    public KindletSecretKey() throws GeneralSecurityException {
        KindletSecretKey a2;
        KeyGenerator a3 = KeyGenerator.getInstance(ALGORITHM);
        a3.init(128);
        a2.peer = a3.generateKey();
    }

    public String getAlgorithm() {
        KindletSecretKey a2;
        return a2.peer.getAlgorithm();
    }

    public byte[] getEncoded() {
        KindletSecretKey a2;
        return a2.peer.getEncoded();
    }

    public synchronized byte[] SsA(byte[] a2) throws GeneralSecurityException {
        KindletSecretKey a3;
        if (a2 == null) {
            throw new IllegalArgumentException("Must not pass null value to encrypt");
        }
        return a3.cTA(a2, 1);
    }

    private byte[] cTA(byte[] a2, int a3) throws GeneralSecurityException {
        KindletSecretKey a4;
        SecretKeySpec a5 = new SecretKeySpec(a4.peer.getEncoded(), ALGORITHM);
        Cipher a6 = Cipher.getInstance(ALGORITHM);
        a6.init(a3, a5);
        return a6.doFinal(a2);
    }

    public synchronized byte[] hSA(byte[] a2) throws GeneralSecurityException {
        KindletSecretKey a3;
        if (a2 == null) {
            throw new IllegalArgumentException("Must not pass null value to encrypt");
        }
        return a3.cTA(a2, 2);
    }

    public String getFormat() {
        KindletSecretKey a2;
        return a2.peer.getFormat();
    }
}

