/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.OptionHandler;

public class PropertySetter {
    private static final Class[] METHOD_REFLECTION_PARAMETER_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PropertySetter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PropertySetter.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertySetter.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    protected Object obj;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$log4j$Priority;

    public PropertySetter(Object obj) {
        this.obj = obj;
    }

    public static void setProperties(Object obj, Properties properties, String prefix) {
        new PropertySetter(obj).setProperties(properties, prefix);
    }

    public void setProperties(Properties properties, String prefix) {
        int len = prefix.length();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || key.indexOf(46, len + 1) > 0) continue;
            String value = OptionConverter.findAndSubst(key, properties);
            if ("layout".equals(key = key.substring(len)) && this.obj instanceof Appender) continue;
            this.setProperty(key, value);
        }
        this.activate();
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        Method setter = this.getSetter(name, value);
        if (setter != null) {
            Class<?>[] paramTypes = setter.getParameterTypes();
            Object arg = this.convertArg(value, paramTypes[0]);
            try {
                setter.invoke(this.obj, arg);
            }
            catch (Exception e) {
                LogLog.error("Error while invoking setter for " + name, e);
            }
        }
    }

    protected Method getSetter(String fieldName, String value) {
        String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method setter = null;
        Class[] paramTypes = new Class[1];
        for (int i = 0; setter == null && i < METHOD_REFLECTION_PARAMETER_TYPES.length; ++i) {
            paramTypes[0] = METHOD_REFLECTION_PARAMETER_TYPES[i];
            try {
                setter = this.obj.getClass().getMethod(methodName, paramTypes);
                continue;
            }
            catch (Exception e) {
                LogLog.error("Error while retrieving setter for " + fieldName + " as a " + paramTypes[0].toString(), e);
            }
        }
        return setter;
    }

    protected Object convertArg(String val, Class type) {
        if (val == null) {
            return null;
        }
        String v = val.trim();
        if ((class$java$lang$String == null ? (class$java$lang$String = PropertySetter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new Long(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        } else if ((class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = PropertySetter.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority).isAssignableFrom(type)) {
            return OptionConverter.toLevel(v, Level.DEBUG);
        }
        return null;
    }

    public void activate() {
        if (this.obj instanceof OptionHandler) {
            ((OptionHandler)this.obj).activateOptions();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

