/*
 * Decompiled with CFR 0.152.
 */
package org.mbertoli.jfep;

import org.mbertoli.jfep.EvaluationException;
import org.mbertoli.jfep.ExpressionNode;

public class VariableNode
implements ExpressionNode {
    protected double value;
    protected boolean error;
    protected String name;
    protected ExpressionNode[] children = new ExpressionNode[0];

    public VariableNode(String name, boolean error) {
        this.name = name;
        this.value = 0.0;
        this.error = error;
    }

    public int count() {
        return 1;
    }

    public int getDepth() {
        return 1;
    }

    public String getSubtype() {
        return this.name;
    }

    public int getType() {
        return 1;
    }

    public double getValue() {
        if (!this.error) {
            return this.value;
        }
        throw new EvaluationException("Variable '" + this.name + "' was not initialized.");
    }

    public void setVariable(String name, double value) {
        if (this.name.equals(name)) {
            this.value = value;
            this.error = false;
        }
    }

    public ExpressionNode[] getChildrenNodes() {
        return this.children;
    }

    public Object clone() {
        VariableNode node = new VariableNode(this.name, this.error);
        node.value = this.value;
        return node;
    }

    public String toString() {
        return this.getSubtype();
    }
}

