/*
 * Decompiled with CFR 0.152.
 */
package org.mbertoli.jfep;

import java.util.HashSet;
import org.mbertoli.jfep.ConstantNode;
import org.mbertoli.jfep.EvaluationException;
import org.mbertoli.jfep.ExpressionNode;
import org.mbertoli.jfep.FunctionNode;
import org.mbertoli.jfep.OperatorNode;
import org.mbertoli.jfep.ParseError;
import org.mbertoli.jfep.VariableNode;

public class Parser {
    private static final char TERM = '@';
    private static final char NUM = 'n';
    private static final char FUNC = 'f';
    private static final char VAR = 'x';
    private static final char OP_BRACKET = '(';
    private static final char CL_BRACKET = ')';
    private char[] input;
    private boolean error;
    private int inp_cur;
    private Element cc;
    private ExpressionNode root;
    private HashSet functions;
    private HashSet variables;

    public Parser(String str) {
        this(str, false);
    }

    public Parser(String str, boolean error) {
        this.input = this.convertInput(str);
        this.root = null;
        this.inp_cur = 0;
        this.error = error;
        this.functions = new HashSet();
        this.variables = new HashSet();
    }

    protected char[] convertInput(String str) {
        char[] input = str.toCharArray();
        char[] output = new char[input.length + 1];
        int pos = 0;
        int i = 0;
        while (i < input.length) {
            char c = input[i];
            if (this.isNumber(c) || this.isOperator(c) || this.isText(c) || this.isBracket(c)) {
                output[pos++] = c;
            }
            ++i;
        }
        output[pos++] = 64;
        return output;
    }

    public ExpressionNode getTree() throws ParseError {
        if (this.root == null) {
            this.cc = this.parse();
            this.root = this.S();
            if (!this.isEndOfExpression(this.cc.getToken())) {
                throw new ParseError("Expecting operator or end of input", this.inp_cur);
            }
            return this.root;
        }
        return this.root;
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private boolean isOperator(char c) {
        int i = 0;
        while (i < OperatorNode.OPERATIONS.length) {
            if (c == OperatorNode.OPERATIONS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isText(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private boolean isBracket(char c) {
        return c == '(' || c == ')';
    }

    private boolean isEndOfExpression(char c) {
        return c == '@';
    }

    private Element parse() {
        if (this.detectImplicitMult()) {
            return new Element('*');
        }
        if (this.isOperator(this.input[this.inp_cur]) || this.isBracket(this.input[this.inp_cur]) || this.isEndOfExpression(this.input[this.inp_cur])) {
            return new Element(this.input[this.inp_cur++]);
        }
        if (this.isNumber(this.input[this.inp_cur])) {
            double d;
            int tmp = this.inp_cur++;
            while (this.isNumber(this.input[this.inp_cur])) {
                ++this.inp_cur;
            }
            if (Character.toLowerCase(this.input[this.inp_cur]) == 'e') {
                if (this.input[this.inp_cur + 1] == '-' || this.isNumber(this.input[this.inp_cur + 1])) {
                    this.inp_cur += 2;
                }
                while (this.isNumber(this.input[this.inp_cur])) {
                    ++this.inp_cur;
                }
            }
            String s = new String(this.input, tmp, this.inp_cur - tmp);
            try {
                d = Double.valueOf(s);
            }
            catch (NumberFormatException ex) {
                throw new ParseError("Invalid number: " + s, this.inp_cur);
            }
            return new Element('n', d);
        }
        if (this.isText(this.input[this.inp_cur])) {
            int tmp = this.inp_cur++;
            while (this.isText(this.input[this.inp_cur]) || this.isNumber(this.input[this.inp_cur])) {
                ++this.inp_cur;
            }
            String s = new String(this.input, tmp, this.inp_cur - tmp);
            String lower = s.toLowerCase();
            int i = 0;
            while (i < FunctionNode.FUNCTIONS.length) {
                if (lower.equals(FunctionNode.FUNCTIONS[i])) {
                    this.functions.add(FunctionNode.FUNCTIONS[i]);
                    return new Element('f', i);
                }
                ++i;
            }
            i = 0;
            while (i < ConstantNode.CONSTANTS.length) {
                if (lower.equals(ConstantNode.CONSTANTS[i])) {
                    return new Element('n', i);
                }
                ++i;
            }
            this.variables.add(s);
            return new Element('x', s);
        }
        throw new ParseError("Unrecognized identifier", this.inp_cur);
    }

    private boolean detectImplicitMult() {
        if (this.cc != null && this.cc.getToken() == 'n') {
            this.cc = null;
            int old_input = this.inp_cur;
            Element next = this.parse();
            this.inp_cur = old_input;
            if (next.getToken() == 'x' || next.getToken() == 'f') {
                return true;
            }
        }
        return false;
    }

    private ExpressionNode S() {
        ExpressionNode current = this.E();
        while (this.cc.getToken() == '+' || this.cc.getToken() == '-') {
            char operator = this.cc.getToken();
            this.cc = this.parse();
            current = new OperatorNode(current, this.E(), operator);
        }
        return current;
    }

    private ExpressionNode E() {
        ExpressionNode current = this.G();
        while (this.cc.getToken() == '*') {
            this.cc = this.parse();
            current = new OperatorNode(current, this.G(), '*');
        }
        return current;
    }

    private ExpressionNode G() {
        ExpressionNode current = this.H();
        while (this.cc.getToken() == '/') {
            this.cc = this.parse();
            current = new OperatorNode(current, this.H(), '/');
        }
        return current;
    }

    private ExpressionNode H() {
        ExpressionNode current = this.T();
        while (this.cc.getToken() == '%') {
            this.cc = this.parse();
            current = new OperatorNode(current, this.T(), '%');
        }
        return current;
    }

    private ExpressionNode T() {
        if (this.cc.getToken() == '-') {
            this.cc = this.parse();
            return new FunctionNode(this.F(), "-");
        }
        return this.F();
    }

    private ExpressionNode F() {
        ExpressionNode left = this.U();
        if (this.cc.getToken() == '^') {
            this.cc = this.parse();
            return new OperatorNode(left, this.F(), '^');
        }
        return left;
    }

    private ExpressionNode U() {
        switch (this.cc.getToken()) {
            case 'n': {
                double n = this.cc.number;
                int constPosition = this.cc.position;
                this.cc = this.parse();
                if (constPosition >= 0) {
                    return new ConstantNode(constPosition);
                }
                return new ConstantNode(n);
            }
            case 'x': {
                String name = this.cc.name;
                this.cc = this.parse();
                return new VariableNode(name, this.error);
            }
            case '(': {
                this.cc = this.parse();
                ExpressionNode tmp = this.S();
                if (this.cc.getToken() == ')') {
                    this.cc = this.parse();
                    return tmp;
                }
                throw new ParseError("Semantic Error, expected ')'", this.inp_cur);
            }
            case 'f': {
                int function = this.cc.position;
                this.cc = this.parse();
                if (this.cc.getToken() != '(') {
                    throw new ParseError("Semantic Error, expected '('", this.inp_cur);
                }
                this.cc = this.parse();
                ExpressionNode tmp2 = this.S();
                if (this.cc.getToken() != ')') {
                    throw new ParseError("Semantic Error, expected ')'", this.inp_cur);
                }
                this.cc = this.parse();
                return new FunctionNode(tmp2, function);
            }
        }
        throw new ParseError("Semantic Error, expected function or variable or constant or '('", this.inp_cur);
    }

    public void setVariable(String name, double value) throws ParseError {
        this.getTree();
        this.root.setVariable(name, value);
    }

    public double getValue() throws ParseError, EvaluationException {
        this.getTree();
        return this.root.getValue();
    }

    public String getExpression() throws ParseError {
        this.getTree();
        return this.root.toString();
    }

    public HashSet getParsedFunctions() throws ParseError {
        this.getTree();
        return this.functions;
    }

    public HashSet getParsedVariables() throws ParseError {
        this.getTree();
        return this.variables;
    }

    public String getInputString() {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < this.input.length && this.input[i] != '@') {
            output.append(this.input[i]);
            ++i;
        }
        return output.toString();
    }

    private class Element {
        private char token;
        public double number = Double.NaN;
        public int position = -1;
        public String name = null;

        public Element(char token) {
            this.token = token;
        }

        public Element(char token, double number) {
            this.token = token;
            this.number = number;
        }

        public Element(char token, String name) {
            this.token = token;
            this.name = name;
        }

        public Element(char token, int position) {
            this.token = token;
            this.position = position;
        }

        public char getToken() {
            return this.token;
        }
    }
}

