/*
 * Decompiled with CFR 0.152.
 */
package org.mbertoli.jfep;

import org.mbertoli.jfep.ExpressionNode;

public class ConstantNode
implements ExpressionNode {
    public static final String[] CONSTANTS = new String[]{"pi", "e"};
    public static final double[] VALUES = new double[]{Math.PI, Math.E};
    protected double constant;
    protected String name;
    protected ExpressionNode[] children = new ExpressionNode[0];

    public ConstantNode(double constant) {
        this.constant = constant;
        this.name = null;
    }

    public ConstantNode(String name) {
        this.name = name;
        int i = 0;
        while (i < CONSTANTS.length) {
            if (CONSTANTS[i].equals(name)) {
                this.constant = VALUES[i];
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unrecognized constant");
    }

    public ConstantNode(int pos) {
        this.name = CONSTANTS[pos];
        this.constant = VALUES[pos];
    }

    public int count() {
        return 1;
    }

    public int getDepth() {
        return 1;
    }

    public String getSubtype() {
        if (Math.floor(this.constant) == this.constant) {
            return Long.toString(Math.round(this.constant));
        }
        return Double.toString(this.constant);
    }

    public int getType() {
        return 0;
    }

    public double getValue() {
        return this.constant;
    }

    public void setVariable(String name, double value) {
    }

    public ExpressionNode[] getChildrenNodes() {
        return this.children;
    }

    public Object clone() {
        return new ConstantNode(this.constant);
    }

    public String toString() {
        if (this.name == null) {
            return this.getSubtype();
        }
        return this.name;
    }
}

