/*
 * Decompiled with CFR 0.152.
 */
package org.mbertoli.demo.jfep;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.mbertoli.demo.jfep.BareBonesBrowserLaunch;
import org.mbertoli.jfep.ExpressionNode;
import org.mbertoli.jfep.ParseError;
import org.mbertoli.jfep.Parser;

public class SimpleParser
extends JFrame {
    private static final int WIDTH = 640;
    private static final int HEIGHT = 480;
    private JTextField input;
    private JTextField output;
    private JButton parse;
    private JLabel error;
    private JEditorPane help;
    private JTable table;
    private Parser parser;
    private ExpressionNode root;
    private HashMap values = new HashMap();
    private Object[] variables;
    static /* synthetic */ Class class$0;

    public SimpleParser() {
        this.initWindow();
        this.initComponents();
        this.addActions();
    }

    private void initWindow() {
        this.setDefaultCloseOperation(3);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screen.width - 640) / 2, (screen.height - 480) / 2, 640, 480);
        this.setTitle("JFEP Demo - Simple Parser");
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel topPanel = new JPanel(new BorderLayout(5, 1));
        mainPanel.add((Component)topPanel, "North");
        this.input = new JTextField();
        this.input.setToolTipText("Enter input function here");
        topPanel.add((Component)this.input, "Center");
        this.parse = new JButton("parse");
        this.parse.setToolTipText("Parses input function");
        topPanel.add((Component)this.parse, "East");
        this.error = new JLabel("Enter input function and press parse button...");
        topPanel.add((Component)this.error, "South");
        JPanel centerPanel = new JPanel(new GridLayout(1, 2, 2, 2));
        centerPanel.setBorder(BorderFactory.createEtchedBorder());
        mainPanel.add((Component)centerPanel, "Center");
        this.table = new JTable(new FunctionTableModel());
        this.table.setSelectionMode(0);
        centerPanel.add(new JScrollPane(this.table));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mbertoli.demo.jfep.SimpleParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL helpUrl = clazz.getResource("Help.html");
        try {
            this.help = new JEditorPane(helpUrl);
            this.help.setContentType("text/html");
        }
        catch (IOException e) {
            this.help = new JEditorPane();
            this.help.setText("Help not available...");
            this.help.setContentType("text/plain");
        }
        this.help.setEditable(false);
        centerPanel.add(new JScrollPane(this.help));
        JPanel outpanel = new JPanel(new BorderLayout(5, 5));
        this.output = new JTextField();
        this.output.setEditable(false);
        this.output.setToolTipText("Output of function evaluation");
        outpanel.add((Component)this.output, "Center");
        JLabel outLabel = new JLabel("Evaluated value:");
        outpanel.add((Component)outLabel, "West");
        mainPanel.add((Component)outpanel, "South");
    }

    private void addActions() {
        this.parse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleParser.this.parse();
            }
        });
        this.help.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BareBonesBrowserLaunch.openURL(e.getURL().toString());
                }
            }
        });
        this.input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SimpleParser.this.parse();
                    e.consume();
                }
            }
        });
    }

    private void parse() {
        try {
            this.parser = new Parser(this.input.getText());
            this.root = this.parser.getTree();
            this.input.setText(this.parser.getExpression());
            this.error.setForeground(this.input.getForeground());
            this.error.setText("Expression parsed correctly");
            this.variables = this.parser.getParsedVariables().toArray();
            Iterator i = this.values.keySet().iterator();
            while (i.hasNext()) {
                Object name = i.next();
                if (!this.parser.getParsedVariables().contains(name)) {
                    i.remove();
                    continue;
                }
                this.root.setVariable((String)name, (Double)this.values.get(name));
            }
        }
        catch (ParseError pe) {
            this.error.setForeground(Color.red);
            this.error.setText(pe.getMessage());
            this.input.setText(this.parser.getInputString());
            this.input.requestFocus();
            this.input.select(pe.getPosition() - 1, pe.getPosition());
            this.parser = null;
            this.variables = null;
            this.root = null;
        }
        this.evaluate();
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
        this.table.repaint();
    }

    private void evaluate() {
        if (this.root != null) {
            this.output.setText(String.valueOf(this.root.getValue()));
        } else {
            this.output.setText("");
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimpleParser application = new SimpleParser();
        application.show();
    }

    protected class FunctionTableModel
    extends AbstractTableModel {
        protected FunctionTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (SimpleParser.this.variables != null) {
                return SimpleParser.this.variables.length;
            }
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return SimpleParser.this.variables[rowIndex];
            }
            if (SimpleParser.this.values.containsKey(SimpleParser.this.variables[rowIndex])) {
                return SimpleParser.this.values.get(SimpleParser.this.variables[rowIndex]);
            }
            return new Double(0.0);
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Variable";
            }
            return "Value";
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                if (aValue instanceof String) {
                    String str = (String)aValue;
                    try {
                        Double d = new Double(str);
                        SimpleParser.this.values.put(this.getValueAt(rowIndex, 0), d);
                        SimpleParser.this.root.setVariable((String)this.getValueAt(rowIndex, 0), d);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (aValue instanceof Double) {
                    SimpleParser.this.values.put(this.getValueAt(rowIndex, 0), aValue);
                    SimpleParser.this.root.setVariable((String)this.getValueAt(rowIndex, 0), (Double)aValue);
                }
                SimpleParser.this.evaluate();
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }
}

