/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.util;

import com.amazon.kindle.kindlet.util.TimerTask;
import com.amazon.kindle.kindlet.util.c;
import com.amazon.kindle.kindlet.util.helper.ThreadGroupHelper;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.security.AccessController;
import java.util.Date;
import sun.awt.AppContext;

public class Timer {
    private final ScheduledThreadPoolExecutor K = new ScheduledThreadPoolExecutor(1);

    public Timer() {
        this.K.setKeepAliveTime(1000L, TimeUnit.MILLISECONDS);
        this.K.allowCoreThreadTimeOut(true);
        this.K.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.K.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        Timer.PQA().addExecutor((ExecutorService)this.K);
    }

    public Timer(boolean isDaemon) {
        this();
    }

    public void schedule(TimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay may not be negative");
        }
        if (delay + System.currentTimeMillis() < 0L) {
            throw new IllegalArgumentException("delay may not cause overflow");
        }
        try {
            task.qqA((ScheduledExecutorService)this.K, delay);
        }
        catch (RejectedExecutionException a2) {
            throw new IllegalStateException("Timer already canceled");
        }
    }

    public void schedule(TimerTask task, Date time) {
        try {
            task.qqA((ScheduledExecutorService)this.K, time.getTime() - System.currentTimeMillis());
        }
        catch (RejectedExecutionException a2) {
            throw new IllegalStateException("Timer already canceled");
        }
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay may not be negative");
        }
        if (delay + System.currentTimeMillis() < 0L) {
            throw new IllegalArgumentException("delay may not cause overflow");
        }
        try {
            task.qpA((ScheduledExecutorService)this.K, delay, period);
        }
        catch (RejectedExecutionException a2) {
            throw new IllegalStateException("Timer already canceled");
        }
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        try {
            task.qpA((ScheduledExecutorService)this.K, firstTime.getTime() - System.currentTimeMillis(), period);
        }
        catch (RejectedExecutionException a2) {
            throw new IllegalStateException("Timer already canceled");
        }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay may not be negative");
        }
        if (delay + System.currentTimeMillis() < 0L) {
            throw new IllegalArgumentException("delay may not cause overflow");
        }
        try {
            task.MqA((ScheduledExecutorService)this.K, delay, period);
        }
        catch (RejectedExecutionException a2) {
            throw new IllegalStateException("Timer already canceled");
        }
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        try {
            task.MqA((ScheduledExecutorService)this.K, firstTime.getTime() - System.currentTimeMillis(), period);
        }
        catch (RejectedExecutionException a2) {
            throw new IllegalStateException("Timer already canceled");
        }
    }

    public void cancel() {
        AccessController.doPrivileged(new c(this));
    }

    private static ThreadGroupHelper PQA() {
        return (ThreadGroupHelper)AppContext.getAppContext().get(ThreadGroupHelper.class);
    }

    static /* synthetic */ ScheduledThreadPoolExecutor vPA(Timer a2) {
        return a2.K;
    }
}

