/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.ebook.framework.gui.foundation.KWindow;
import com.amazon.kindle.kindlet.internal.portability.ui.h;
import com.amazon.kindle.kindlet.internal.portability.ui.u;
import com.amazon.kindle.kindlet.internal.portability.ui.x;
import com.amazon.kindle.kindlet.internal.portability.ui.y;
import com.amazon.kindle.kindlet.ui.KTextComponent;
import com.amazon.kindle.kindlet.ui.KindletFrameworkUtils;
import com.amazon.kindle.kindlet.ui.border.KBorder;
import com.amazon.kindle.kindlet.ui.g;
import com.amazon.kindle.kindlet.ui.s;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.AppContext;

public class KTextField
extends KTextComponent {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY = "";
    private static final char NEWLINE_CHAR = '\n';
    private static final AWTKeyStroke SELECT_PRESSED_KEYSTROKE = AWTKeyStroke.getAWTKeyStroke(61451, 0, false);
    private static final AWTKeyStroke ENTER_TYPED_KEYSTROKE = AWTKeyStroke.getAWTKeyStroke('\n');
    private static final Map m_actionKeyStrokes = Collections.unmodifiableMap(new HashMap(){
        {
            1 a2;
            a2.put(SELECT_PRESSED_KEYSTROKE, Boolean.FALSE);
            a2.put(ENTER_TYPED_KEYSTROKE, Boolean.TRUE);
        }
    });
    final u m_peer;
    protected int m_columns;
    private KWindow m_textFieldKWindow = null;
    private boolean m_okToDrawTextField = false;
    private Dimension m_preferredSizeCache = null;
    private Dimension m_maxSizeCache = null;

    public KTextField() {
        this(DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY, 0);
    }

    public KTextField(String text) {
        this(text, 0);
    }

    public KTextField(String text, String hint) {
        this(text, 0, hint);
    }

    public KTextField(int columns) {
        this(DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY, columns);
    }

    public KTextField(String text, int columns) {
        this(text, columns, DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY);
    }

    public KTextField(String text, int columns, String hint) {
        this(text, columns, hint, false);
    }

    protected KTextField(String text, int columns, String hint, boolean isPassword) {
        this.m_peer = this.LrA(this, isPassword);
        this.m_peer.useMaxAscent(KTextField.getDefaultUseMaxAscent());
        this.m_peer.useMaxDescent(KTextField.getDefaultUseMaxDescent());
        this.setColumns(columns);
        this.m_peer.ue((Object)new s(this));
        Font a2 = this.m_peer.getFont();
        a2 = new Font("SansSerif", a2.getStyle(), a2.getSize());
        this.m_peer.setFont(a2);
        super.setFont(a2);
        this.m_peer.Pe(false);
        this.setFocusable(true);
        this.m_peer.jG(false);
        this.m_peer.setText(text);
        this.setHint(hint);
        this.setFocusTraversalKeysEnabled(false);
        this.enableEvents(12L);
    }

    private synchronized KWindow MF() {
        KTextField a2;
        if (a2.m_textFieldKWindow == null) {
            a2.m_textFieldKWindow = KindletFrameworkUtils.findKWindow(a2.getParent());
            if (a2.m_textFieldKWindow == null) {
                throw new IllegalStateException("No Kwindow parent found for textField");
            }
            a2.m_peer.ze((Container)a2.m_textFieldKWindow);
        }
        return a2.m_textFieldKWindow;
    }

    public int getColumns() {
        return this.m_columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(int columns) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int a2 = this.m_columns;
            if (columns < 0) {
                throw new UnsupportedOperationException("columns out of bounds.");
            }
            if (columns != a2) {
                this.m_columns = columns;
                this.invalidate();
            }
        }
    }

    public String getText() {
        return this.m_peer.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = this.getTreeLock();
        synchronized (object) {
            String a2 = text != null ? text : DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY;
            String a3 = this.m_peer.getText();
            if (!a2.equals(a3)) {
                this.m_peer.setText(a2);
                KindletFrameworkUtils.gsA(this, (y)this.m_peer, a3, this.m_peer.getText());
            }
        }
    }

    public boolean isEditable() {
        return true;
    }

    public void setEditable(boolean b2) {
    }

    public Color getBackground() {
        return this.m_peer.getBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Insets getMargin() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return new Insets(this.m_peer.IE(), this.m_peer.cg(), this.m_peer.re(), this.m_peer.wD());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMargin(Insets insets) {
        Insets a2;
        boolean a3 = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            a2 = this.getMargin();
            if (null == insets) {
                if (a2.left != 0 || a2.right != 0 || a2.top != 0 || a2.bottom != 0) {
                    this.m_peer.GG(0);
                    this.m_peer.Sg(0);
                    this.m_peer.NE(0);
                    this.m_peer.ef(0);
                    a3 = true;
                    this.invalidate();
                }
            } else if (a2.left != insets.left || a2.right != insets.right || a2.top != insets.top || a2.bottom != insets.bottom) {
                this.m_peer.GG(insets.top);
                this.m_peer.Sg(insets.bottom);
                this.m_peer.NE(insets.left);
                this.m_peer.ef(insets.right);
                a3 = true;
                this.invalidate();
            }
        }
        if (a3) {
            this.firePropertyChange("margin", a2, insets);
        }
    }

    public Color getForeground() {
        return this.m_peer.getForegroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setBackground(color);
            this.m_peer.setBackgroundColor(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        if (color == null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setForeground(color);
            this.m_peer.setForegroundColor(color);
        }
    }

    public void setBounds(Rectangle rect) {
        if (rect != null) {
            this.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x2, int y2, int width, int height) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension a2 = this.getMaximumSize();
            int a3 = Math.min(a2.height, height);
            int a4 = Math.min(a2.width, width);
            super.setBounds(x2, y2, a4, a3);
            this.m_peer.setBounds(x2, y2, a4, a3);
        }
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean value) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setVisible(value);
            this.m_peer.VD(value);
        }
    }

    public Font getFont() {
        return this.m_peer.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font f2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (KindletFrameworkUtils.rpA((y)this.m_peer, this, f2)) {
                this.invalidate();
                super.setFont(f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.invalidate();
            this.m_preferredSizeCache = null;
            this.m_maxSizeCache = null;
        }
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return KindletFrameworkUtils.XrA((y)this.m_peer, this, super.getMinimumSize(1, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension a2 = this.m_preferredSizeCache;
        if (a2 != null && this.isValid()) {
            return (Dimension)a2.clone();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets a3;
            g a4 = g.PqA(this);
            int a5 = this.getRowHeight() + 2;
            int a6 = a4.stringWidth(this.m_peer.getText()) + 6;
            if (this.m_columns > 0) {
                a6 = Math.max(a6, this.m_columns * this.getColumnWidth());
            }
            if (null != (a3 = this.getInsets())) {
                int a7 = a3.left + a3.right;
                a6 = Math.max(0, a6 + a7);
                a5 += Math.max(0, a3.top + a3.bottom);
            }
            Dimension a8 = this.getAncestorMaxInteriorSize();
            if (a8.height > 0 && a8.width > 0) {
                a8.setSize(Math.min(a8.width, a6), Math.min(a8.height, a5));
            }
            this.m_preferredSizeCache = a8;
            return (Dimension)this.m_preferredSizeCache.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        Dimension a2 = this.m_maxSizeCache;
        if (a2 != null && this.isValid()) {
            return (Dimension)a2.clone();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension a3 = super.getMaximumSize();
            int a4 = this.getRowHeight() + 2;
            Insets a5 = this.getInsets();
            if (null != a5) {
                a4 += Math.max(0, a5.top + a5.bottom);
            }
            a3.height = Math.min(a3.height, a4);
            this.m_maxSizeCache = a3;
            return (Dimension)this.m_maxSizeCache.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaretPosition(int column) {
        Object object = this.getTreeLock();
        synchronized (object) {
            String a2 = this.getText();
            if (column < 0 || a2 == null || column > a2.length()) {
                throw new IllegalArgumentException("request column is out of bounds.");
            }
            this.m_peer.Rg(column);
            this.invalidate();
        }
    }

    public void setCursor(Cursor cur) {
        throw new UnsupportedOperationException("Deprecated API. Use setCaretPosition(int) instead");
    }

    public int getCaretPosition() {
        return this.m_peer.Ke();
    }

    public Point getCaretLocation() {
        return this.m_peer.kf();
    }

    protected void processKeyEvent(KeyEvent e2) {
        super.processKeyEvent(e2);
        KindletFrameworkUtils.MRA(this, (y)this.m_peer, e2, m_actionKeyStrokes);
    }

    protected void processFocusEvent(FocusEvent e2) {
        KindletFrameworkUtils.gRA(this, (y)this.m_peer, e2);
        super.processFocusEvent(e2);
    }

    public void setHint(String hint) {
        this.m_peer.Jg(hint);
    }

    public boolean hasFocus() {
        return this.m_peer.hasFocus();
    }

    protected void drawBorder(Graphics g2) {
        KBorder a2 = this.getBorder();
        if (a2 != null) {
            a2.paintBorder(this, g2, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paint(Graphics g2) {
        this.paintAll(g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintAll(Graphics g2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.m_peer.Qg();
        }
        this.drawBorder(g2);
        Graphics a2 = this.MF().getGraphics().create();
        this.m_okToDrawTextField = true;
        this.m_peer.fG(this.hasFocus(), false);
        this.m_peer.LF(a2);
    }

    public void addNotify() {
        super.addNotify();
        this.m_peer.Pf();
    }

    public void removeNotify() {
        super.removeNotify();
        this.m_peer.YF();
    }

    public void useMaxAscent(boolean shouldUseMaxAscent) {
        this.m_peer.useMaxAscent(shouldUseMaxAscent);
        super.useMaxAscent(shouldUseMaxAscent);
    }

    public void useMaxDescent(boolean shouldUseMaxDescent) {
        this.m_peer.useMaxDescent(shouldUseMaxDescent);
        super.useMaxDescent(shouldUseMaxDescent);
    }

    private u LrA(KTextField a2, boolean a3) {
        return ((x)AppContext.getAppContext().get(x.class)).Ug((Component)a2, a3, (h)KindletFrameworkUtils.getInstance());
    }

    static /* synthetic */ KWindow HrA(KTextField a2) {
        return a2.MF();
    }

    static /* synthetic */ boolean qQA(KTextField a2) {
        return a2.m_okToDrawTextField;
    }
}

