/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.kindle.kindlet.ui.KComponent;
import com.amazon.kindle.kindlet.ui.border.KBorder;
import com.amazon.kindle.kindlet.ui.border.KLineBorder;
import com.amazon.kindle.kindlet.ui.g;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.EventListener;

public abstract class KTextComponent
extends KComponent {
    public static final int SHOW_ALL_LINES = -1;
    public static final int BOTTOM = 3;
    public static final int TOP = 4;
    public static final int CENTER = 0;
    public static final int TRAILING = 1;
    public static final int LEADING = 2;
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_MARGIN = "margin";
    private ActionListener m_actionListener;
    private TextListener m_textListener;
    private String m_actionCommand = null;
    private Dimension m_cachedMinumumSize = null;
    private Insets m_margins = null;
    private KBorder m_border;
    static final int MINIMUM_ARC_SPACING_X = 20;
    static final int MINIMUM_ARC_SPACING_Y = 0;

    public abstract void setText(String var1);

    public abstract String getText();

    public Insets getMargin() {
        Insets a2 = this.m_margins;
        if (null != a2) {
            return (Insets)this.m_margins.clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMargin(Insets margins) {
        boolean a2 = false;
        Insets a3 = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isChange(this.m_margins, margins)) {
                a3 = this.m_margins;
                this.m_margins = margins;
            }
            a2 = true;
            this.invalidate();
        }
        if (a2) {
            this.firePropertyChange(PROPERTY_MARGIN, a3, margins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Insets getInsets() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets a2 = this.getMargin();
            KBorder a3 = this.getBorder();
            if (null != a3) {
                Insets a4 = a3.getBorderInsets(this);
                a2.bottom += a4.bottom;
                a2.top += a4.top;
                a2.left += a4.left;
                a2.right += a4.right;
            }
            return a2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.invalidate();
            this.m_cachedMinumumSize = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension a2 = this.m_cachedMinumumSize;
        if (a2 != null && this.isValid()) {
            return (Dimension)a2.clone();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension a3 = super.getMinimumSize();
            if (this.m_border != null && this.m_border instanceof KLineBorder) {
                a3.width = Math.max(a3.width, ((KLineBorder)this.m_border).getArcWidth() * 2 + 20);
                a3.height = Math.max(a3.height, ((KLineBorder)this.m_border).getArcHeight() * 2 + 0);
            }
            this.m_cachedMinumumSize = a3;
            return (Dimension)this.m_cachedMinumumSize.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getMinimumSize(int rows, int columns) {
        Dimension a2 = this.m_cachedMinumumSize;
        if (a2 != null && this.isValid()) {
            return (Dimension)a2.clone();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets a3;
            if (rows <= 0) {
                rows = 1;
            }
            if (columns <= 0) {
                columns = 1;
            }
            g a4 = g.PqA(this);
            this.m_cachedMinumumSize = new Dimension(a4.charWidth('m') * columns, a4.getHeight() * rows);
            KBorder a5 = this.getBorder();
            if (null != a5 && null != (a3 = a5.getBorderInsets(this))) {
                this.m_cachedMinumumSize.width += a3.left + a3.right;
                this.m_cachedMinumumSize.height += a3.top + a3.bottom;
            }
            return (Dimension)this.m_cachedMinumumSize.clone();
        }
    }

    public void setActionCommand(String command) {
        this.m_actionCommand = command;
    }

    public String getActionCommand() {
        return this.m_actionCommand != null ? this.m_actionCommand : this.getText();
    }

    public KBorder getBorder() {
        return this.m_border;
    }

    protected void processEvent(AWTEvent e2) {
        if (e2 instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e2);
        } else if (e2 instanceof TextEvent) {
            this.processTextEvent((TextEvent)e2);
        } else {
            super.processEvent(e2);
        }
    }

    protected void processActionEvent(ActionEvent e2) {
        if (this.m_actionListener != null) {
            this.m_actionListener.actionPerformed(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processTextEvent(TextEvent e2) {
        TextListener a2 = this.m_textListener;
        if (a2 == null) return;
        switch (e2.getID()) {
            case 900: {
                a2.textValueChanged(e2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorder(KBorder border) {
        KBorder a2;
        Object object = this.getTreeLock();
        synchronized (object) {
            a2 = this.m_border;
            this.m_border = border;
        }
        if (!(border == a2 || border != null && a2 != null && border.getBorderInsets(this).equals(a2.getBorderInsets(this)))) {
            this.invalidate();
            this.firePropertyChange(PROPERTY_BORDER, a2, border);
        }
    }

    public abstract boolean isEditable();

    public abstract void setEditable(boolean var1);

    public void addTextListener(TextListener l2) {
        if (l2 == null) {
            return;
        }
        this.m_textListener = AWTEventMulticaster.add(this.m_textListener, l2);
        if (this.m_textListener != null) {
            this.enableEvents(1024L);
        }
    }

    public void removeTextListener(TextListener l2) {
        if (l2 == null) {
            return;
        }
        this.m_textListener = AWTEventMulticaster.remove(this.m_textListener, l2);
    }

    public TextListener[] getTextListeners() {
        return (TextListener[])AWTEventMulticaster.getListeners((EventListener)this.m_textListener, (Class)TextListener.class);
    }

    public void addActionListener(ActionListener l2) {
        if (l2 == null) {
            return;
        }
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, l2);
        if (this.m_actionListener != null) {
            this.enableEvents(128L);
        }
    }

    public void removeActionListener(ActionListener l2) {
        if (l2 == null) {
            return;
        }
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, l2);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.m_actionListener, (Class)ActionListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getAncestorMaxInteriorSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension a2 = this.TpA(this.getParent());
            if (null == a2 || a2.height <= 0 || a2.width <= 0) {
                Dimension a3 = Toolkit.getDefaultToolkit().getScreenSize();
                Toolkit.getDefaultToolkit().getScreenSize().width = Math.max(0, a3.width);
                a3.height = Math.max(0, a3.height);
                if (null != a2) {
                    if (a2.height <= 0) {
                        a2.height = a3.height;
                    } else {
                        a2.width = a3.width;
                    }
                } else {
                    a2 = a3;
                }
            }
            return a2;
        }
    }

    protected int getColumnWidth() {
        return g.PqA(this).charWidth('m');
    }

    protected int getRowHeight() {
        g a2 = g.PqA(this);
        int a3 = a2.getHeight();
        if (this.isUsingMaxAscent()) {
            a3 += a2.getMaxAscent() - a2.getAscent();
        }
        if (this.isUsingMaxDescent()) {
            a3 += a2.getMaxDescent() - a2.getDescent();
        }
        return a3;
    }

    private Dimension TpA(Container a2) {
        LayoutManager a3;
        Insets a4;
        KTextComponent a5;
        if (a2 == null) {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        Dimension a6 = a2.getSize();
        if (!(a2.isValid() || a2.getParent() != null && a2.getParent().getLayout() == null)) {
            a6 = a5.TpA(a2.getParent());
        }
        if (null != (a4 = a2.getInsets())) {
            a6.setSize(Math.max(a6.width - (a4.left + a4.right), 0), Math.max(a6.height - (a4.top + a4.bottom), 0));
        }
        if ((a3 = a2.getLayout()) != null) {
            int a7 = 0;
            int a8 = 0;
            if (a3 instanceof FlowLayout) {
                a7 = ((FlowLayout)a3).getVgap();
                a8 = ((FlowLayout)a3).getHgap();
            } else if (a3 instanceof CardLayout) {
                a7 = ((CardLayout)a3).getVgap();
                a8 = ((CardLayout)a3).getHgap();
            } else if (a3 instanceof GridLayout) {
                a7 = ((GridLayout)a3).getVgap();
                a8 = ((GridLayout)a3).getHgap();
            } else if (a3 instanceof BorderLayout) {
                a7 = ((BorderLayout)a3).getVgap();
                a8 = ((BorderLayout)a3).getHgap();
            }
            if (a7 != 0 || a8 != 0) {
                a6.setSize(Math.max(a6.width - a8 * 2, 0), Math.max(a6.height - a7 * 2, 0));
            }
            if (a3 instanceof GridBagLayout) {
                GridBagConstraints a9 = ((GridBagLayout)a3).getConstraints(a5);
                Insets a10 = a9.insets;
                if (null != a10) {
                    a6.setSize(Math.max(a6.width - (a10.left + a10.right), 0), Math.max(a6.height - (a10.top + a10.bottom), 0));
                }
                if (a9.ipadx > 0) {
                    a6.setSize(Math.max(0, a6.width - a9.ipadx), a6.height);
                }
                if (a9.ipady > 0) {
                    a6.setSize(a6.width, Math.max(0, a6.height - a9.ipady));
                }
            }
        }
        return a6;
    }
}

