/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.kindle.kindlet.ui.KPanel;
import com.amazon.kindle.kindlet.ui.pages.LocationIterator;
import com.amazon.kindle.kindlet.ui.pages.PageModel;
import com.amazon.kindle.kindlet.ui.pages.PageProvider;
import com.amazon.kindle.kindlet.ui.q;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.awt.AppContext;

public class KPagedContainer
extends KPanel {
    public static final String PROPERTY_CHANGE_EVENT_PAGE_START_LOCATION = "pageStartLocation";
    public static final String PROPERTY_CHANGE_EVENT_PAGE_END_LOCATION = "pageEndLocation";
    public static final Set DEFAULT_PREVIOUS_PAGE_KEYS = Collections.unmodifiableSet(new HashSet(){
        {
            1 a2;
            a2.add(AWTKeyStroke.getAWTKeyStroke(61450, 0, true));
            a2.add(AWTKeyStroke.getAWTKeyStroke(61452, 0, true));
            a2.add(AWTKeyStroke.getAWTKeyStroke(61450, 0, true));
        }
    });
    public static final Set DEFAULT_NEXT_PAGE_KEYS = Collections.unmodifiableSet(new HashSet(){
        {
            2 a2;
            a2.add(AWTKeyStroke.getAWTKeyStroke(61449, 0, true));
            a2.add(AWTKeyStroke.getAWTKeyStroke(61448, 0, true));
        }
    });
    public static final int PAGE_KEYS_GLOBAL = 1;
    public static final int PAGE_KEYS_LOCAL = 0;
    public static final int PAGE_KEYS_DISABLED = 2;
    private PageModel model;
    private PageProvider pageProvider;
    private String firstPageAlignment = "South";
    private String lastPageAlignment = "North";
    private int startLocation;
    private int nextStartLocation;
    private Integer validatedStartLocation;
    private Integer validatedNextStartLocation;
    protected PropertyChangeSupport propertyChangeSupport;
    private final Set previousPageKeyStrokes;
    private final Set nextPageKeyStrokes;
    private int pageKeyPolicy = 0;
    private static FocusAcceptor FOCUS_ACCEPTOR = new FocusAcceptor();

    public KPagedContainer(PageModel pageModel, PageProvider pageProvider) {
        super.setLayout(new BorderLayout());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.pageProvider = pageProvider;
        this.model = pageModel;
        this.nextStartLocation = this.startLocation = this.model.getInitialLocation();
        this.nextPageKeyStrokes = Collections.synchronizedSet(new HashSet(DEFAULT_NEXT_PAGE_KEYS));
        this.previousPageKeyStrokes = Collections.synchronizedSet(new HashSet(DEFAULT_PREVIOUS_PAGE_KEYS));
        this.CqA();
    }

    protected void addImpl(Component component, Object constraints, int index) {
        throw new UnsupportedOperationException("Items can not be added directly to a KPagedContainer");
    }

    public void remove(int index) {
        throw new UnsupportedOperationException("Items can not be removed directly from a KPagedContainer");
    }

    public void setBounds(int x2, int y2, int width, int height) {
        boolean a2 = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x2, y2, width, height);
        if (a2) {
            this.relayoutPage();
        }
    }

    public void relayoutPage() {
        this.fillPage(true);
    }

    protected void fillPage(boolean forward) {
        Component a2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean a3 = a2 == this || this.isAncestorOf(a2);
        super.removeAll();
        Dimension a4 = this.getSize();
        Insets a5 = this.getInsets();
        a4.width -= a5.left + a5.right;
        a4.height -= a5.top + a5.bottom;
        this.pageProvider.setPageSize(a4);
        if (this.ERA()) {
            this.nextStartLocation = this.startLocation = 0;
        } else {
            LocationIterator a6 = this.model.locationIterator(this.startLocation, forward);
            Component a7 = this.pageProvider.getPage(a6);
            this.startLocation = this.pageProvider.getPageStartLocation();
            this.nextStartLocation = this.pageProvider.getPageEndLocation();
            String a8 = "Center";
            if (this.startLocation <= this.model.getFirstLocation()) {
                a8 = this.firstPageAlignment;
            } else if (this.nextStartLocation > this.model.getLastLocation()) {
                a8 = this.lastPageAlignment;
            }
            if (a7 != null) {
                super.addImpl(a7, a8, -1);
            }
            if (a3) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                this.updateFocus(a7, a2, forward);
            }
        }
        this.firePageModelUpdates();
    }

    protected void firePageModelUpdates() {
        Integer a2;
        Integer a3 = new Integer(this.startLocation);
        if (!a3.equals(this.validatedStartLocation)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_CHANGE_EVENT_PAGE_START_LOCATION, this.validatedStartLocation, a3);
            this.validatedStartLocation = a3;
        }
        if (!(a2 = new Integer(this.nextStartLocation)).equals(this.validatedNextStartLocation)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_CHANGE_EVENT_PAGE_END_LOCATION, this.validatedNextStartLocation, a2);
            this.validatedNextStartLocation = a2;
        }
    }

    private boolean ERA() {
        KPagedContainer a2;
        return a2.model.getLastLocation() < a2.model.getFirstLocation();
    }

    public boolean next() {
        if (this.nextStartLocation <= this.model.getLastLocation()) {
            this.startLocation = this.nextStartLocation;
            this.fillPage(true);
            return true;
        }
        return false;
    }

    public boolean previous() {
        if (this.startLocation > this.model.getFirstLocation()) {
            this.fillPage(false);
            return true;
        }
        return false;
    }

    public void setLocation(int location) {
        this.KQA(location, true);
    }

    public void setEndLocation(int location) {
        this.KQA(location, false);
    }

    private void KQA(int a2, boolean a3) {
        KPagedContainer a4;
        boolean a5 = a3;
        if (a4.ERA()) {
            a2 = 0;
        } else {
            if (a2 < a4.model.getFirstLocation()) {
                a2 = a4.model.getFirstLocation();
            }
            if (a2 > a4.model.getLastLocation()) {
                a2 = a4.model.getLastLocation();
                a5 = false;
            }
        }
        a4.startLocation = a2 + (a5 ? 0 : 1);
        a4.fillPage(a5);
    }

    public void first() {
        this.setLocation(this.model.getFirstLocation());
    }

    public void last() {
        this.setLocation(this.model.getLastLocation());
    }

    public int getPageStartLocation() {
        return this.startLocation;
    }

    public int getPageEndLocation() {
        return this.nextStartLocation;
    }

    public void setFirstPageAlignment(String alignment) {
        this.firstPageAlignment = alignment;
    }

    public void setLastPageAlignment(String alignment) {
        this.lastPageAlignment = alignment;
    }

    public PageModel getPageModel() {
        return this.model;
    }

    public PageProvider getPageProvider() {
        return this.pageProvider;
    }

    public void setPageProvider(PageProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("PageProvider can not be null.");
        }
        this.pageProvider = provider;
        this.relayoutPage();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public Set getPreviousPageKeyStrokes() {
        return Collections.unmodifiableSet(this.previousPageKeyStrokes);
    }

    public Set getNextPageKeyStrokes() {
        return Collections.unmodifiableSet(this.nextPageKeyStrokes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextPageKeyStrokes(Set keyStrokes) {
        this.ZqA(keyStrokes);
        Set set = this.nextPageKeyStrokes;
        synchronized (set) {
            this.nextPageKeyStrokes.clear();
            this.nextPageKeyStrokes.addAll(keyStrokes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousPageKeyStrokes(Set keyStrokes) {
        this.ZqA(keyStrokes);
        Set set = this.previousPageKeyStrokes;
        synchronized (set) {
            this.previousPageKeyStrokes.clear();
            this.previousPageKeyStrokes.addAll(keyStrokes);
        }
    }

    private void ZqA(Set a2) {
        Iterator a3 = a2.iterator();
        while (a3.hasNext()) {
            if (a3.next() instanceof AWTKeyStroke) continue;
            throw new IllegalArgumentException("Set can only contain instances of AWTKeyStroke.");
        }
    }

    protected void updateFocus(Component page, Component originalFocusOwner, boolean forward) {
        if (originalFocusOwner.isShowing()) {
            originalFocusOwner.requestFocus();
            return;
        }
        Component a2 = null;
        if (page instanceof Container) {
            Container a3 = (Container)page;
            if (a3.isFocusCycleRoot()) {
                FocusTraversalPolicy a4 = a3.getFocusTraversalPolicy();
                if (a4 != null) {
                    a2 = forward ? a4.getFirstComponent(a3) : a4.getLastComponent(a3);
                }
            } else {
                a2 = this.HqA(a3, forward);
            }
        }
        if (a2 != null) {
            a2.requestFocus();
        } else if (page.isFocusable()) {
            page.requestFocus();
        } else {
            this.requestFocus();
        }
    }

    private Component HqA(Component a2, boolean a3) {
        if (FOCUS_ACCEPTOR.accept(a2) && a2 instanceof Container && ((Container)a2).getComponentCount() > 0) {
            KPagedContainer a4;
            Component[] a5 = ((Container)a2).getComponents();
            if (a3) {
                int a6;
                int n2 = a6 = 0;
                while (n2 < a5.length) {
                    a2 = a4.HqA(a5[a6], a3);
                    if (a2 != null) {
                        return a2;
                    }
                    n2 = ++a6;
                }
            } else {
                int a7;
                int n3 = a7 = a5.length - 1;
                while (n3 >= 0) {
                    a2 = a4.HqA(a5[a7], a3);
                    if (a2 != null) {
                        return a2;
                    }
                    n3 = --a7;
                }
            }
        }
        if (FOCUS_ACCEPTOR.accept(a2)) {
            return a2;
        }
        return null;
    }

    public void setPageKeyPolicy(int policy) {
        if (policy != this.pageKeyPolicy) {
            if (this.pageKeyPolicy == 1) {
                this.TQA().bQA(this);
            }
            this.pageKeyPolicy = policy;
            if (this.pageKeyPolicy == 1) {
                this.TQA().CQA(this);
            }
        }
    }

    public int getPageKeyPolicy() {
        return this.pageKeyPolicy;
    }

    private synchronized void CqA() {
        KPagedContainer a2;
        q a3 = a2.TQA();
        if (a3 == null) {
            a3 = new q(null);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(a3);
            AppContext.getAppContext().put(q.class, a3);
        }
    }

    private synchronized q TQA() {
        return (q)AppContext.getAppContext().get(q.class);
    }

    private static class FocusAcceptor
    extends ContainerOrderFocusTraversalPolicy {
        private FocusAcceptor() {
            FocusAcceptor a2;
        }

        public boolean accept(Component a2) {
            FocusAcceptor a3;
            if (a2 == null) {
                return false;
            }
            return super.accept(a2);
        }
    }
}

