/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.kindle.kindlet.ui.Focus2DTraversable;
import com.amazon.kindle.kindlet.ui.Focus2DTraversalPolicy;
import com.amazon.kindle.kindlet.ui.helper.FontMetricsHelper;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.awt.AppContext;

public class KComponent
extends Container
implements Focus2DTraversable {
    static final int FOCUS_2D_TRAVERSAL_KEY_LENGTH = 2;
    private final Set[] focus2DTraversalKeys = new Set[2];
    private static final String[] focus2DTraversalKeyPropertyNames = new String[]{"aboveFocusTraversalKeys", "belowFocusTraversalKeys"};
    private volatile Point m_entryPoint;
    private volatile Rectangle m_entryBounds;
    private Dimension specifiedMaximumSize;
    private Dimension specifiedMinimumSize;
    private Dimension specifiedPreferredSize;
    private boolean usingMaxAscent = KComponent.getDefaultUseMaxAscent();
    private final Object usingMaxAscentGuard = new Object();
    private static AtomicBoolean useMaxAscentDefault = new AtomicBoolean(false);
    private boolean usingMaxDescent = KComponent.getDefaultUseMaxDescent();
    private final Object usingMaxDescentGuard = new Object();
    private static AtomicBoolean useMaxDescentDefault = new AtomicBoolean(false);

    public KComponent() {
        super.setForeground(Color.BLACK);
        super.setBackground(Color.WHITE);
        this.m_entryPoint = null;
    }

    public void transferFocusAbove() {
        FocusTraversalPolicy a2;
        Container a3 = this.mrA().getFocusCycleRootAncestor();
        if (a3 != null && (a2 = a3.getFocusTraversalPolicy()) instanceof Focus2DTraversalPolicy) {
            Focus2DTraversalPolicy a4 = (Focus2DTraversalPolicy)a2;
            Component a5 = a4.getComponentAbove(a3, this);
            if (a5 == null) {
                a5 = a4.getDefaultComponent(a3);
            }
            if (a5 != null) {
                a5.requestFocus();
            }
        }
    }

    public void transferFocusBelow() {
        FocusTraversalPolicy a2;
        Container a3 = this.mrA().getFocusCycleRootAncestor();
        if (a3 != null && (a2 = a3.getFocusTraversalPolicy()) instanceof Focus2DTraversalPolicy) {
            Focus2DTraversalPolicy a4 = (Focus2DTraversalPolicy)a2;
            Component a5 = a4.getComponentBelow(a3, this);
            if (a5 == null) {
                a5 = a4.getDefaultComponent(a3);
            }
            if (a5 != null) {
                a5.requestFocus();
            }
        }
    }

    public void setEntryPoint(Point inEntryPoint) {
        this.m_entryPoint = inEntryPoint;
        this.m_entryBounds = this.getBounds();
    }

    public Point getEntryPoint() {
        if (null == this.m_entryPoint) {
            return null;
        }
        return (Point)this.m_entryPoint.clone();
    }

    public void setBounds(int x2, int y2, int width, int height) {
        Point a2 = this.getEntryPoint();
        if (a2 != null) {
            int a3 = this.m_entryBounds.x + this.m_entryPoint.x;
            int a4 = this.m_entryBounds.y + this.m_entryPoint.y;
            if (a3 < x2) {
                a3 = x2;
            } else if (a3 >= x2 + width) {
                a3 = x2 + width - 1;
            }
            if (a4 < y2) {
                a4 = y2;
            } else if (a4 > y2 + height) {
                a4 = y2 + height - 1;
            }
            a2.x = a3 - x2;
            a2.y = a4 - y2;
            this.setEntryPoint(a2);
        }
        super.setBounds(x2, y2, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocus2DTraversalKeys(int id, Set keystrokes) {
        KComponent kComponent = this;
        synchronized (kComponent) {
            this.VpA(this.focus2DTraversalKeys, id, keystrokes);
        }
    }

    public Set getFocus2DTraversalKeys(int id) {
        if (id < 0 || id >= 2) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        Set a2 = this.focus2DTraversalKeys[id];
        if (a2 != null) {
            return a2;
        }
        Container a3 = this.getParent();
        if (a3 instanceof Focus2DTraversable) {
            return ((Focus2DTraversable)((Object)a3)).getFocus2DTraversalKeys(id);
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areFocus2DTraversalKeysSet(int id) {
        if (id < 0 || id >= 2) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        KComponent kComponent = this;
        synchronized (kComponent) {
            return this.focus2DTraversalKeys[id] != null;
        }
    }

    private void VpA(Set[] a2, int a3, Set a4) {
        KComponent a5;
        Iterator a6;
        if (a3 < 0 || a3 >= 2) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        if (a4 == null) {
            a2[a3] = null;
            return;
        }
        Set a7 = null;
        Iterator iterator = a6 = a4.iterator();
        while (iterator.hasNext()) {
            int a8;
            Object a9 = a6.next();
            if (!(a9 instanceof AWTKeyStroke)) {
                throw new IllegalArgumentException("focus traversal keys must be non-null AWTKeyStrokes");
            }
            AWTKeyStroke a10 = (AWTKeyStroke)a9;
            if (a10.getKeyEventType() == 400) {
                throw new IllegalArgumentException("KEY_TYPED events are not permitted for focus traversal");
            }
            int n2 = a8 = a3 == 0 ? 1 : 0;
            if (a2[a8] != null && a2[a8].contains(a10)) {
                throw new IllegalArgumentException("focus traversal keys must be unique for a Component");
            }
            a7 = a2[a3];
            a2[a3] = Collections.unmodifiableSet(new HashSet(a4));
            iterator = a6;
        }
        a5.firePropertyChange(focus2DTraversalKeyPropertyNames[a3], a7, a4);
    }

    private Component mrA() {
        KComponent a2;
        Container a3 = a2.getFocusCycleRootAncestor();
        Container a4 = a2;
        Container container = a3;
        while (!(container == null || a3.isShowing() && a3.isFocusable() && a3.isEnabled())) {
            a4 = a3;
            container = a3.getFocusCycleRootAncestor();
        }
        return a4;
    }

    protected boolean isChange(Object currentObject, Object newObject) {
        return (currentObject == null || newObject == null) && newObject != currentObject || currentObject != null && newObject != null && !currentObject.equals(newObject);
    }

    public boolean imageUpdate(Image image, int flags, int x2, int y2, int w2, int h2) {
        if ((flags & 0x30) != 0) {
            this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
        }
        return (flags & 0xA0) == 0;
    }

    public void setMaximumSize(Dimension maximumSize) {
        Dimension a2 = this.specifiedMaximumSize;
        this.specifiedMaximumSize = maximumSize == null ? null : new Dimension(maximumSize);
        this.firePropertyChange("maximumSize", a2, maximumSize);
    }

    public Dimension getMaximumSize() {
        if (this.specifiedMaximumSize != null) {
            return new Dimension(this.specifiedMaximumSize);
        }
        return super.getMaximumSize();
    }

    public boolean isMaximumSizeSet() {
        return this.specifiedMaximumSize != null;
    }

    public void setMinimumSize(Dimension minimumSize) {
        Dimension a2 = this.specifiedMinimumSize;
        this.specifiedMinimumSize = minimumSize == null ? null : new Dimension(minimumSize);
        this.firePropertyChange("minimumSize", a2, minimumSize);
    }

    public Dimension getMinimumSize() {
        if (this.specifiedMinimumSize != null) {
            return new Dimension(this.specifiedMinimumSize);
        }
        return super.getMinimumSize();
    }

    public boolean isMinimumSizeSet() {
        return this.specifiedMinimumSize != null;
    }

    public void setPreferredSize(Dimension preferredSize) {
        Dimension a2 = this.specifiedPreferredSize;
        this.specifiedPreferredSize = preferredSize == null ? null : new Dimension(preferredSize);
        this.firePropertyChange("preferredSize", a2, preferredSize);
    }

    public Dimension getPreferredSize() {
        if (this.specifiedPreferredSize != null) {
            return new Dimension(this.specifiedPreferredSize);
        }
        return super.getPreferredSize();
    }

    public boolean isPreferredSizeSet() {
        return this.specifiedPreferredSize != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useMaxAscent(boolean shouldUseMaxAscent) {
        Object object = this.usingMaxAscentGuard;
        synchronized (object) {
            if (shouldUseMaxAscent != this.usingMaxAscent) {
                this.usingMaxAscent = shouldUseMaxAscent;
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUsingMaxAscent() {
        Object object = this.usingMaxAscentGuard;
        synchronized (object) {
            return this.usingMaxAscent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useMaxDescent(boolean shouldUseMaxDescent) {
        Object object = this.usingMaxDescentGuard;
        synchronized (object) {
            if (shouldUseMaxDescent != this.usingMaxDescent) {
                this.usingMaxDescent = shouldUseMaxDescent;
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUsingMaxDescent() {
        Object object = this.usingMaxDescentGuard;
        synchronized (object) {
            return this.usingMaxDescent;
        }
    }

    public static void setDefaultUseMaxAscent(boolean useMaxAscentDefault) {
        KComponent.useMaxAscentDefault.set(useMaxAscentDefault);
    }

    public static boolean getDefaultUseMaxAscent() {
        return useMaxAscentDefault.get();
    }

    public static void setDefaultUseMaxDescent(boolean useMaxDescentDefault) {
        KComponent.useMaxDescentDefault.set(useMaxDescentDefault);
    }

    public static boolean getDefaultUseMaxDescent() {
        return useMaxDescentDefault.get();
    }

    public FontMetrics getFontMetrics(Font font) {
        FontMetricsHelper a2 = (FontMetricsHelper)AppContext.getAppContext().get(FontMetricsHelper.class);
        if (a2 != null) {
            return a2.getFontMetrics(font, super.getFontMetrics(font));
        }
        return super.getFontMetrics(font);
    }
}

