/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.framework.ad.odot;

import com.amazon.ebook.framework.ad.odot.InvalidMessageException;
import com.amazon.ebook.framework.ad.odot.h;
import com.amazon.ebook.util.log.c;
import com.amazon.ebook.util.log.u;
import com.amazon.ebook.util.log.y;
import com.amazon.ebook.util.text.hb;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import junit.framework.TestCase;

public class OdotLiteTest
extends TestCase {
    private static final String PREFERRED_ENCODING = "UTF-8";
    private StringWriter mTestOutput;

    public OdotLiteTest() {
        OdotLiteTest a2;
    }

    protected void setUp() throws Exception {
        OdotLiteTest a2;
        super.setUp();
        a2.mTestOutput = new StringWriter();
        u.pHb((y)new y((com.amazon.ebook.util.log.h)new c(), (Writer)new StringWriter()));
        y a3 = new y((com.amazon.ebook.util.log.h)new c(), (Writer)a2.mTestOutput);
        h.pHb(a3);
    }

    protected void tearDown() throws Exception {
        OdotLiteTest a2;
        a2.mTestOutput = null;
        super.tearDown();
    }

    public void testEnqueueValidMessage() throws UnsupportedEncodingException {
        OdotLiteTest a2;
        String a3 = "Here's my test payload";
        String a4 = "ODOT.my.test.topic.123";
        try {
            h.AOB(a4, a3.getBytes(PREFERRED_ENCODING), null);
        }
        catch (Exception a5) {
            a5.printStackTrace();
            OdotLiteTest.fail((String)("Odot enqueue failed for valid odot msg " + a5.getMessage()));
        }
        String a6 = ":";
        String a7 = a2.getFieldFromOutput(3, a6);
        String a8 = a2.getFieldFromOutput(2, a6);
        String a9 = a2.getFieldFromOutput(1, a6);
        OdotLiteTest.assertEquals((String)"Topic input does not match topic output", (String)a9, (String)a4);
        byte[] a10 = hb.GaA((String)a7);
        String a11 = new String(a10, PREFERRED_ENCODING);
        OdotLiteTest.assertEquals((String)a3, (String)a11);
        OdotLiteTest.assertNotNull((String)"CRC not found in output", (Object)a8);
        long a12 = a2.computeCrc(a4, a3.getBytes(PREFERRED_ENCODING));
        long a13 = a2.getCrcVal(a8, '=', ',', "crc");
        OdotLiteTest.assertEquals((String)"Computed CRC doesn't match input CRC", (long)a12, (long)a13);
    }

    public void testEnqueueValidMessageNonAsciiPayload() throws UnsupportedEncodingException {
        OdotLiteTest a2;
        String a3 = "\u00e0\u00e1";
        String a4 = "ODOT.my.test.topic.124";
        try {
            h.AOB(a4, a3.getBytes(PREFERRED_ENCODING), null);
        }
        catch (Exception a5) {
            a5.printStackTrace();
            OdotLiteTest.fail((String)("Odot enqueue failed for valid odot msg " + a5.getMessage()));
        }
        String a6 = ":";
        String a7 = a2.getFieldFromOutput(3, a6);
        String a8 = a2.getFieldFromOutput(2, a6);
        String a9 = a2.getFieldFromOutput(1, a6);
        OdotLiteTest.assertEquals((String)"Topic input does not match topic output", (String)a9, (String)a4);
        byte[] a10 = hb.GaA((String)a7);
        String a11 = new String(a10, PREFERRED_ENCODING);
        OdotLiteTest.assertEquals((String)a3, (String)a11);
        OdotLiteTest.assertNotNull((String)"CRC not found in output", (Object)a8);
        long a12 = a2.computeCrc(a4, a3.getBytes(PREFERRED_ENCODING));
        long a13 = a2.getCrcVal(a8, '=', ',', "crc");
        OdotLiteTest.assertEquals((String)"Computed CRC doesn't match input CRC", (long)a12, (long)a13);
    }

    public void testEnqueueInvalidNullTopic() {
        String a2 = "Here's my test payload";
        try {
            h.AOB(null, a2.getBytes(PREFERRED_ENCODING), null);
            OdotLiteTest.fail((String)"Odot enqueue with null topic should have caused exception");
        }
        catch (InvalidMessageException a3) {
        }
        catch (UnsupportedEncodingException a4) {
            OdotLiteTest.fail((String)("Odot failed for unsupported encoding " + a4.getMessage()));
        }
    }

    public void testEnqueueInvalidEmptyTopic() {
        String a2 = "Here's my test payload";
        try {
            h.AOB("", a2.getBytes(PREFERRED_ENCODING), null);
            OdotLiteTest.fail((String)"Odot enqueue with empty topic should have caused exception");
        }
        catch (InvalidMessageException a3) {
        }
        catch (UnsupportedEncodingException a4) {
            OdotLiteTest.fail((String)("Odot failed for unsupported encoding " + a4.getMessage()));
        }
    }

    public void testEnqueueInvalidWhitespaceTopic() {
        String a2 = "Here's my test payload";
        try {
            h.AOB("My. ODOT Test", a2.getBytes(PREFERRED_ENCODING), null);
            OdotLiteTest.fail((String)"Odot enqueue with invalid space char topic should have caused exception");
        }
        catch (InvalidMessageException a3) {
        }
        catch (UnsupportedEncodingException a4) {
            OdotLiteTest.fail((String)("Odot failed for unsupported encoding " + a4.getMessage()));
        }
    }

    public void testEnqueueInvalidNonAlphaNumericTopic() {
        String a2 = "Here's my test payload";
        try {
            h.AOB("()*&#####boink!", a2.getBytes(PREFERRED_ENCODING), null);
            OdotLiteTest.fail((String)"Odot enqueue with invalid char topic should have caused exception");
        }
        catch (InvalidMessageException a3) {
        }
        catch (UnsupportedEncodingException a4) {
            OdotLiteTest.fail((String)("Odot failed for unsupported encoding " + a4.getMessage()));
        }
    }

    public void testEnqueueInvalidRepeatingPeriodsTopic() {
        String a2 = "Here's my test payload";
        try {
            h.AOB("My..ODOT.test", a2.getBytes(PREFERRED_ENCODING), null);
            OdotLiteTest.fail((String)"Odot enqueue with repeating period topic should have caused exception");
        }
        catch (InvalidMessageException a3) {
        }
        catch (UnsupportedEncodingException a4) {
            OdotLiteTest.fail((String)("Odot failed for unsupported encoding " + a4.getMessage()));
        }
    }

    public void testEnqueueInvalidNonAsciiTopic() {
        String a2 = "Here's my test payload";
        try {
            h.AOB("\u00e0\u00e1", a2.getBytes(PREFERRED_ENCODING), null);
            OdotLiteTest.fail((String)"Odot enqueue with non-ascii topic should have caused exception");
        }
        catch (InvalidMessageException a3) {
        }
        catch (UnsupportedEncodingException a4) {
            OdotLiteTest.fail((String)("Odot failed for unsupported encoding " + a4.getMessage()));
        }
    }

    public void testEnqueueInvalidNullPayload() {
        String a2 = "valid.topic";
        try {
            h.AOB(a2, null, null);
            OdotLiteTest.fail((String)"Odot enqueue with null payload should have caused exception");
        }
        catch (InvalidMessageException invalidMessageException) {
            // empty catch block
        }
    }

    public void testEnqueueInvalidEmptyBytePayload() {
        String a2 = "valid.topic";
        try {
            h.AOB(a2, new byte[0], null);
            OdotLiteTest.fail((String)"Odot enqueue with invalid base64 should have caused exception");
        }
        catch (InvalidMessageException invalidMessageException) {
            // empty catch block
        }
    }

    private String getFieldFromOutput(int a2, String a3) {
        OdotLiteTest a4;
        StringTokenizer a5 = new StringTokenizer(a4.mTestOutput.toString(), a3);
        int a6 = 0;
        StringTokenizer stringTokenizer = a5;
        while (stringTokenizer.hasMoreTokens()) {
            String a7 = a5.nextToken();
            if (a2 == a6) {
                return a7;
            }
            ++a6;
            stringTokenizer = a5;
        }
        return null;
    }

    private long getCrcVal(String a2, char a3, char a4, String a5) {
        if (a2 == null) {
            return -1L;
        }
        if (!a2.startsWith(a5)) {
            return -1L;
        }
        int a6 = a2.indexOf(a3);
        if (a6 == -1) {
            return -1L;
        }
        try {
            int a7 = a2.indexOf(a4);
            if (a7 == -1) {
                a7 = a2.length();
            }
            long a8 = Long.parseLong(a2.substring(a6 + 1, a7));
            return a8;
        }
        catch (Exception a9) {
            return -1L;
        }
    }

    private long computeCrc(String a2, byte[] a3) throws UnsupportedEncodingException {
        CRC32 a4 = new CRC32();
        a4.update(a2.getBytes(PREFERRED_ENCODING));
        a4.update(a3);
        return a4.getValue();
    }
}

