/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.mobi8sdk;

import com.amazon.ebook.mobi8sdk.Mobi8SDKException;
import com.amazon.ebook.mobi8sdk.Mobi8SDKWord;
import com.amazon.ebook.mobi8sdk.Word;
import com.amazon.ebook.mobi8sdk.WordIterator;
import java.lang.reflect.Array;

class Mobi8SDKWordIterator
implements WordIterator {
    private long handle;

    public Mobi8SDKWordIterator() {
        this.init();
    }

    public boolean hasNext() throws Mobi8SDKException {
        return this.hasnext();
    }

    public Word next() throws Mobi8SDKException {
        Mobi8SDKWord mobi8SDKWord = new Mobi8SDKWord();
        this.next(mobi8SDKWord);
        return mobi8SDKWord;
    }

    public Word[] next(int n) throws Mobi8SDKException {
        int n2;
        Word[] wordArray = new Mobi8SDKWord[n];
        for (n2 = 0; n2 < n; ++n2) {
            wordArray[n2] = new Mobi8SDKWord();
        }
        n2 = this.nextblock((Mobi8SDKWord[])wordArray, n);
        if (n2 <= 0) {
            return null;
        }
        if (n2 != n) {
            return (Word[])Mobi8SDKWordIterator.resizeArray(wordArray, n2);
        }
        return wordArray;
    }

    public void gotoPosition(long l) throws Mobi8SDKException {
        this.gotoposition(l);
    }

    public void dispose() {
        this.deletenativehandle();
        this.init();
    }

    protected void finalize() {
        this.dispose();
    }

    private void init() {
        this.handle = 0L;
    }

    private static Object resizeArray(Object object, int n) {
        int n2 = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        int n3 = Math.min(n2, n);
        if (n3 > 0) {
            System.arraycopy(object, 0, object2, 0, n3);
        }
        return object2;
    }

    private native void next(Mobi8SDKWord var1);

    private native int nextblock(Mobi8SDKWord[] var1, int var2);

    private native boolean hasnext();

    private native void deletenativehandle();

    private native void gotoposition(long var1);
}

