/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.mobi8sdk;

import com.amazon.ebook.mobi8sdk.Mobi8SDKException;
import com.amazon.ebook.mobi8sdk.Mobi8SDKResource;
import com.amazon.ebook.mobi8sdk.Resource;
import com.amazon.ebook.mobi8sdk.TableOfContentsEntry;

class Mobi8SDKTableOfContentsEntry
implements TableOfContentsEntry {
    public static int TOC_PARENT_NOT_FOUND = 36;
    public static int TOC_FIRST_CHILD_NOT_FOUND = 37;
    public static int TOC_LAST_CHILD_NOT_FOUND = 38;
    public static int TOC_NEXT_ENTRY_NOT_FOUND = 45;
    public static int TOC_PREV_ENTRY_NOT_FOUND = 46;
    private long handle;
    private static final int RESOURCE_LIST_HANDLE_INDEX = 0;
    private static final int RESOURCE_LIST_COUNT_INDEX = 1;

    public Mobi8SDKTableOfContentsEntry() {
        this.init();
    }

    public int getLevel() throws Mobi8SDKException {
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error Mobi8SDKTableOfContentsEntry not initialized");
        }
        return this.getlevel(this.handle);
    }

    public int getLength() throws Mobi8SDKException {
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error Mobi8SDKTableOfContentsEntry not initialized");
        }
        return this.getlength(this.handle);
    }

    public int getPosition() throws Mobi8SDKException {
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error Mobi8SDKTableOfContentsEntry not initialized");
        }
        return this.getposition(this.handle);
    }

    public String getNodeClass() throws Mobi8SDKException {
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error Mobi8SDKTableOfContentsEntry not initialized");
        }
        return this.getnodeclass(this.handle);
    }

    public String getLabel() throws Mobi8SDKException {
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error Mobi8SDKTableOfContentsEntry not initialized");
        }
        return this.getlabel(this.handle);
    }

    public TableOfContentsEntry getFirstChild() throws Mobi8SDKException {
        long l = 0L;
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error TableOfContentsEntry not initialized");
        }
        Mobi8SDKTableOfContentsEntry mobi8SDKTableOfContentsEntry = new Mobi8SDKTableOfContentsEntry();
        l = this.getfirstchild(mobi8SDKTableOfContentsEntry, this.handle);
        if (l == (long)TOC_FIRST_CHILD_NOT_FOUND) {
            return null;
        }
        if (l != 0L) {
            throw new Mobi8SDKException("Error getFirstChild Native call unsuccessful");
        }
        return mobi8SDKTableOfContentsEntry;
    }

    public TableOfContentsEntry getLastChild() throws Mobi8SDKException {
        long l = 0L;
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error TableOfContentsEntry not initialized");
        }
        Mobi8SDKTableOfContentsEntry mobi8SDKTableOfContentsEntry = new Mobi8SDKTableOfContentsEntry();
        l = this.getlastchild(mobi8SDKTableOfContentsEntry, this.handle);
        if (l == (long)TOC_LAST_CHILD_NOT_FOUND) {
            return null;
        }
        if (l != 0L) {
            throw new Mobi8SDKException("Error getLastChild Native call unsuccessful");
        }
        return mobi8SDKTableOfContentsEntry;
    }

    public TableOfContentsEntry[] getChildren() throws Mobi8SDKException {
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error TableOfContentsEntry not initialized");
        }
        TableOfContentsEntry[] tableOfContentsEntryArray = this.getchildren(this.handle);
        return tableOfContentsEntryArray;
    }

    public TableOfContentsEntry getParent() throws Mobi8SDKException {
        long l = 0L;
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error TableOfContentsEntry not initialized");
        }
        Mobi8SDKTableOfContentsEntry mobi8SDKTableOfContentsEntry = new Mobi8SDKTableOfContentsEntry();
        l = this.getparent(mobi8SDKTableOfContentsEntry, this.handle);
        if (l == (long)TOC_PARENT_NOT_FOUND) {
            return null;
        }
        if (l != 0L) {
            throw new Mobi8SDKException("Error getparent Native call unsuccessful");
        }
        return mobi8SDKTableOfContentsEntry;
    }

    public TableOfContentsEntry getNextEntry() throws Mobi8SDKException {
        long l = 0L;
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error TableOfContentsEntry not initialized");
        }
        Mobi8SDKTableOfContentsEntry mobi8SDKTableOfContentsEntry = new Mobi8SDKTableOfContentsEntry();
        l = this.getnextentry(mobi8SDKTableOfContentsEntry, this.handle);
        if (l == (long)TOC_NEXT_ENTRY_NOT_FOUND) {
            return null;
        }
        if (l != 0L) {
            throw new Mobi8SDKException("Error getNextEntry Native call unsuccessful");
        }
        return mobi8SDKTableOfContentsEntry;
    }

    public TableOfContentsEntry getPreviousEntry() throws Mobi8SDKException {
        long l = 0L;
        if (this.handle == 0L) {
            throw new Mobi8SDKException("Error TableOfContentsEntry not initialized");
        }
        Mobi8SDKTableOfContentsEntry mobi8SDKTableOfContentsEntry = new Mobi8SDKTableOfContentsEntry();
        l = this.getpreviousentry(mobi8SDKTableOfContentsEntry, this.handle);
        if (l == (long)TOC_PREV_ENTRY_NOT_FOUND) {
            return null;
        }
        if (l != 0L) {
            throw new Mobi8SDKException("Error getPreviousEntry Native call unsuccessful");
        }
        return mobi8SDKTableOfContentsEntry;
    }

    public Resource[] getImageResourcesByTagName(String string) throws Mobi8SDKException {
        long[] lArray = new long[2];
        this.loadResources(lArray, string);
        long l = lArray[0];
        long l2 = lArray[1];
        Resource[] resourceArray = new Mobi8SDKResource[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            resourceArray[n] = new Mobi8SDKResource();
            ++n;
        }
        this.copyResources((Mobi8SDKResource[])resourceArray, l);
        this.deleteResources(l);
        return resourceArray;
    }

    public String[] getStringsByTagName(String string) throws Mobi8SDKException {
        return this.getstringsbytagname(string);
    }

    public void dispose() {
        this.deletetableofcontentsentry(this.handle);
        this.init();
    }

    protected void finalize() {
        this.dispose();
    }

    private void init() {
        this.handle = 0L;
    }

    private native int getlevel(long var1);

    private native int getlength(long var1);

    private native int getposition(long var1);

    private native String getnodeclass(long var1);

    private native String getlabel(long var1);

    private native long getfirstchild(Mobi8SDKTableOfContentsEntry var1, long var2);

    private native long getlastchild(Mobi8SDKTableOfContentsEntry var1, long var2);

    private native Mobi8SDKTableOfContentsEntry[] getchildren(long var1);

    private native long getparent(Mobi8SDKTableOfContentsEntry var1, long var2);

    private native long getnextentry(Mobi8SDKTableOfContentsEntry var1, long var2);

    private native long getpreviousentry(Mobi8SDKTableOfContentsEntry var1, long var2);

    private native String[] getstringsbytagname(String var1);

    private native void loadResources(long[] var1, String var2);

    private native void copyResources(Mobi8SDKResource[] var1, long var2);

    private native void deleteResources(long var1);

    private native void deletetableofcontentsentry(long var1);
}

