/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.mobi8sdk;

import com.amazon.ebook.mobi8sdk.BookMetadata;
import com.amazon.ebook.mobi8sdk.GuideItem;
import com.amazon.ebook.mobi8sdk.MetadataProvider;
import com.amazon.ebook.mobi8sdk.Mobi8SDKBookMetadata;
import com.amazon.ebook.mobi8sdk.Mobi8SDKException;
import com.amazon.ebook.mobi8sdk.Mobi8SDKGuideItem;
import com.amazon.ebook.mobi8sdk.Mobi8SDKResource;
import com.amazon.ebook.mobi8sdk.Resource;

class Mobi8SDKMetadataProvider
implements MetadataProvider {
    private long handle;
    private String mobifilePath;
    private static final int GUIDEITEM_LIST_HANDLE_INDEX = 0;
    private static final int GUIDEITEM_LIST_COUNT_INDEX = 1;

    public Mobi8SDKMetadataProvider() {
        this.init();
    }

    public BookMetadata getBookMetadata() throws Mobi8SDKException {
        Mobi8SDKBookMetadata mobi8SDKBookMetadata = new Mobi8SDKBookMetadata();
        this.getbookmetadata(mobi8SDKBookMetadata);
        return mobi8SDKBookMetadata;
    }

    public GuideItem[] getGuideItems() throws Mobi8SDKException {
        long[] lArray = new long[2];
        this.loadallguideitem(lArray);
        long l = lArray[0];
        long l2 = lArray[1];
        GuideItem[] guideItemArray = new Mobi8SDKGuideItem[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            guideItemArray[n] = new Mobi8SDKGuideItem();
            ++n;
        }
        this.copyguideitems((Mobi8SDKGuideItem[])guideItemArray, l);
        this.deleteallguideitem(l);
        return guideItemArray;
    }

    public GuideItem getGuideItem(String string) throws Mobi8SDKException {
        Mobi8SDKGuideItem mobi8SDKGuideItem = new Mobi8SDKGuideItem();
        this.getguideitem(mobi8SDKGuideItem, string);
        return mobi8SDKGuideItem;
    }

    public boolean hasBigCoverArt() {
        return this.hasbigcoverart();
    }

    public Resource getBigCoverArt() throws Mobi8SDKException {
        Mobi8SDKResource mobi8SDKResource = new Mobi8SDKResource();
        this.getbigcoverart(mobi8SDKResource);
        return mobi8SDKResource;
    }

    public Resource getCoverArt() throws Mobi8SDKException {
        Mobi8SDKResource mobi8SDKResource = new Mobi8SDKResource();
        this.getcoverart(mobi8SDKResource);
        return mobi8SDKResource;
    }

    public String getExtraHeaderValueAsString(int n) throws Mobi8SDKException {
        return this.getextraheaderasstring(n);
    }

    public int getExtraHeaderValueAsUINT32(int n) throws Mobi8SDKException {
        return this.getextraheaderasuint32(n);
    }

    public Resource getExtraHeaderValueAsResource(int n) throws Mobi8SDKException {
        Mobi8SDKResource mobi8SDKResource = new Mobi8SDKResource();
        this.getextraheaderasresource(mobi8SDKResource, n);
        return mobi8SDKResource;
    }

    public String getMetadataValueAsString(int n) throws Mobi8SDKException {
        return this.getextraheadermetadataasstring(n);
    }

    public int getMetadataValueAsUINT32(int n) throws Mobi8SDKException {
        return this.getextraheadermetadataasuint32(n);
    }

    public Resource getMetadataValueAsResource(int n) throws Mobi8SDKException {
        Mobi8SDKResource mobi8SDKResource = new Mobi8SDKResource();
        this.getextraheadermetadataasresource(mobi8SDKResource, n);
        return mobi8SDKResource;
    }

    public String getMetadataValueAsString(String string) throws Mobi8SDKException {
        return this.getgenericmetadataasstring(string);
    }

    public int getMetadataValueAsUINT32(String string) throws Mobi8SDKException {
        return this.getgenericmetadataasuint32(string);
    }

    public Resource getMetadataValueAsResource(String string) throws Mobi8SDKException {
        Mobi8SDKResource mobi8SDKResource = new Mobi8SDKResource();
        this.getgenericmetadataasresource(mobi8SDKResource, string);
        return mobi8SDKResource;
    }

    public int[] getMetadataUINT32ValueList(String string) throws Mobi8SDKException {
        return this.getgenericmetadataasuint32list(string);
    }

    public String[] getMetadataStringValueList(String string) throws Mobi8SDKException {
        return this.getgenericmetadataasstringlist(string);
    }

    public int[] getMetadataUINT32ValueList(int n) throws Mobi8SDKException {
        return this.getextraheadermetadataasuint32list(n);
    }

    public String[] getMetadataStringValueList(int n) throws Mobi8SDKException {
        return this.getextraheadermetadataasstringlist(n);
    }

    public void dispose() {
        this.deletemetadataprovider();
        this.init();
    }

    protected void finalize() {
        this.dispose();
    }

    private void init() {
        this.handle = 0L;
    }

    private native void loadallguideitem(long[] var1);

    private native void copyguideitems(Mobi8SDKGuideItem[] var1, long var2);

    private native void deleteallguideitem(long var1);

    private native void getguideitem(Mobi8SDKGuideItem var1, String var2);

    private native void getbookmetadata(Mobi8SDKBookMetadata var1);

    private native String getextraheaderasstring(int var1);

    private native int getextraheaderasuint32(int var1);

    private native void getextraheaderasresource(Mobi8SDKResource var1, int var2);

    private native String getextraheadermetadataasstring(int var1);

    private native int getextraheadermetadataasuint32(int var1);

    private native void getextraheadermetadataasresource(Mobi8SDKResource var1, int var2);

    private native String getgenericmetadataasstring(String var1);

    private native int getgenericmetadataasuint32(String var1);

    private native int[] getgenericmetadataasuint32list(String var1);

    private native String[] getgenericmetadataasstringlist(String var1);

    private native int[] getextraheadermetadataasuint32list(int var1);

    private native String[] getextraheadermetadataasstringlist(int var1);

    private native void getgenericmetadataasresource(Mobi8SDKResource var1, String var2);

    private native void deletemetadataprovider();

    private native boolean hasbigcoverart();

    private native void getbigcoverart(Mobi8SDKResource var1);

    private native void getcoverart(Mobi8SDKResource var1);
}

