#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
Firmware_iLiad=`cat /etc/er_version_commercial`
cd $scriptdir
Firmware_Script=`cat Firmware_Script`

cat <<EOF > manifest.new
<?xml version="1.0" encoding="utf-8"?> 
<package> 
  <metadata> 
    <dc-metadata> 
      <Title>Install gmt's 'for editing' ipdf</Title> 
      <Description>Installed on $(date +"%Y-%m-%d at %H:%M:%S") 
1340405</Description> 
      <Date>2007-03-13T09:25:00</Date> 
    </dc-metadata> 
    <y-metadata> 
      <startpage>install_ipdf.sh</startpage> 
      <image>pdf.png</image> 
      <version>000</version> 
    <ItemSize>327680</ItemSize></y-metadata> 
  </metadata> 
</package> 
EOF

if [ "$Firmware_iLiad" = "$Firmware_Script" ]; then
	cp ${scriptdir}/ipdf /usr/bin/ipdf
	mv manifest.new manifest.xml
else
	# wrong firmware version
	# script is deactivated, error message
	cat wrong_fw.xml | sed -e "s/Firmware_Script_xml/$Firmware_Script/" > wrong_fw.xml
	cat wrong_fw.xml | sed -e "s/Firmware_iLiad_xml/$Firmware_iLiad/" > wrong_fw.xml
	#mv manifest.xml install.xml
	#mv wrong_fw.xml manifest.xml
fi
