#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Modified code taken directly from "SBPubX.doc" (installed by the eBook Publisher
# software).  Validates .opf (all errors/warnings) and prints out to stdout.
# Redirect to log file, if warranted.
#

package main;
use Win32::OLE;
use Win32::OLE qw(EVENTS);
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

$usage='validateOPF.pl Project.opf';
die "Usage:  $usage\n" if $#ARGV!=0;

###################################################################
#
# get the interfaces, complain and quit if we cannot
#
$project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface\n";

$builder = Win32::OLE->new("SBPublisher.Builder") or
	die "Unable to get IBuilder interface\n";

# Setup the event handling.
#
Win32::OLE->WithEvents($builder, 'EventHandlers');

###################################################################
#
# Load our project .opf and perform the validation
#
$project->Load($ARGV[0]);
if (Win32::OLE->LastError() != 0) {
	die "Unable to load project.\n";
}

# Load our OEBFF .oeb and perform the validation
#
#$project->LoadFromOEBFF($ARGV[0]);
#if (Win32::OLE->LastError() != 0) {
#	die "Unable to load OEBFF.\n";
#}

###################################################################
#
# Now check OPF for warnings/errors 
#
$builder->ValidateManifest($project);
if (Win32::OLE->LastError() != 0) {
	die "Unable to validate project manifest\n";
} else {
	print "Done!\n";
}

Win32::OLE->Uninitialize();

###################################################################
# Event Handlers
#
package EventHandlers;

sub OnBuildStart()
{
	my ($project, @args) = @_;
#	print "Beginning validation...\n";
}

sub OnSourceStart()
{
	my ($builder, $filename, @args) = @_;
#	print "Parsing $filename...\n";
}

sub OnError()
{
	# Get the arguments
	my ($builder,
		$filename, 
		$msg, 
		$line, 
		$col, 
		$severity, 
		@args) = @_;

	my @severities = ("NOTE", "FATAL ERROR", "ERROR", "WARNING");

	if ($filename =~ m/^.+[\\|\/](.+?)$/) { $filename = $1; }

	# Print out the error message including any NOTE feedback.
	# To ignore Warnings, change below to: if ($severity < 3)
	if ($severity >= 0)
	{
		printf(" %-15s (L:%6d, C:%6d) %-7s:",
			$filename,
			$line,
			$col,
			$severities[$severity]);

		print " $msg\n";
	}
}