#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Modified code taken directly from "SBPubX.doc" (installed by the eBook Publisher
# software).  Display some information about .imp file and prints out to stdout in
# 'tabbed text' format.  Should redirect to a file so can open output in Microsoft
# Excel or similar to explore further.
#

$usage='infoIMPtab.pl impfilename';
die "Usage:  $usage\n" if $#ARGV != 0;

use Win32::OLE;
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

###################################################################
#
# get the interface, complain and quit if we cannot
#
$impfile = Win32::OLE->new("SBPublisher.ImpFile") or
	die "Unable to get IImpFile interface\n";

###################################################################
#
# Load the IMP File
#
$impfile->Initialize($ARGV[0]);
if (Win32::OLE->LastError() != 0) {
	print "Unable to load IMP.\n";
	exit(0);
}

###################################################################
#
# Get the desired information from the IMP
#
#printf("%s\n", "Filename\tTitle\tAuthor\tAdditionalBookInfo\tBookID\tBookVersion\tCategory\tCompressionType\tDeviceDepth\tDeviceHeight\tDeviceWidth\tDeviceModel\tEncryptionType");
printf("%s",         $ARGV[0]);
printf("%s%s", "\t", $impfile->{Title});
printf("%s%s", "\t", $impfile->{Author});
printf("%s%s", "\t", $impfile->{AdditionalBookInfo});
printf("%s%s", "\t", $impfile->{BookID});
printf("%s%d", "\t", $impfile->{BookVersion});
printf("%s%s", "\t", $impfile->{Category});
printf("%s%d", "\t", $impfile->{CompressionType});
printf("%s%d", "\t", $impfile->{DeviceDepth});
printf("%s%d", "\t", $impfile->{DeviceHeight});
printf("%s%d", "\t", $impfile->{DeviceWidth});
printf("%s%d", "\t", $impfile->{DeviceModel});
printf("%s%d", "\t", $impfile->{EncryptionType});
printf("\n");

Win32::OLE->Uninitialize();
