#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Modified code taken directly from "SBPubX.doc" (installed by the eBook Publisher
# software).  Display some information about .imp file and prints out to stdout in
# 'comma separated values' format.  Should redirect to a file so can open output in
# Microsoft Excel or similar to explore further.
#

$usage='infoIMPcsv.pl impfilename';
die "Usage:  $usage\n" if $#ARGV != 0;

use Win32::OLE;
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

###################################################################
#
# get the interface, complain and quit if we cannot
#
$impfile = Win32::OLE->new("SBPublisher.ImpFile") or
	die "Unable to get IImpFile interface\n";

###################################################################
#
# Load the IMP File
#
$impfile->Initialize($ARGV[0]);
if (Win32::OLE->LastError() != 0) {
	print "Unable to load IMP.\n";
	exit(0);
}

###################################################################
#
# Get the desired information from the IMP
#
#printf("%s\n", "Filename,Title,Author,AdditionalBookInfo,BookID,BookVersion,Category,CompressionType,DeviceDepth,DeviceHeight,DeviceWidth,DeviceModel,EncryptionType");
printf("%s%s", "\"",    $ARGV[0]);
printf("%s%s", "\",\"", $impfile->{Title});
printf("%s%s", "\",\"", $impfile->{Author});
printf("%s%s", "\",\"", $impfile->{AdditionalBookInfo});
printf("%s%s", "\",\"", $impfile->{BookID});
printf("%s%d", "\",\"", $impfile->{BookVersion});
printf("%s%s", "\",\"", $impfile->{Category});
printf("%s%d", "\",\"", $impfile->{CompressionType});
printf("%s%d", "\",\"", $impfile->{DeviceDepth});
printf("%s%d", "\",\"", $impfile->{DeviceHeight});
printf("%s%d", "\",\"", $impfile->{DeviceWidth});
printf("%s%d", "\",\"", $impfile->{DeviceModel});
printf("%s%d", "\",\"", $impfile->{EncryptionType});
printf("\"\n");

Win32::OLE->Uninitialize();
