#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Modified code taken directly from "SBPubX.doc" (installed by the eBook Publisher
# software). Display some information about .imp file and prints out to stdout.
# Should redirect to log file, if warranted.
#

$usage='infoIMP.pl impfilename';
die "Usage:  $usage\n" if $#ARGV != 0;

use Win32::OLE;
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

###################################################################
#
# get the interface, complain and quit if we cannot
#
$impfile = Win32::OLE->new("SBPublisher.ImpFile") or
	die "Unable to get IImpFile interface\n";

###################################################################
#
# Load the IMP File
#
$impfile->Initialize($ARGV[0]);
if (Win32::OLE->LastError() != 0) {
	print "Unable to load IMP.\n";
	exit(0);
}

###################################################################
#
# Get the desired information from the IMP
#
printf("%-20s : %s\n", "Filename", $ARGV[0]);
printf("%-20s : %s\n", "Title", $impfile->{Title});
printf("%-20s : %s\n", "Author", $impfile->{Author});
printf("%-20s : %s\n", "AdditionalBookInfo", $impfile->{AdditionalBookInfo});
printf("%-20s : %s\n", "BookID", $impfile->{BookID});
printf("%-20s : %d\n", "BookVersion", $impfile->{BookVersion});
printf("%-20s : %s\n", "Category", $impfile->{Category});
printf("%-20s : %d\n", "CompressionType", $impfile->{CompressionType});
printf("%-20s : %d\n", "DeviceDepth", $impfile->{DeviceDepth});
printf("%-20s : %d\n", "DeviceHeight", $impfile->{DeviceHeight});
printf("%-20s : %d\n", "DeviceWidth", $impfile->{DeviceWidth});
printf("%-20s : %d\n", "DeviceModel", $impfile->{DeviceModel});
printf("%-20s : %d\n", "EncryptionType", $impfile->{EncryptionType});
printf("\n");

Win32::OLE->Uninitialize();