#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Modified code taken directly from "SBPubX.doc" (installed by the eBook Publisher
# software).  Given a single .html it creates .opf project file for later use as well
# as .IMP for REB 1200; can change the latter to GEB/EBW 1150 or REB 1100 by
# uncommenting the {BuildTarget} lines below.

package main;
use Win32::OLE;
use Win32::OLE qw(EVENTS);
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

$usage='Html2imp.pl Authorname Title Category htmlfilename';
die "Usage:  $usage\n" if $#ARGV != 3;

###################################################################
#
# get the interfaces, complain and quit if we cannot
#
$project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface\n";

$builder = Win32::OLE->new("SBPublisher.Builder") or
	die "Unable to get IBuilder interface\n";

# Setup the event handling.
#
Win32::OLE->WithEvents($builder, 'EventHandlers');

###################################################################
#
# Create a new project and add our document file with optional cover.
#
$project->ClearAll();
#$project->AddSourceFile("cover.htm");
$project->AddSourceFile($ARGV[3]);
 

###################################################################
#
# Set the various "metadata" items for the publication
#
$project->{AuthorFirstName} = $ARGV[0];
$project->{BookTitle}       = $ARGV[1];
$project->{Category}        = $ARGV[2];
#$project->{ISBN} = $project->CanonicalizeISBN("0448163004 ");
#$project->{BISAC} = "FIC004000";

###################################################################
#
# Now build the OEBFF output
#
$project->{OutputDirectory} = ".";
$project->{Compress}        = 1;   #True
$project->{Encrypt}         = 0;   #False
$project->{KeepAnchors}     = 1;   #True
$project->{Language}        = "en";
$project->{RequireISBN}     = 0;   #False
$project->{Zoom}            = 2;

###################################################################
#
# Now build the REB 1200 (FullVga) .IMP output
#$project->{BookFileName}    = $ARGV[3] . "_1200";
#$project->{BookFileName}    = $ARGV[0] . " - " . $ARGV[1] . "_1200";
#$project->Save($ARGV[3] . "_1200.opf");
#$project->Save($ARGV[0] . " - " . $ARGV[1] . "_1200.opf");
#
#$project->{BuildTarget}     = 1;
#
# Now generate both the OEBFF and/or .IMP output
#$builder->GenerateOEBFF($project, 1);
#$builder->Build($project);
#if (Win32::OLE->LastError() != 0) {
#	print "ERROR: GenerateOEBFF/Build method failed for REB 1200.\n";
#} else {
#	print "REB 1200 ebook created!\n";
#}

###################################################################
#
# Now (optionally) build the EBW/GEB 1150 (gray HalfVga) .IMP output
#
#$project->{BookFileName}    = $ARGV[3];
$project->{BookFileName}    = $ARGV[0] . " - " . $ARGV[1];
#$project->Save($ARGV[3] . ".opf");
$project->Save($ARGV[0] . " - " . $ARGV[1] . ".opf");
#
$project->{BuildTarget} = 2;
#
# Now generate both the OEBFF and/or .IMP output
#$builder->GenerateOEBFF($project, 1);
$builder->Build($project);
if (Win32::OLE->LastError() != 0) {
	print "ERROR: GenerateOEBFF/Build method failed for EBW 1150.\n";
} else {
	print "EBW 1150 ebook created!\n";
}

###################################################################
#
# Now (optionally) build the REB 1100 (mono HalfVGA) .RB output
#
#$project->{BookFileName}    = $ARGV[3];
#$project->{BookFileName}    = $ARGV[0] . " - " . $ARGV[1];
#$project->Save($ARGV[3] . ".opf");
#$project->Save($ARGV[0] . " - " . $ARGV[1] . ".opf");
#
#$project->{BuildTarget} = 3;
#
# Now generate the .RB output
#$builder->Build($project);
#if (Win32::OLE->LastError() != 0) {
#	print "ERROR: Build method failed for REB 1100.\n";
#} else {
#	print "REB 1100 ebook created!\n";
#}

Win32::OLE->Uninitialize();

###################################################################
#
# Event Handlers
#
package EventHandlers;

sub OnBuildStart()
{
	my ($project, @args) = @_;
#	print "Beginning validation...\n";
}

sub OnSourceStart()
{
	my ($builder, $filename, @args) = @_;
#	print "Parsing $filename...\n";
}

sub OnError()
{
	# Get the arguments
	my ($builder,
		$filename, 
		$msg, 
		$line, 
		$col, 
		$severity, 
		@args) = @_;

	my @severities = ("NOTE", "FATAL ERROR", "ERROR", "WARNING");

	if ($filename =~ m/^.+[\\|\/](.+?)$/) { $filename = $1; }

	# Print out the error message including any NOTE feedback.
	# To ignore Warnings, change below to: if ($severity < 3)
	if ($severity >= 0)
	{
		printf(" %-15s (L:%6d, C:%6d) %-7s:",
			$filename,
			$line,
			$col,
			$severities[$severity]);

		print " $msg\n";
	}
}