#!/usr/bin/env  python

import os
import sys
import subprocess
import string
import unicodedata
import logging

try:
   program_name = os.path.basename(__file__)
   program_name = program_name.split('.',1)[0]
except:
   program_name = "AutoCrop"

# Set logfile to '' or a valid path and filename on your system or this script will fail
# logfile = '/Users/posiwid/Development/AC.log'
logfile = ''

# Must specify the location of briss-0.9.jar on your system
path_to_briss = '/Applications/ebook tools/briss-0.9/briss-0.9.jar'

##### Define Methods #####

# Method to remove character accents
def remove_accents(input_str):
    nkfd_form = unicodedata.normalize('NFKD', input_str)
    return u"".join([c for c in nkfd_form if not unicodedata.combining(c)])

###### Main Body of Program ######

# set up logging
logger = logging.getLogger(program_name)
logger.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(name)-6s - %(levelname)-5s - %(message)s')
if logfile != '':
   fh = logging.FileHandler(logfile) 
   fh.setLevel(logging.DEBUG) 
   fh.setFormatter(formatter)
   logger.addHandler(fh)

ch = logging.StreamHandler()
ch.setLevel(logging.INFO)
ch.setFormatter(formatter)
logger.addHandler(ch)

logger.info('##### Started %s Process #####', program_name)

if os.path.isfile(path_to_briss):
   logger.info('Found Briss')
else:
   logger.error('Cannot find Briss')
   logger.info('##### Terminating %s Conversion #####', program_name)
   sys.exit()

if len(sys.argv) > 1:
   book = sys.argv[1]
   logger.debug('Found Book Name: %s', book)
else:
   logger.debug('NO BOOK FOUND')
   logger.info('##### Terminating %s Conversion #####', program_name)
   sys.exit()

# Set up working environment; change to directory where book resides
try:
   target_dir = os.path.dirname(book)
   logger.info('Path Basename of Book is: %s', target_dir)
   os.chdir(target_dir)
except:
   logger.info('%s is running locally', program_name)
cwdir = os.getcwd()
logger.info('Current Working Directory is: %s', cwdir)

# Check if file matching variable book is present
logger.debug('Checking Book File: %s', book)
if os.path.isfile(book):
   logger.debug('Book Exists!')
else:
   logger.debug('Book File: %s NOT FOUND', book)
   logger.info('##### Terminating %s Conversion #####', program_name)
   sys.exit()

try:
   idstr = cwdir.rsplit('(',1)[1]
   idstr = idstr.rsplit(')',1)[0]
   # this will fail if we haven't found a number
   truetest = int(idstr)
   dbid = ''.join(ele for ele in idstr if ele.isdigit())
   logger.info('Found ID: %s', dbid)
except:
   logger.info('FAILURE: ID Not Found')
   logger.info('##### Terminating %s Conversion #####', program_name)
   sys.exit()

# Since we have an ID in Calibre database, proceed to set up for conversion
converted_book_name = 'cropfile.pdf'
# we use an intermediate file due to difficulty building command string when files have spaces
original_to_crop = 'FileToConvert.pdf'

logger.info('Attempting Rename from %s to %s', book, original_to_crop)
os.rename(book,original_to_crop)
logger.info('Book to Submit is: %s',book)
path_to_briss = path_to_briss.replace(' ','\ ')
command = 'java -Xms128m -Xmx1024m -jar ' + path_to_briss + ' -s ' + original_to_crop + ' -d ' + converted_book_name
logger.info('Calling Briss with command %s',command)
try: 
   output = subprocess.check_output(command, shell=True)
except:
   logger.error('Failed to convert %s',book)
   os.rename(original_to_crop, book)
   try:
      os.remove(converted_book_name)
   except:
      pass
   logger.info('##### Terminating %s Conversion #####', program_name)
   sys.exit()

logger.info(output)
if 'Error' in output:
   logger.error('Failed to convert %s',book)
   os.rename(original_to_crop, book)
   try:
      os.remove(converted_book_name)
   except:
      pass
   logger.info('##### Terminating %s Conversion #####', program_name)
   sys.exit()

# we have successfully converted book, proceed with updating calibre database  
# format_type is the new format that will be added to the Calibre database
format_type = 'original_pdf'
original_book_name = book.rsplit('.',1)[0] + "." + format_type
# move the original file to its new file name
logger.info('Original Book Filename will be: %s', original_book_name)
os.rename(original_to_crop,original_book_name)
# update Calibre databse
command_args = ["calibredb", "add_format", "--dont-replace", dbid, original_book_name]
logger.debug('Command Args: %s', command_args)
logger.info('Upating Calibre Book ID: %s', dbid)
output = subprocess.check_output(command_args)
logger.debug(output)

if 'Notifying' in output:
   logger.info('SUCCESS!')
   # moving converted file to book name
   os.rename(converted_book_name, book)

if 'exists' in output:
   logger.info('Format Type already exists... Filenames reverting')
   os.rename(original_book_name,book)
   os.remove(converted_book_name)

logger.info('##### Completed %s Conversion #####', program_name)
