#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
Firmware_iLiad=`cat /etc/er_version_commercial`
cd $scriptdir
Firmware_Script=`cat Firmware_Script`

# Log file
LOGFILE=./install-log.txt
rm $LOGFILE
# Dump everything from now on to the log file
exec 1>> $LOGFILE 2>> $LOGFILE

if [ "$Firmware_iLiad" = "$Firmware_Script" ]; then
	cp /mnt/settings/registry/registry.xml ./registry.xml.orig
	cp /mnt/settings/registry/registry.xml ./registry.xml.new
    registry-application-remove --verbose --file=registry.xml.new FBREADER
    registry-application-install --appCategory=viewer --execute=/usr/bin/fbreader.sh --exticon=/usr/share/contentlister/Icon_books.png --argMask="_FILENAME_" --ipcChannel=14 --xResourceName=sh --verbose --file=registry.xml.new FBREADER chm rtf oebzip zip epub fb2 tcr
	cp ./registry.xml.new /mnt/settings/registry/registry.xml
	mv manifest.xml install.xml
	mv done.xml manifest.xml
else
	# wrong firmware version
	# script is deactivated, error message
	cat wrong_fw.xml | sed -e "s/Firmware_Script_xml/$Firmware_Script/" > wrong_fw.xml
	cat wrong_fw.xml | sed -e "s/Firmware_iLiad_xml/$Firmware_iLiad/" > wrong_fw.xml
	mv manifest.xml install.xml
	mv wrong_fw.xml manifest.xml
fi
