#!/usr/bin/env python
# -*- coding: utf-8 -*-


import Tkconstants, tkFileDialog, tkMessageBox, ttk
from Tkinter import *
import os, sys
import re, htmlentitydefs
from uuid import uuid4
from lib2to3.pgen2.tokenize import String


class Application_UI(Frame):

	def __init__(self,parent,bk):
		Frame.__init__(self,parent)
		object.__init__(self,bk)
		self.parent = parent
		self.bk = bk
		self.createWidgets()
		
	def createWidgets(self):
	   
		self.body = self.winfo_toplevel()
		
		self.topFrame = Frame(self.body, height=20, width=20)
		self.lblSelect=Label(self.topFrame, text="Select the files:").grid(row = 0,column = 0)
		self.flagAll = IntVar()
		self.flagAll.set(0)
		self.ckbAll = Checkbutton(self.topFrame, text="All", variable = self.flagAll, command = self.selectAll).grid(row = 0,column = 1)
		self.topFrame.pack(expand=True, fill=X, side=TOP) 
                
		self.centerFrame = Frame(self.body,height=20,width=20)
		self.yScroll = Scrollbar(self.centerFrame, orient=VERTICAL)
		self.yScroll.grid(row=0, column=1, sticky=N+S)
		self.xScroll = Scrollbar(self.centerFrame, orient=HORIZONTAL)
		self.xScroll.grid(row=1, column=0, sticky=E+W)
		self.lstFiles = Listbox(self.centerFrame, selectmode=MULTIPLE, width=30, xscrollcommand=self.xScroll.set,yscrollcommand=self.yScroll.set)
		for (ID , href) in self.bk.text_iter(): 
			self.lstFiles.insert(END,ID)
		self.lstFiles.grid(row = 0, column = 0)
		self.xScroll['command'] = self.lstFiles.xview
		self.yScroll['command'] = self.lstFiles.yview
		self.centerFrame.pack(expand=True, fill=X, side=TOP)
		
		self.bottomFrame = Frame(self.body, height=30, width=50)
		self.btnCancel=Button(self.bottomFrame,text="Quit",height=0,width=6, command=self.applyQuit).pack(side=RIGHT)
		self.btnSelect=Button(self.bottomFrame,text="Apply",height=0,width=6,command=self.applySelect).pack(side=RIGHT)
		self.bottomFrame.pack(expand=True, fill=X, side=TOP)
		  
class Application(Application_UI):

	def selectAll(self):
		if self.flagAll.get() == True:
			self.lstFiles.configure(state = DISABLED)
		else:
			self.lstFiles.configure(state = NORMAL)
		
	def applySelect(self):
	
		if self.flagAll.get() == True:
			for (ID, href) in self.bk.text_iter():
				html = self.bk.readotherfile(ID)
				r = Remove(html)
				html_new = r.get_html()
				self.bk.writeotherfile(ID,html_new)
		else:
			
			for i in self.lstFiles.curselection():
				print(self.lstFiles.get(i))
				html = self.bk.readotherfile(self.lstFiles.get(i))
				r = Remove(html)
				html_new = r.get_html()
				self.bk.writeotherfile(self.lstFiles.get(i),html_new)		
			
		tkMessageBox.showinfo("Done!","Done!")
					
	def applyQuit(self):
		self.parent.destroy()
		
			
class Remove:

	def __init__(self, html_code):
		String.__init__(self, html_code)        
		self.html_code = html_code
		self.OPENTAG = ['<p','<b','<i','<u','<h1','<h2','<h3','<h4','<h5','<h6','<ol','<ul','<li','<body']
		self.CLOSETAG = ['</p>','</b','</i>','</u>','</h1>','</h2>','</h3>','</h4>','</h5>','</h6>','</ol>','</ul>','</li>','</body>','</html>']

	def get_html(self):
		HTML = ''
		elements = re.split(r'(<.*?>)', self.html_code)
		find_body = False
		for tag in elements:
			if tag[0:5] == '<body':
				find_body = True
			if tag[0:5] != '<body' and not find_body:
				HTML += tag
				continue
			if tag[0:1] == '<' and tag[-1] == '>':
				if tag[-2:] == '/>':
					pass
				elif tag[0:5] in self.OPENTAG:
					tag = tag[0:5] + '>'
				elif tag[0:2] in self.OPENTAG:
					tag = tag[0:2] + '>'
				elif tag[0:3] in self.OPENTAG:
					tag = tag[0:3] + '>'
				elif tag in self.CLOSETAG:
					pass
				else:
					tag = ''
				HTML += tag
			else:
				HTML += tag
		return HTML


def run(bk):
	window = Tk()
	Application(window,bk).mainloop()
	return 0

def main():
	print 'I reached main when I should not have\n'
	return -1
	
if __name__ == "__main__":
	sys.exit(main())